/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.exoplatform.commons.utils.CharEncoder;

public class CharsetCharEncoder
implements CharEncoder {
    private static final CharEncoder UTF8 = new CharsetCharEncoder(Charset.forName("UTF8"));
    private static final byte[] EMPTY = new byte[0];
    private final Charset charset;
    private final CharBuffer in;
    private final ByteBuffer out;
    private final byte[][] arrays;

    public static CharEncoder getUTF8() {
        return UTF8;
    }

    public CharsetCharEncoder(Charset charset) {
        this.charset = charset;
        this.in = CharBuffer.allocate(1);
        this.out = ByteBuffer.allocate(100);
        this.arrays = new byte[][]{new byte[0], new byte[1], new byte[2], new byte[3], new byte[4], new byte[5]};
    }

    public byte[] encode(char c) {
        try {
            CharsetEncoder encoder = this.charset.newEncoder();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, encoder);
            writer.write(c);
            writer.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

