/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.OutputStream;
import org.exoplatform.commons.utils.Printer;
import org.exoplatform.commons.utils.TextEncoder;

public class OutputStreamPrinter
extends Printer {
    private final OutputStream out;
    private final TextEncoder encoder;

    public OutputStreamPrinter(TextEncoder encoder, OutputStream out) throws IllegalArgumentException {
        if (encoder == null) {
            throw new IllegalArgumentException("No null encoder accepted");
        }
        if (out == null) {
            throw new IllegalArgumentException("No null output stream accepted");
        }
        this.encoder = encoder;
        this.out = out;
    }

    public void write(int c) throws IOException {
        this.encoder.encode((char)c, this.out);
    }

    public void write(char[] cbuf) throws IOException {
        this.encoder.encode(cbuf, 0, cbuf.length, this.out);
    }

    public void write(String str) throws IOException {
        this.encoder.encode(str, 0, str.length(), this.out);
    }

    public void write(String str, int off, int len) throws IOException {
        this.encoder.encode(str, off, len, this.out);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.encoder.encode(cbuf, off, len, this.out);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

