/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.exoplatform.commons.utils.CharEncoder;
import org.exoplatform.commons.utils.CharsetCharEncoder;
import org.exoplatform.commons.utils.TableCharEncoder;
import org.exoplatform.commons.utils.TextEncoder;

public class CharsetTextEncoder
implements TextEncoder {
    private static final CharsetTextEncoder UTF8 = new CharsetTextEncoder(CharsetCharEncoder.getUTF8());
    private final CharEncoder charEncoder;

    public static TextEncoder getUTF8() {
        return UTF8;
    }

    public CharsetTextEncoder(CharEncoder charEncoder) {
        this.charEncoder = charEncoder;
    }

    public CharsetTextEncoder(String encoding) {
        this(new TableCharEncoder(new CharsetCharEncoder(Charset.forName(encoding))));
    }

    public void encode(char c, OutputStream out) throws IOException {
        byte[] bytes = this.charEncoder.encode(c);
        out.write(bytes);
    }

    public void encode(char[] chars, int off, int len, OutputStream out) throws IOException {
        for (int i = off; i < len; ++i) {
            char c = chars[i];
            byte[] bytes = this.charEncoder.encode(c);
            out.write(bytes);
        }
    }

    public void encode(String str, int off, int len, OutputStream out) throws IOException {
        for (int i = off; i < len; ++i) {
            char c = str.charAt(i);
            byte[] bytes = this.charEncoder.encode(c);
            out.write(bytes);
        }
    }
}

