/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import org.exoplatform.commons.utils.Safe;

public class IOUtil {
    private static final int DEFAULT_BUFFER_SIZE = 256;

    public static String getFileContentAsString(File file) throws IOException, NullPointerException {
        return IOUtil.getFileContentAsString(file, "UTF-8");
    }

    public static String getFileContentAsString(File file, String charset) throws IOException, NullPointerException {
        if (file == null) {
            throw new NullPointerException("No null file accepted");
        }
        FileInputStream is = new FileInputStream(file);
        return new String(IOUtil.getStreamContentAsBytes(is), charset);
    }

    public static String getFileContentAsString(String fileName, String charset) throws IOException, NullPointerException {
        if (fileName == null) {
            throw new NullPointerException("No null file name accepted");
        }
        return IOUtil.getFileContentAsString(new File(fileName), charset);
    }

    public static String getFileContentAsString(String fileName) throws IOException, NullPointerException {
        return IOUtil.getFileContentAsString(fileName, "UTF-8");
    }

    public static String getStreamContentAsString(InputStream is) throws IOException, NullPointerException {
        byte[] buf = IOUtil.getStreamContentAsBytes(is);
        return new String(buf, "UTF-8");
    }

    public static byte[] getFileContentAsBytes(String fileName) throws IOException, NullPointerException {
        if (fileName == null) {
            throw new NullPointerException("No null file name accepted");
        }
        FileInputStream is = new FileInputStream(fileName);
        return IOUtil.getStreamContentAsBytes(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getStreamContentAsBytes(InputStream is) throws IOException, NullPointerException {
        if (is == null) {
            throw new NullPointerException("No null input stream accepted");
        }
        try {
            int available;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] data = new byte[256];
            while ((available = is.read(data)) > -1) {
                output.write(data, 0, available);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            Safe.close(is);
        }
    }

    public static String getResourceAsString(String resource) throws IOException {
        byte[] bytes = IOUtil.getResourceAsBytes(resource);
        return new String(bytes, "UTF-8");
    }

    public static byte[] getResourceAsBytes(String resource) throws IOException {
        if (resource == null) {
            throw new NullPointerException("Cannot provide null resource values");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(resource);
        if (url == null) {
            throw new NullPointerException("The resource " + resource + " was not found in the thread context classloader");
        }
        InputStream is = url.openStream();
        return IOUtil.getStreamContentAsBytes(is);
    }

    @Deprecated
    public static byte[] serialize(Object obj) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(obj);
        out.close();
        byte[] ret = bytes.toByteArray();
        return ret;
    }

    @Deprecated
    public static Object deserialize(byte[] bytes) throws Exception {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(is);
        Object obj = in.readObject();
        in.close();
        return obj;
    }

    @Deprecated
    public static String getFileContenntAsString(File file) throws Exception {
        return IOUtil.getFileContentAsString(file);
    }

    @Deprecated
    public static String getFileContenntAsString(File file, String encoding) throws Exception {
        return IOUtil.getFileContentAsString(file, encoding);
    }

    @Deprecated
    public static String getFileContenntAsString(String fileName, String encoding) throws Exception {
        return IOUtil.getFileContentAsString(fileName, encoding);
    }

    @Deprecated
    public static String getFileContenntAsString(String fileName) throws Exception {
        return IOUtil.getFileContentAsString(fileName);
    }
}

