/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.log;

import java.util.Properties;

/**
 * Created by The eXo Platform SAS. <br/> An interface for log system
 * configuration
 * 
 * @author <a href="mailto:gennady.azarenkov@exoplatform.com">Gennady
 *         Azarenkov</a>
 * @version $Id: LogConfigurator.java 33214 2009-06-30 16:08:20Z pnedonosko $
 */

public interface LogConfigurator {
  /**
   * Configures a concrete log system implementation using properties list
   * 
   * @param properties
   */
  void configure(Properties properties);

  /**
   * @return current properties
   */
  Properties getProperties();
}
