/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipUtil {
    private final int BUFFER = 2048;
    private byte[] data = new byte[2048];

    public void addToArchive(File input, File output, boolean containParent) throws Exception {
        ByteArrayOutputStream byteOutput = this.addToArchive(input, containParent);
        output = this.createFile(output, false);
        byteOutput.writeTo(new FileOutputStream(output));
        byteOutput.close();
    }

    public ByteArrayOutputStream addToArchive(File input, boolean containParent) throws Exception {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        this.addToArchive(input, byteOutput, containParent).close();
        return byteOutput;
    }

    public ZipOutputStream addToArchive(File input, OutputStream output, boolean containParent) throws Exception {
        String path = input.getAbsolutePath();
        ZipOutputStream zipOutput = new ZipOutputStream(output);
        BufferedInputStream bufInput = null;
        List<File> list = this.listFile(input);
        if (input.isDirectory()) {
            list.remove(input);
        }
        if (list == null || list.size() < 1) {
            return zipOutput;
        }
        for (File f : list) {
            String filePath = f.getAbsolutePath();
            if (filePath.startsWith(path)) {
                filePath = containParent && input.isDirectory() ? input.getName() + File.separator + filePath.substring(path.length() + 1) : (input.isDirectory() ? filePath.substring(path.length() + 1) : input.getName());
            }
            if (f.isFile()) {
                FileInputStream fileInput = new FileInputStream(f);
                bufInput = new BufferedInputStream(fileInput, 2048);
            } else {
                filePath = filePath + "/";
            }
            this.addToArchive(zipOutput, bufInput, filePath);
            if (bufInput == null) continue;
            bufInput.close();
        }
        return zipOutput;
    }

    public ByteArrayOutputStream addToArchive(InputStream input, String entryName) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ZipOutputStream zipOutput = new ZipOutputStream(output);
        this.addToArchive(zipOutput, input, entryName);
        zipOutput.close();
        return output;
    }

    public ZipOutputStream addToArchive(ZipOutputStream zipOutput, InputStream input, String entryName) throws Exception {
        ZipEntry entry = new ZipEntry(entryName);
        zipOutput.putNextEntry(entry);
        if (input != null) {
            int count;
            while ((count = input.read(this.data, 0, 2048)) != -1) {
                zipOutput.write(this.data, 0, count);
            }
        }
        zipOutput.closeEntry();
        return zipOutput;
    }

    public ZipOutputStream addToArchive(ZipOutputStream zipOutput, byte[] d, String entryName) throws Exception {
        ZipEntry entry = new ZipEntry(entryName);
        zipOutput.putNextEntry(entry);
        if (d != null && d.length > 0) {
            zipOutput.write(d);
        }
        zipOutput.closeEntry();
        return zipOutput;
    }

    public void extractFromArchive(File input, String output) throws Exception {
        ZipEntry entry;
        BufferedOutputStream dest = null;
        FileInputStream fileInput = new FileInputStream(input);
        ZipInputStream zipInput = new ZipInputStream(new BufferedInputStream(fileInput));
        FileOutputStream fileOuput = null;
        while ((entry = zipInput.getNextEntry()) != null) {
            int count;
            if (entry.isDirectory()) {
                this.createFile(new File(output + entry.getName()), true);
                continue;
            }
            fileOuput = output != null ? new FileOutputStream(this.createFile(new File(output + entry.getName()), false)) : new FileOutputStream(this.createFile(new File(entry.getName()), false));
            dest = new BufferedOutputStream(fileOuput, 2048);
            while ((count = zipInput.read(this.data, 0, 2048)) != -1) {
                dest.write(this.data, 0, count);
            }
            dest.close();
        }
        zipInput.close();
    }

    private File createFile(File file, boolean folder) throws Exception {
        if (file.getParentFile() != null) {
            this.createFile(file.getParentFile(), true);
        }
        if (file.exists()) {
            return file;
        }
        if (file.isDirectory() || folder) {
            file.mkdir();
        } else {
            file.createNewFile();
        }
        return file;
    }

    private List<File> listFile(File dir) {
        final ArrayList<File> list = new ArrayList<File>();
        if (dir.isFile()) {
            list.add(dir);
            return list;
        }
        dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    list.addAll(ZipUtil.this.listFile(f));
                }
                list.add(f);
                return true;
            }
        });
        return list;
    }
}

