/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils.secure;

import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureSet<E>
implements Set<E> {
    private final Set<E> set;
    private final Permission permission;

    public SecureSet(Permission permission) {
        this.set = new HashSet();
        this.permission = permission;
    }

    public SecureSet(Set<E> set, Permission permission) {
        this.set = set;
        this.permission = permission;
    }

    @Override
    public boolean add(E e) {
        this.checkPermission();
        return this.set.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        this.checkPermission();
        return this.set.addAll(elements);
    }

    @Override
    public void clear() {
        this.checkPermission();
        this.set.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.set.containsAll(coll);
    }

    @Override
    public boolean equals(Object o) {
        return o == this || this.set.equals(o);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<? extends E> i;
            {
                this.i = SecureSet.this.set.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public E next() {
                return this.i.next();
            }

            @Override
            public void remove() {
                SecureSet.this.checkPermission();
                this.i.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        this.checkPermission();
        return this.set.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> pds) {
        this.checkPermission();
        return this.set.removeAll(pds);
    }

    @Override
    public boolean retainAll(Collection<?> pds) {
        this.checkPermission();
        return this.set.retainAll(pds);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    public String toString() {
        return this.set.toString();
    }

    private void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(this.permission);
        }
    }
}

