/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ISO8601 {
    protected static final String TZD = "TZD";
    public static final String YEAR_FORMAT = "yyyy";
    public static final String YEARMONTH_FORMAT = "yyyy-MM";
    public static final String COMPLETE_DATE_FORMAT = "yyyy-MM-dd";
    public static final String SIMPLE_DATEHOURSMINUTES_FORMAT = "yyyy-MM-dd'T'HH:mm";
    public static final String COMPLETE_DATEHOURSMINUTESZRFC822_FORMAT = "yyyy-MM-dd'T'HH:mmZ";
    public static final String COMPLETE_DATEHOURSMINUTESZ_FORMAT = "yyyy-MM-dd'T'HH:mmTZD";
    public static final String SIMPLE_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String COMPLETE_DATETIMEZRFC822_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String COMPLETE_DATETIMEZ_FORMAT = "yyyy-MM-dd'T'HH:mm:ssTZD";
    public static final String SIMPLE_DATETIMEMS_FORMAT_1 = "yyyy-MM-dd'T'HH:mm:ss.SS";
    public static final String SIMPLE_DATETIMEMS_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String COMPLETE_DATETIMEMSZRFC822_FORMAT_1 = "yyyy-MM-dd'T'HH:mm:ss.SSZ";
    public static final String COMPLETE_DATETIMEMSZRFC822_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String COMPLETE_DATETIMEMSZ_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSTZD";
    public static final String COMPLETE_DATETIMEMSZ_FORMAT_1 = "yyyy-MM-dd'T'HH:mm:ss.SSTZD";
    public static final String[] FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSTZD", "yyyy-MM-dd'T'HH:mm:ss.SSTZD", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SS", "yyyy-MM-dd'T'HH:mm:ssTZD", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mmTZD", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy"};
    public static final String[] LEGACY_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSTZD", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ssTZD", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mmTZD", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy"};
    private static final String UNKNOWN_TIME_ZONE = "Unknown";

    public static String format(Calendar date) {
        try {
            return new ISODateFormat(COMPLETE_DATETIMEMSZ_FORMAT).format(date);
        }
        catch (Exception e) {
            return new LegacyISODateFormat(COMPLETE_DATETIMEMSZ_FORMAT).format(date);
        }
    }

    public static Calendar parse(String dateString) {
        try {
            return ISO8601.parseEx(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Calendar parseEx(String dateString) throws ParseException, NumberFormatException {
        try {
            return ISO8601.parse(dateString, FORMATS);
        }
        catch (Exception e) {
            return ISO8601.parse(dateString, LEGACY_FORMATS, true);
        }
    }

    public static Calendar parse(String dateString, String[] formats) throws ParseException, NumberFormatException {
        return ISO8601.parse(dateString, formats, false);
    }

    private static Calendar parse(String dateString, String[] formats, boolean isLegacyParser) throws ParseException {
        StringBuilder problems = new StringBuilder();
        int errorIndex = 0;
        for (String format : formats) {
            try {
                Calendar isoDate = isLegacyParser ? new LegacyISODateFormat(format).parse(dateString) : new ISODateFormat(format).parse(dateString);
                return isoDate;
            }
            catch (DateTimeParseException e) {
                if (errorIndex == 0) {
                    errorIndex = e.getErrorIndex();
                }
                ISO8601.appendError(problems, format, e.getErrorIndex(), e.getMessage());
            }
            catch (ParseException e) {
                if (errorIndex == 0) {
                    errorIndex = e.getErrorOffset();
                }
                ISO8601.appendError(problems, format, e.getErrorOffset(), e.getMessage());
            }
            catch (NumberFormatException e) {
                errorIndex = 0;
                problems.append(format);
                problems.append(" - ");
                problems.append(e.getMessage());
                problems.append(" \n");
            }
        }
        throw new ParseException("Can not parse " + dateString + " as Date. " + problems.toString(), errorIndex);
    }

    private static void appendError(StringBuilder problems, String format, int index, String message) {
        problems.append(format);
        problems.append(" - ");
        problems.append(message);
        problems.append(", error index ");
        problems.append(index);
        problems.append(" \n");
    }

    private static class LegacyISODateFormat {
        private final SimpleDateFormat formater;
        private final String format;
        private final boolean isoTZ;

        LegacyISODateFormat(String format) {
            this.isoTZ = format.endsWith(ISO8601.TZD);
            this.format = this.isoTZ ? format.substring(0, format.length() - ISO8601.TZD.length()) + "Z" : format;
            this.formater = new SimpleDateFormat(this.format, Locale.US);
        }

        public Calendar parse(String dateString) throws ParseException, NumberFormatException {
            Date isoDate = null;
            TimeZone timeZone = null;
            if (dateString.length() >= 16) {
                int index;
                if (this.isoTZ) {
                    if (dateString.endsWith("Z")) {
                        dateString = dateString.substring(0, dateString.length() - 1) + "+0000";
                    } else {
                        int tzsindex = dateString.length() - 6;
                        char tzsign = dateString.charAt(tzsindex);
                        if (tzsign == '+' || tzsign == '-') {
                            dateString = dateString.substring(0, tzsindex) + dateString.substring(tzsindex).replaceAll(":", "");
                        }
                    }
                }
                if ((index = dateString.lastIndexOf(45)) >= 16 || (index = dateString.lastIndexOf(43)) >= 16) {
                    String timeZoneStr = dateString.substring(index);
                    timeZone = TimeZone.getTimeZone("GMT" + timeZoneStr);
                    this.formater.setTimeZone(timeZone);
                }
            }
            isoDate = this.formater.parse(dateString);
            Calendar isoCalendar = Calendar.getInstance();
            isoCalendar.setTime(isoDate);
            if (timeZone != null) {
                isoCalendar.setTimeZone(timeZone);
            }
            return isoCalendar;
        }

        public String format(Calendar source) {
            if (this.isoTZ) {
                this.formater.setTimeZone(source.getTimeZone());
                String formatedDate = this.formater.format(source.getTime());
                if (formatedDate.endsWith("0000")) {
                    return formatedDate.substring(0, formatedDate.length() - 5) + "Z";
                }
                int dindex = formatedDate.length() - 2;
                return formatedDate.substring(0, dindex) + ":" + formatedDate.substring(dindex);
            }
            return this.formater.format(source);
        }
    }

    protected static class ISODateFormat {
        private final DateTimeFormatter formater;
        private final String format;
        private final boolean isoTZ;

        ISODateFormat(String format) {
            this.isoTZ = format.endsWith(ISO8601.TZD);
            this.format = this.isoTZ ? format.substring(0, format.length() - ISO8601.TZD.length()) + "Z" : format;
            this.formater = this.format.equals(ISO8601.YEARMONTH_FORMAT) || this.format.equals(ISO8601.YEAR_FORMAT) ? DateTimeFormatter.ofPattern(ISO8601.COMPLETE_DATE_FORMAT, Locale.US) : DateTimeFormatter.ofPattern(this.format, Locale.US);
        }

        public Calendar parse(String dateString) throws ParseException, NumberFormatException {
            Instant instant = null;
            TimeZone timeZone = null;
            if (dateString.length() >= 16) {
                int index;
                if (this.isoTZ) {
                    if (dateString.endsWith("Z")) {
                        dateString = dateString.substring(0, dateString.length() - 1) + "+0000";
                    } else {
                        int tzsindex = dateString.length() - 6;
                        char tzsign = dateString.charAt(tzsindex);
                        if (tzsign == '+' || tzsign == '-') {
                            dateString = dateString.substring(0, tzsindex) + dateString.substring(tzsindex).replaceAll(":", "");
                        }
                    }
                }
                if ((index = dateString.lastIndexOf(45)) >= 16 || (index = dateString.lastIndexOf(43)) >= 16) {
                    String timeZoneStr = dateString.substring(index);
                    if (timeZoneStr.length() == 3) {
                        timeZoneStr = timeZoneStr.concat("00");
                        dateString = dateString.concat("00");
                    }
                    timeZone = TimeZone.getTimeZone("GMT" + timeZoneStr);
                    this.formater.withZone(timeZone.toZoneId());
                }
            }
            Calendar isoCalendar = Calendar.getInstance();
            boolean isNegativeDate = false;
            if (dateString.startsWith("-")) {
                isNegativeDate = true;
                dateString = dateString.substring(1, dateString.length());
            }
            if (dateString.length() == 4 && ISO8601.YEAR_FORMAT.equals(this.format)) {
                LocalDate localDate = LocalDate.parse(dateString + "-01-01", this.formater);
                if (isNegativeDate) {
                    localDate.withYear(-localDate.getYear());
                }
                instant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
            } else if (dateString.length() == 7 && ISO8601.YEARMONTH_FORMAT.equals(this.format)) {
                LocalDate localDate = LocalDate.parse(dateString + "-01", this.formater);
                if (isNegativeDate) {
                    localDate.withYear(-localDate.getYear());
                }
                instant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
            } else if (ISO8601.COMPLETE_DATE_FORMAT.equals(this.format)) {
                LocalDate localDate = LocalDate.parse(dateString, this.formater);
                if (isNegativeDate) {
                    localDate.withYear(-localDate.getYear());
                }
                instant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
            } else if (timeZone != null) {
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateString, this.formater);
                if (isNegativeDate) {
                    zonedDateTime.withYear(-zonedDateTime.getYear());
                }
                instant = zonedDateTime.toInstant();
            } else {
                instant = LocalDateTime.parse(dateString, this.formater).atZone(ZoneId.systemDefault()).toInstant();
            }
            isoCalendar.setTime(Date.from(instant));
            if (timeZone != null) {
                isoCalendar.setTimeZone(timeZone);
            }
            return isoCalendar;
        }

        public String format(Calendar source) {
            if (this.isoTZ) {
                TimeZone timeZone = source.getTimeZone();
                ZoneId zoneId = timeZone != null && !ISO8601.UNKNOWN_TIME_ZONE.equalsIgnoreCase(timeZone.getID()) ? source.getTimeZone().toZoneId() : ZoneId.systemDefault();
                String formatedDate = ZonedDateTime.ofInstant(source.getTime().toInstant(), zoneId).format(this.formater);
                if (formatedDate.endsWith("0000")) {
                    return formatedDate.substring(0, formatedDate.length() - 5) + "Z";
                }
                int dindex = formatedDate.length() - 2;
                return formatedDate.substring(0, dindex) + ":" + formatedDate.substring(dindex);
            }
            return LocalDateTime.ofInstant(source.toInstant(), ZoneId.systemDefault()).format(this.formater);
        }
    }
}

