/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils.secure;

import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.exoplatform.commons.utils.secure.AbstractSecureCollectionsTest;
import org.exoplatform.commons.utils.secure.SecureCollections;

public class TestSecureSet
extends AbstractSecureCollectionsTest {
    private Set<String> set;

    protected void setUp() throws PrivilegedActionException {
        this.set = SecureCollections.secureSet(new HashSet(), (Permission)MODIFY_PERMISSION);
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureSet.this.set.add("firstString");
                    TestSecureSet.this.set.add("secondString");
                    return null;
                }
            }, MODIFY_PERMISSION);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected void tearDown() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureSet.this.set.clear();
                    return null;
                }
            }, MODIFY_PERMISSION);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void testSecureSetAddPermitted() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureSet.this.set.add("string");
                    return null;
                }
            }, MODIFY_PERMISSION);
        }
        catch (AccessControlException e) {
            TestSecureSet.fail((String)"Modification should be permitted.");
        }
    }

    public void testSecureSetAddDenied() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureSet.this.set.add("string");
                    return null;
                }
            }, new Permission[0]);
            TestSecureSet.fail((String)"Modification should be denied.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void testSecureSetRemoveDenied() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureSet.this.set.remove(0);
                    return null;
                }
            }, new Permission[0]);
            TestSecureSet.fail((String)"Modification should be denied.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void testSecureSetRemovePermitted() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureSet.this.set.remove(0);
                    return null;
                }
            }, MODIFY_PERMISSION);
        }
        catch (AccessControlException e) {
            TestSecureSet.fail((String)"Modification should be permitted.");
        }
    }

    public void testSecureSetIteratorPermitted() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    Iterator<String> iterator = TestSecureSet.this.set.iterator();
                    return null;
                }
            }, MODIFY_PERMISSION);
        }
        catch (AccessControlException e) {
            TestSecureSet.fail((String)"Modification should be permitted.");
        }
    }

    public void testSecureSetIteratorRemovePermitted() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    Iterator<String> iterator = TestSecureSet.this.set.iterator();
                    iterator.next();
                    iterator.remove();
                    return null;
                }
            }, MODIFY_PERMISSION);
        }
        catch (AccessControlException e) {
            TestSecureSet.fail((String)"Modification should be permitted.");
        }
    }

    public void testSecureSetClearDenied() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureSet.this.set.clear();
                    return null;
                }
            }, new Permission[0]);
            TestSecureSet.fail((String)"Modification should be denied.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

