/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.LazyList;
import org.exoplatform.commons.utils.ListAccess;

public class TestLazyList
extends TestCase {
    SimpleListAccess<Integer> access = new SimpleListAccess();
    LazyList<Integer> list = new LazyList(this.access, 3);

    public TestLazyList() {
    }

    public TestLazyList(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        this.access = new SimpleListAccess();
        this.access.add(0);
        this.access.add(1);
        this.access.add(2);
        this.access.add(3);
        this.access.add(4);
        this.access.add(5);
        this.access.add(6);
        this.access.add(7);
        this.access.add(8);
        this.access.add(9);
        this.list = new LazyList(this.access, 3);
    }

    public void loadFailure() {
        try {
            new LazyList(new ListAccess(){

                public Object[] load(int index, int length) throws Exception, IllegalArgumentException {
                    throw new Exception();
                }

                public int getSize() throws Exception {
                    throw new Exception();
                }
            }, 3).get(4);
            TestLazyList.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            new LazyList(new ListAccess(){

                public Object[] load(int index, int length) throws Exception, IllegalArgumentException {
                    throw new Error();
                }

                public int getSize() {
                    throw new Error();
                }
            }, 3).get(4);
            TestLazyList.fail();
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            new LazyList(new ListAccess(){

                public Object[] load(int index, int length) throws Exception, IllegalArgumentException {
                    throw new ClassCastException();
                }

                public int getSize() {
                    throw new ClassCastException();
                }
            }, 3).get(4);
            TestLazyList.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testIllegalArgumentException() {
        try {
            new LazyList(null, 3);
            TestLazyList.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new LazyList(this.access, 0);
            TestLazyList.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new LazyList(this.access, -1);
            TestLazyList.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSize() {
        TestLazyList.assertEquals((int)10, (int)this.list.size());
    }

    public void testOutOfBounds() {
        try {
            this.list.get(-1);
            TestLazyList.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.list.get(10);
            TestLazyList.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testLoading() {
        TestLazyList.assertEquals((int)3, (int)((Integer)this.list.get(3)));
        TestLazyList.assertEquals((int)3, (int)this.access.indexes.removeFirst());
        TestLazyList.assertEquals((int)3, (int)this.access.lengths.removeFirst());
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)5, (int)((Integer)this.list.get(5)));
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)4, (int)((Integer)this.list.get(4)));
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)3, (int)((Integer)this.list.get(3)));
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)9, (int)((Integer)this.list.get(9)));
        TestLazyList.assertEquals((int)9, (int)this.access.indexes.removeFirst());
        TestLazyList.assertEquals((int)1, (int)this.access.lengths.removeFirst());
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)9, (int)((Integer)this.list.get(9)));
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)8, (int)((Integer)this.list.get(8)));
        TestLazyList.assertEquals((int)6, (int)this.access.indexes.removeFirst());
        TestLazyList.assertEquals((int)3, (int)this.access.lengths.removeFirst());
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)7, (int)((Integer)this.list.get(7)));
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)6, (int)((Integer)this.list.get(6)));
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)8, (int)((Integer)this.list.get(8)));
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)1, (int)((Integer)this.list.get(1)));
        TestLazyList.assertEquals((int)0, (int)this.access.indexes.removeFirst());
        TestLazyList.assertEquals((int)3, (int)this.access.lengths.removeFirst());
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)0, (int)((Integer)this.list.get(0)));
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)2, (int)((Integer)this.list.get(2)));
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
        TestLazyList.assertEquals((int)1, (int)((Integer)this.list.get(1)));
        TestLazyList.assertTrue((boolean)this.access.indexes.isEmpty());
        TestLazyList.assertTrue((boolean)this.access.lengths.isEmpty());
    }

    private static class SimpleListAccess<E>
    extends ArrayList<E>
    implements ListAccess<E> {
        private LinkedList<Integer> indexes = new LinkedList();
        private LinkedList<Integer> lengths = new LinkedList();

        private SimpleListAccess() {
        }

        public E[] load(int index, int length) throws Exception, IllegalArgumentException {
            this.indexes.addFirst(index);
            this.lengths.addFirst(length);
            try {
                return this.subList(index, index + length).toArray();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public int getSize() {
            return this.size();
        }
    }
}

