/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils.secure;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import junit.framework.TestCase;

public abstract class AbstractSecureCollectionsTest
extends TestCase {
    public static final Permission MODIFY_PERMISSION = new RuntimePermission("modifyPermisssion");

    protected <T> T doActionWithPermissions(PrivilegedExceptionAction<T> action, Permission ... permissions) throws PrivilegedActionException {
        Permissions allPermissions = new Permissions();
        for (Permission permission : permissions) {
            if (permission == null) continue;
            allPermissions.add(permission);
        }
        ProtectionDomain[] protectionDomains = new ProtectionDomain[]{new ProtectionDomain(new CodeSource(this.getCodeSource(), (Certificate[])null), allPermissions)};
        return AccessController.doPrivileged(action, new AccessControlContext(protectionDomains));
    }

    protected URL getCodeSource() {
        return ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
    }
}

