/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LockManager {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.mt.LockManager");
    private static final LockManager INSTANCE = new LockManager();
    private final ConcurrentMap<Thread, Lockable> locks = new ConcurrentHashMap<Thread, Lockable>();
    private final AtomicInteger totalUncompletedTasks = new AtomicInteger();

    private LockManager() {
    }

    public static LockManager getInstance() {
        return INSTANCE;
    }

    public Lock createLock() {
        return new InternalReentrantLock();
    }

    public <T> RunnableFuture<T> createRunnableFuture(Runnable runnable, T value) {
        return new InternalFutureTask<T>(runnable, value);
    }

    public <T> RunnableFuture<T> createRunnableFuture(Callable<T> callable) {
        return new InternalFutureTask<T>(callable);
    }

    int getTotalUncompletedTasks() {
        return this.totalUncompletedTasks.get();
    }

    int incrementAndGetTotalUncompletedTasks() {
        return this.totalUncompletedTasks.incrementAndGet();
    }

    boolean isEmpty() {
        return this.locks.isEmpty();
    }

    private void register(Lockable l) {
        this.locks.put(Thread.currentThread(), l);
    }

    private void unregister(Lockable l) {
        this.locks.remove(Thread.currentThread(), l);
    }

    private void checkDeadLock(Lockable l) throws InterruptedException {
        if (!l.isLocked()) {
            LOG.trace((Object)"The lock is not locked so we cannot have a deadlock");
            return;
        }
        Thread owner = l.getOwner();
        if (owner == null || owner == Thread.currentThread()) {
            LOG.trace((Object)"The lock is not locked or the lock owner is the current thread so we cannot have a deadlock");
            return;
        }
        Thread currentOwner = owner;
        while (true) {
            Lockable lock;
            if ((lock = (Lockable)this.locks.get(currentOwner)) == null) {
                LOG.trace((Object)"The owner has no lockable resource to acquire so we cannot have a deadlock");
                return;
            }
            Thread lockToAcquireOwner = lock.getOwner();
            if (lockToAcquireOwner == null) {
                LOG.trace((Object)"The lockable resource has no owner anymore so we cannot have a deadlock");
                return;
            }
            if (lockToAcquireOwner == Thread.currentThread()) {
                if (owner == l.getOwner() && l.isLocked()) {
                    LOG.debug((Object)"A deadlock has been detected, both threads will be interrupted");
                    owner.interrupt();
                    throw new InterruptedException();
                }
                LOG.trace((Object)"The owner has changed or the resource is no more locked so we cannot have a deadlock");
                return;
            }
            currentOwner = lockToAcquireOwner;
        }
    }

    private static interface Lockable {
        public Thread getOwner();

        public boolean isLocked();
    }

    private class InternalFutureTask<V>
    extends FutureTask<V>
    implements Lockable {
        private final AtomicReference<Thread> exclusiveOwnerThread;

        public InternalFutureTask(Callable<V> callable) {
            super(callable);
            this.exclusiveOwnerThread = new AtomicReference();
        }

        public InternalFutureTask(Runnable runnable, V result) {
            super(runnable, result);
            this.exclusiveOwnerThread = new AtomicReference();
        }

        private void checkDeadLock() {
            try {
                LockManager.this.checkDeadLock(this);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"An InterruptedException has been caught, but a task must not be interrupted");
            }
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            LockManager.this.register(this);
            this.checkDeadLock();
            try {
                Object v = super.get();
                return v;
            }
            finally {
                LockManager.this.unregister(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            LockManager.this.register(this);
            this.checkDeadLock();
            try {
                Object v = super.get(timeout, unit);
                return v;
            }
            finally {
                LockManager.this.unregister(this);
            }
        }

        @Override
        public void run() {
            this.exclusiveOwnerThread.compareAndSet(null, Thread.currentThread());
            try {
                super.run();
            }
            finally {
                LockManager.this.totalUncompletedTasks.decrementAndGet();
                this.exclusiveOwnerThread.compareAndSet(Thread.currentThread(), null);
            }
        }

        @Override
        public Thread getOwner() {
            return this.exclusiveOwnerThread.get();
        }

        @Override
        public boolean isLocked() {
            return !this.isDone();
        }
    }

    private class InternalReentrantLock
    extends ReentrantLock
    implements Lockable {
        private static final long serialVersionUID = 1696442015918441687L;

        private InternalReentrantLock() {
        }

        @Override
        public Thread getOwner() {
            return super.getOwner();
        }

        @Override
        public void lock() {
            LockManager.this.register(this);
            super.lock();
            LockManager.this.unregister(this);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            LockManager.this.register(this);
            try {
                LockManager.this.checkDeadLock(this);
                super.lockInterruptibly();
            }
            finally {
                LockManager.this.unregister(this);
            }
        }

        @Override
        public boolean tryLock() {
            LockManager.this.register(this);
            boolean result = super.tryLock();
            LockManager.this.unregister(this);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            LockManager.this.register(this);
            try {
                LockManager.this.checkDeadLock(this);
                boolean bl = super.tryLock(timeout, unit);
                return bl;
            }
            finally {
                LockManager.this.unregister(this);
            }
        }
    }
}

