/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.Environnment;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.configuration.MockConfigurationManagerImpl;
import org.exoplatform.container.jmx.ManagementContextImpl;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.monitor.jvm.OperatingSystemInfo;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.jmx.annotations.NamingContext;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.test.mocks.servlet.MockServletContext;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

@Managed
@NamingContext(value={@Property(key="container", value="root")})
public class RootContainer
extends ExoContainer {
    private static volatile RootContainer singleton_;
    private OperatingSystemInfo osenv_;
    private static final Log log;
    private static volatile boolean booting;
    private final J2EEServerInfo serverenv_ = new J2EEServerInfo();

    private static MBeanServer findMBeanServer() {
        J2EEServerInfo serverenv_ = new J2EEServerInfo();
        MBeanServer server = serverenv_.getMBeanServer();
        if (server == null) {
            server = ManagementFactory.getPlatformMBeanServer();
        }
        return server;
    }

    public RootContainer() {
        super(new ManagementContextImpl(RootContainer.findMBeanServer(), new HashMap<String, String>()));
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
        this.registerComponentInstance(J2EEServerInfo.class, this.serverenv_);
    }

    public OperatingSystemInfo getOSEnvironment() {
        if (this.osenv_ == null) {
            this.osenv_ = (OperatingSystemInfo)this.getComponentInstanceOfType(OperatingSystemInfo.class);
        }
        return this.osenv_;
    }

    public J2EEServerInfo getServerEnvironment() {
        return this.serverenv_;
    }

    public PortalContainer getPortalContainer(String name) {
        J2EEServerInfo senv;
        PortalContainer pcontainer = (PortalContainer)this.getComponentInstance(name);
        if (pcontainer == null && ("standalone".equals((senv = this.getServerEnvironment()).getServerName()) || "test".equals(senv.getServerName()))) {
            try {
                MockServletContext scontext = new MockServletContext(name);
                pcontainer = new PortalContainer((PicoContainer)this, (ServletContext)scontext);
                MockConfigurationManagerImpl cService = new MockConfigurationManagerImpl((ServletContext)scontext);
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/test-configuration.xml"));
                cService.processRemoveConfiguration();
                pcontainer.registerComponentInstance(ConfigurationManager.class, cService);
                pcontainer.initContainer();
                this.registerComponentInstance(name, pcontainer);
                PortalContainer.setInstance(pcontainer);
                ExoContainerContext.setCurrentContainer(pcontainer);
                pcontainer.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return pcontainer;
    }

    public synchronized PortalContainer createPortalContainer(ServletContext context) {
        try {
            PortalContainer pcontainer = new PortalContainer((PicoContainer)this, context);
            PortalContainer.setInstance(pcontainer);
            ExoContainerContext.setCurrentContainer(pcontainer);
            ConfigurationManagerImpl cService = new ConfigurationManagerImpl(context);
            try {
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
            }
            catch (Exception ex) {
                log.error((Object)("Cannot add configuration conf/portal/configuration.xml. ServletContext: " + context), (Throwable)ex);
            }
            String uri = Environnment.isJBoss() ? "conf/portal/jboss-configuration.xml" : "conf/portal/generic-configuration.xml";
            Collection<URL> envConf = ContainerUtil.getConfigurationURL(uri);
            try {
                cService.addConfiguration(envConf);
            }
            catch (Exception ex) {
                log.error((Object)("Cannot add configuration " + uri + ". ServletContext: " + context), (Throwable)ex);
            }
            try {
                cService.addConfiguration("war:/conf/configuration.xml");
            }
            catch (Exception ex) {
                log.error((Object)("Cannot add configuration war:/conf/configuration.xml. ServletContext: " + context), (Throwable)ex);
            }
            String overrideConfig = singleton_.getServerEnvironment().getExoConfigurationDirectory() + "/portal/" + pcontainer.getPortalContainerInfo().getContainerName() + "/configuration.xml";
            try {
                File file = new File(overrideConfig);
                if (file.exists()) {
                    cService.addConfiguration(file.toURI().toURL());
                }
            }
            catch (Exception ex) {
                log.error((Object)("Cannot add configuration " + overrideConfig + ". ServletContext: " + context), (Throwable)ex);
            }
            cService.processRemoveConfiguration();
            ComponentAdapter adapter = pcontainer.registerComponentInstance(ConfigurationManager.class, cService);
            pcontainer.initContainer();
            this.registerComponentInstance(context.getServletContextName(), pcontainer);
            PortalContainer.setInstance(pcontainer);
            ExoContainerContext.setCurrentContainer(pcontainer);
            pcontainer.start();
            this.managementContext.register(pcontainer);
            return pcontainer;
        }
        catch (Exception ex) {
            log.error((Object)("Cannot create portal container. ServletContext: " + context), (Throwable)ex);
            return null;
        }
    }

    public synchronized void removePortalContainer(ServletContext servletContext) {
        this.unregisterComponent(servletContext.getServletContextName());
    }

    public static Object getComponent(Class key) {
        return RootContainer.getInstance().getComponentInstanceOfType(key);
    }

    private static RootContainer buildRootContainer() {
        try {
            String confDir;
            String overrideConf;
            File file;
            RootContainer rootContainer = new RootContainer();
            ConfigurationManagerImpl service = new ConfigurationManagerImpl();
            service.addConfiguration(ContainerUtil.getConfigurationURL("conf/configuration.xml"));
            if (System.getProperty("maven.exoplatform.dir") != null) {
                service.addConfiguration(ContainerUtil.getConfigurationURL("conf/test-configuration.xml"));
            }
            if ((file = new File(overrideConf = (confDir = rootContainer.getServerEnvironment().getExoConfigurationDirectory()) + "/configuration.xml")).exists()) {
                service.addConfiguration("file:" + overrideConf);
            }
            service.processRemoveConfiguration();
            rootContainer.registerComponentInstance(ConfigurationManager.class, service);
            rootContainer.initContainer();
            rootContainer.start();
            return rootContainer;
        }
        catch (Exception e) {
            log.error((Object)"Could not build root container", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RootContainer getInstance() {
        RootContainer result = singleton_;
        if (result != null) return result;
        Class<RootContainer> clazz = RootContainer.class;
        synchronized (RootContainer.class) {
            result = singleton_;
            if (result != null) return result;
            if (booting) {
                throw new IllegalStateException("Already booting by the same thread");
            }
            booting = true;
            log.info((Object)"Building root container");
            long time = -System.currentTimeMillis();
            result = RootContainer.buildRootContainer();
            if (result != null) {
                log.info((Object)("Root container is built (build time " + (time += System.currentTimeMillis()) + "ms)"));
                ExoContainerContext.setTopContainer(result);
                singleton_ = result;
                log.info((Object)"Root container booted");
            } else {
                log.error((Object)"Failed to boot root container");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static void setInstance(RootContainer rcontainer) {
        singleton_ = rcontainer;
    }

    public void stop() {
        super.stop();
        ExoContainerContext.setTopContainer(null);
    }

    static {
        log = LogFactory.getLog(RootContainer.class);
        booting = false;
    }

    static class ShutdownThread
    extends Thread {
        RootContainer container_;

        ShutdownThread(RootContainer container) {
            this.container_ = container;
        }

        public void run() {
            this.container_.stop();
        }
    }
}

