/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationUnmarshaller;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.Configuration;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    public static final String WAR_CONF_LOCATION = "/WEB-INF";
    public static final String LOG_DEBUG_PROPERTY = "org.exoplatform.container.configuration.debug";
    public static final boolean LOG_DEBUG = System.getProperty("org.exoplatform.container.configuration.debug") != null;
    protected Configuration configurations_;
    private ServletContext scontext_;
    private ClassLoader scontextClassLoader_;
    private String contextPath = null;
    private static final ThreadLocal<URL> currentURL = new ThreadLocal();

    public static URL getCurrentURL() {
        return currentURL.get();
    }

    public ConfigurationManagerImpl() {
    }

    public ConfigurationManagerImpl(ServletContext context) {
        this.scontext_ = context;
    }

    public ConfigurationManagerImpl(ClassLoader loader) {
        this.scontextClassLoader_ = loader;
    }

    public Configuration getConfiguration() {
        return this.configurations_;
    }

    public void addConfiguration(String url) throws Exception {
        if (url == null) {
            return;
        }
        this.addConfiguration(this.getURL(url));
    }

    public void addConfiguration(Collection urls) throws Exception {
        for (URL url : urls) {
            this.addConfiguration(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfiguration(URL url) throws Exception {
        if (LOG_DEBUG) {
            System.out.println("Add configuration " + url);
        }
        if (url == null) {
            return;
        }
        try {
            this.contextPath = new File(url.toString()).getParent() + "/";
            this.contextPath = this.contextPath.replaceAll("\\\\", "/");
        }
        catch (Exception e) {
            this.contextPath = null;
        }
        if (currentURL.get() != null) {
            throw new IllegalStateException("Would not expect that");
        }
        currentURL.set(url);
        try {
            ConfigurationUnmarshaller unmarshaller = new ConfigurationUnmarshaller();
            Configuration conf = unmarshaller.unmarshall(url);
            if (this.configurations_ == null) {
                this.configurations_ = conf;
            } else {
                this.configurations_.mergeConfiguration(conf);
            }
            List urls = conf.getImports();
            if (urls != null) {
                for (int i = 0; i < urls.size(); ++i) {
                    String uri = (String)urls.get(i);
                    URL urlObject = this.getURL(uri);
                    if (urlObject != null) {
                        conf = unmarshaller.unmarshall(urlObject);
                        this.configurations_.mergeConfiguration(conf);
                        if (!LOG_DEBUG) continue;
                        System.out.println("\timport " + urlObject);
                        continue;
                    }
                    System.err.println("WARNING: Couldn't process the URL for " + uri + " configuration file ignored ");
                }
            }
        }
        catch (Exception ex) {
            System.err.println("ERROR: cannot process the configuration " + url);
            ex.printStackTrace();
        }
        finally {
            currentURL.set(null);
        }
    }

    public void processRemoveConfiguration() {
        if (this.configurations_ == null) {
            return;
        }
        List list = this.configurations_.getRemoveConfiguration();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String type = (String)list.get(i);
                this.configurations_.removeConfiguration(type);
            }
        }
    }

    public Component getComponent(String service) {
        return this.configurations_.getComponent(service);
    }

    public Component getComponent(Class clazz) throws Exception {
        return this.configurations_.getComponent(clazz.getName());
    }

    public Collection getComponents() {
        if (this.configurations_ == null) {
            return null;
        }
        return this.configurations_.getComponents();
    }

    public URL getResource(String url, String defaultURL) throws Exception {
        return null;
    }

    public URL getResource(String uri) throws Exception {
        return this.getURL(uri);
    }

    public InputStream getInputStream(String url, String defaultURL) throws Exception {
        if (url == null) {
            url = defaultURL;
        }
        return this.getInputStream(url);
    }

    public InputStream getInputStream(String uri) throws Exception {
        URL url = this.getURL(uri);
        if (url == null) {
            throw new IOException("Resource (" + uri + ") could not be found or the invoker doesn't have adequate privileges to get the resource");
        }
        return url.openStream();
    }

    public URL getURL(String url) throws Exception {
        if (url.startsWith("jar:")) {
            String path = this.removePrefix("jar:/", url);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl.getResource(path);
        }
        if (url.startsWith("classpath:")) {
            String path = this.removePrefix("classpath:/", url);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl.getResource(path);
        }
        if (url.startsWith("war:")) {
            String path = this.removePrefix("war:", url);
            if (this.scontext_ != null) {
                return this.scontext_.getResource(WAR_CONF_LOCATION + path);
            }
            if (this.scontextClassLoader_ != null) {
                return this.scontextClassLoader_.getResource(path);
            }
            throw new Exception("unsupport war uri in this configuration service");
        }
        if (url.startsWith("file:")) {
            url = ConfigurationManagerImpl.resolveSystemProperties(url);
            return new URL(url);
        }
        if (url.indexOf(":") < 0 && this.contextPath != null) {
            return new URL(this.contextPath + url);
        }
        return null;
    }

    public static String resolveSystemProperties(String input) {
        boolean NORMAL = false;
        boolean SEEN_DOLLAR = true;
        int IN_BRACKET = 2;
        if (input == null) {
            return input;
        }
        char[] chars = input.toCharArray();
        StringBuffer buffer = new StringBuffer();
        boolean properties = false;
        int state = 0;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '$' && state != 2) {
                state = 1;
                continue;
            }
            if (c == '{' && state == 1) {
                buffer.append(input.substring(start, i - 1));
                state = 2;
                start = i - 1;
                continue;
            }
            if (state == 1) {
                state = 0;
                continue;
            }
            if (c != '}' || state != 2) continue;
            if (start + 2 == i) {
                buffer.append("${}");
            } else {
                String value = null;
                String key = input.substring(start + 2, i);
                value = System.getProperty(key);
                if (value != null) {
                    properties = true;
                    buffer.append(value);
                }
            }
            start = i + 1;
            state = 0;
        }
        if (!properties) {
            return input;
        }
        if (start != chars.length) {
            buffer.append(input.substring(start, chars.length));
        }
        return buffer.toString();
    }

    public boolean isDefault(String value) {
        return value == null || value.length() == 0 || "default".equals(value);
    }

    protected String removePrefix(String prefix, String url) {
        return url.substring(prefix.length(), url.length());
    }
}

