/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.ContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentLifecyclePlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.jmx.ManageableContainer;
import org.exoplatform.container.jmx.ManagementContextImpl;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.InitParams;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoContainer
extends ManageableContainer {
    Log log = LogFactory.getLog(ExoContainer.class);
    private Map<String, ComponentLifecyclePlugin> componentLifecylePlugin_ = new HashMap<String, ComponentLifecyclePlugin>();
    private List<ContainerLifecyclePlugin> containerLifecyclePlugin_ = new ArrayList<ContainerLifecyclePlugin>();
    protected ExoContainerContext context = new ExoContainerContext(this);
    protected PicoContainer parent;

    public ExoContainer(ManagementContextImpl managementContext) {
        super(managementContext);
        this.context.setName(((Object)((Object)this)).getClass().getName());
        this.registerComponentInstance(this.context);
        this.parent = null;
    }

    public ExoContainer(PicoContainer parent) {
        super(parent);
        this.context.setName(((Object)((Object)this)).getClass().getName());
        this.registerComponentInstance(this.context);
        this.parent = parent;
    }

    public ExoContainer(ComponentAdapterFactory factory, PicoContainer parent) {
        super(factory, parent);
        this.context.setName(((Object)((Object)this)).getClass().getName());
        this.registerComponentInstance(this.context);
        this.parent = parent;
    }

    public ExoContainerContext getContext() {
        return this.context;
    }

    public void initContainer() throws Exception {
        ConfigurationManager manager = (ConfigurationManager)this.getComponentInstanceOfType(ConfigurationManager.class);
        ContainerUtil.addContainerLifecyclePlugin(this, manager);
        ContainerUtil.addComponentLifecyclePlugin(this, manager);
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.initContainer(this);
        }
        ContainerUtil.addComponents(this, manager);
    }

    public void startContainer() throws Exception {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.startContainer(this);
        }
    }

    public void stopContainer() throws Exception {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.stopContainer(this);
        }
    }

    public void destroyContainer() throws Exception {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.destroyContainer(this);
        }
    }

    public void addComponentLifecylePlugin(ComponentLifecyclePlugin plugin) {
        List<String> list = plugin.getManageableComponents();
        for (String component : list) {
            this.componentLifecylePlugin_.put(component, plugin);
        }
    }

    public void addContainerLifecylePlugin(ContainerLifecyclePlugin plugin) {
        this.containerLifecyclePlugin_.add(plugin);
    }

    public <T> T createComponent(Class<T> clazz) throws Exception {
        return this.createComponent(clazz, null);
    }

    public <T> T createComponent(Class<T> clazz, InitParams params) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(clazz.getName() + " " + (params != null ? params : "") + " added to " + this.getContext().getName()));
        }
        Constructor[] constructors = new Constructor[]{};
        try {
            constructors = ContainerUtil.getSortedConstructors(clazz);
        }
        catch (NoClassDefFoundError err) {
            throw new Exception("Cannot resolve constructor for class " + clazz.getName(), err);
        }
        Class<?> unknownParameter = null;
        for (int k = 0; k < constructors.length; ++k) {
            Constructor constructor = constructors[k];
            Class<?>[] parameters = constructor.getParameterTypes();
            Object[] args = new Object[parameters.length];
            boolean satisfied = true;
            for (int i = 0; i < args.length; ++i) {
                if (parameters[i].equals(InitParams.class)) {
                    args[i] = params;
                    continue;
                }
                args[i] = this.getComponentInstanceOfType(parameters[i]);
                if (args[i] != null) continue;
                satisfied = false;
                unknownParameter = parameters[i];
                break;
            }
            if (!satisfied) continue;
            return clazz.cast(constructor.newInstance(args));
        }
        throw new Exception("Cannot find a satisfying constructor for " + clazz + " with parameter " + unknownParameter);
    }
}

