/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.xml;

import org.exoplatform.container.configuration.ConfigurationManagerImpl;

public class Deserializer {
    public static String resolveString(String s) {
        return ConfigurationManagerImpl.resolveSystemProperties(s);
    }

    public static Boolean resolveBoolean(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        if ((s = ConfigurationManagerImpl.resolveSystemProperties(s)).equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Cannot accept boolean value " + s);
    }

    public static Integer resolveInteger(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        s = ConfigurationManagerImpl.resolveSystemProperties(s);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot accept integer value " + s, e);
        }
    }

    public static Long resolveLong(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        s = ConfigurationManagerImpl.resolveSystemProperties(s);
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot accept integer value " + s, e);
        }
    }

    public static Double resolveDouble(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        s = ConfigurationManagerImpl.resolveSystemProperties(s);
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot accept integer value " + s, e);
        }
    }
}

