/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.management;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.exoplatform.container.CachingContainer;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.container.management.ManageableComponentAdapterFactory;
import org.exoplatform.container.management.ManagementContextImpl;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.impl.JMX;
import org.exoplatform.management.jmx.impl.JMXManagementProvider;
import org.exoplatform.management.jmx.impl.MBeanScopingData;
import org.exoplatform.management.spi.ManagementProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.defaults.ComponentAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageableContainer
extends CachingContainer {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.container.management.ManageableContainer");
    private static final ThreadLocal<ManageableComponentAdapterFactory> hack = new ThreadLocal();
    final ManagementContextImpl managementContext;
    private MBeanServer server;
    private volatile boolean objectNameSet;
    private ObjectName objectName;
    private final Set<ManagementProvider> providers;
    private final ManageableContainer parent;

    private static MBeanServer findMBeanServer() {
        J2EEServerInfo serverenv_ = new J2EEServerInfo();
        return serverenv_.getMBeanServer();
    }

    public ManageableContainer() {
        this((PicoContainer)null);
    }

    public ManageableContainer(PicoContainer parent) {
        this(new MX4JComponentAdapterFactory(), parent);
    }

    public ManageableContainer(ComponentAdapterFactory componentAdapterFactory, PicoContainer parent) {
        super(ManageableContainer.getComponentAdapterFactory(componentAdapterFactory), parent);
        ManageableComponentAdapterFactory factory = hack.get();
        factory.container = this;
        hack.set(null);
        this.providers = Collections.synchronizedSet(new HashSet());
        ManagementContextImpl parentCtx = null;
        if (parent instanceof ManageableContainer) {
            ManageableContainer manageableParent = (ManageableContainer)parent;
            parentCtx = manageableParent.managementContext;
        }
        ManageableContainer manageableContainer = this.parent = parent instanceof ManageableContainer ? (ManageableContainer)parent : null;
        if (parentCtx != null) {
            this.server = parentCtx.container.server;
            this.managementContext = new ManagementContextImpl(parentCtx, this);
        } else {
            this.server = ManageableContainer.findMBeanServer();
            this.managementContext = new ManagementContextImpl(this);
            this.addProvider(new JMXManagementProvider(this.server));
        }
    }

    public ManageableContainer(ComponentAdapterFactory componentAdapterFactory) {
        this(componentAdapterFactory, null);
    }

    @Managed
    @ManagedName(value="RegisteredComponentNames")
    @ManagedDescription(value="Return the list of the registered component names")
    public Set<String> getRegisteredComponentNames() throws PicoException {
        HashSet<String> names = new HashSet<String>();
        Collection adapters = this.getComponentAdapters();
        for (ComponentAdapter adapter : adapters) {
            Object key = adapter.getComponentKey();
            String name = String.valueOf(key);
            names.add(name);
        }
        return names;
    }

    private static ManageableComponentAdapterFactory getComponentAdapterFactory(ComponentAdapterFactory componentAdapterFactory) {
        ManageableComponentAdapterFactory factory = new ManageableComponentAdapterFactory(componentAdapterFactory);
        hack.set(factory);
        return factory;
    }

    public ManagementContext getManagementContext() {
        return this.managementContext;
    }

    public final MBeanServer getMBeanServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName getScopingObjectName() {
        if (!this.objectNameSet) {
            ManageableContainer manageableContainer = this;
            synchronized (manageableContainer) {
                if (!this.objectNameSet) {
                    LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
                    List<MBeanScopingData> list = this.managementContext.getScopingData(MBeanScopingData.class);
                    if (list != null && !list.isEmpty()) {
                        for (int i = list.size(); i > 0; --i) {
                            MBeanScopingData scopingData = list.get(i - 1);
                            props.putAll(scopingData);
                        }
                        try {
                            this.objectName = JMX.createObjectName("exo", props);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Could not create the object name", (Throwable)e);
                        }
                    }
                    this.objectNameSet = true;
                }
            }
        }
        return this.objectName;
    }

    @Override
    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) throws PicoRegistrationException {
        ComponentAdapter adapter = super.registerComponentInstance(componentKey, componentInstance);
        if (this.managementContext != null) {
            this.managementContext.register(componentInstance);
            if (componentInstance instanceof ManagementProvider) {
                ManagementProvider provider = (ManagementProvider)componentInstance;
                this.addProvider(provider);
            }
        }
        return adapter;
    }

    Collection<ManagementProvider> getProviders() {
        HashSet<ManagementProvider> allProviders = new HashSet<ManagementProvider>();
        this.computeAllProviders(allProviders);
        return allProviders;
    }

    private void computeAllProviders(Set<ManagementProvider> allProviders) {
        if (this.parent != null) {
            this.parent.computeAllProviders(allProviders);
        }
        allProviders.addAll(this.providers);
    }

    boolean addProvider(ManagementProvider provider) {
        if (this.providers.contains(provider)) {
            return false;
        }
        this.providers.add(provider);
        this.managementContext.install(provider);
        return true;
    }
}

