/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.management;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.management.ManageableContainer;
import org.exoplatform.container.management.MetaDataBuilder;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.management.spi.ManagedResource;
import org.exoplatform.management.spi.ManagedTypeMetaData;
import org.exoplatform.management.spi.ManagementProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementContextImpl
implements ManagementContext,
ManagedResource {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.container.management.ManagementContextImpl");
    private final Map<Class<?>, Object> scopingDataList;
    private final Map<Object, ManagementContextImpl> registrations;
    final Map<ManagementProvider, Object> managedSet;
    private final ManagementContextImpl parent;
    private final Object resource;
    private final ManagedTypeMetaData typeMD;
    final ManageableContainer container;

    public ManagementContextImpl(ManageableContainer container) {
        if (container == null) {
            throw new NullPointerException();
        }
        ManageableContainer resource = null;
        ManagedTypeMetaData typeMD = null;
        MetaDataBuilder builder = new MetaDataBuilder(container.getClass());
        if (builder.isBuildable()) {
            resource = container;
            typeMD = builder.build();
        }
        this.managedSet = new HashMap<ManagementProvider, Object>();
        this.registrations = new HashMap<Object, ManagementContextImpl>();
        this.parent = null;
        this.scopingDataList = new HashMap();
        this.resource = resource;
        this.typeMD = typeMD;
        this.container = container;
    }

    public ManagementContextImpl(ManagementContextImpl parent, ManageableContainer container) {
        if (parent == null) {
            throw new NullPointerException();
        }
        if (container == null) {
            throw new NullPointerException();
        }
        ManageableContainer resource = null;
        ManagedTypeMetaData typeMD = null;
        MetaDataBuilder builder = new MetaDataBuilder(container.getClass());
        if (builder.isBuildable()) {
            resource = container;
            typeMD = builder.build();
        }
        this.managedSet = new HashMap<ManagementProvider, Object>();
        this.registrations = new HashMap<Object, ManagementContextImpl>();
        this.parent = parent;
        this.scopingDataList = new HashMap();
        this.resource = resource;
        this.typeMD = typeMD;
        this.container = container;
    }

    public ManagementContextImpl(ManagementContextImpl parent, Object resource, ManagedTypeMetaData typeMD) {
        if (parent == null) {
            throw new NullPointerException();
        }
        if (resource != null && typeMD == null && resource == null && typeMD != null) {
            throw new IllegalArgumentException("Can't have resource null and meta data not null or the converse");
        }
        this.managedSet = new HashMap<ManagementProvider, Object>();
        this.registrations = new HashMap<Object, ManagementContextImpl>();
        this.parent = parent;
        this.scopingDataList = new HashMap();
        this.resource = resource;
        this.typeMD = typeMD;
        this.container = null;
    }

    public ManagementContext getParent() {
        return this.parent;
    }

    @Override
    public <S> void setScopingData(Class<S> scopeType, S scopingData) {
        this.scopingDataList.put(scopeType, scopingData);
    }

    @Override
    public void register(Object o) {
        MetaDataBuilder builder;
        Object resource = null;
        ManagedBy managedBy = o.getClass().getAnnotation(ManagedBy.class);
        if (managedBy != null) {
            try {
                Class managedByClass = managedBy.value();
                Constructor blah = managedByClass.getConstructor(o.getClass());
                resource = blah.newInstance(o);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            resource = o;
        }
        if (resource != null && (builder = new MetaDataBuilder(resource.getClass())).isBuildable()) {
            ManagedTypeMetaData metaData = builder.build();
            ManagementContextImpl managementContext = resource instanceof ManageableContainer ? ((ManageableContainer)resource).managementContext : new ManagementContextImpl(this, resource, metaData);
            this.registrations.put(resource, managementContext);
            ExoContainer container = this.findContainer();
            for (ManagementProvider provider : container.getProviders()) {
                Object name = provider.manage(managementContext);
                if (name == null) continue;
                managementContext.managedSet.put(provider, name);
            }
            if (resource instanceof ManagementAware) {
                ((ManagementAware)resource).setContext(managementContext);
            }
        }
    }

    @Override
    public void unregister(Object o) {
        ManagementContextImpl context = this.registrations.remove(o);
        if (context != null) {
            for (Map.Entry<ManagementProvider, Object> entry : context.managedSet.entrySet()) {
                entry.getKey().unmanage(entry.getValue());
            }
        }
    }

    @Override
    public <S> List<S> getScopingData(Class<S> scopeType) {
        ArrayList<Object> list = new ArrayList<Object>();
        ManagementContextImpl current = this;
        while (current != null) {
            Object scopedData = current.scopingDataList.get(scopeType);
            if (scopedData != null) {
                list.add(scopedData);
            }
            current = current.parent;
        }
        return list;
    }

    public ExoContainer findContainer() {
        ManagementContextImpl current = this;
        while (!(current.container instanceof ExoContainer)) {
            if (current.parent == null) {
                return null;
            }
            current = current.parent;
        }
        return (ExoContainer)current.container;
    }

    @Override
    public void beforeInvoke(Object managedResource) {
        ExoContainer container = this.findContainer();
        if (container != null) {
            RequestLifeCycle.begin(container);
        }
    }

    @Override
    public void afterInvoke(Object managedResource) {
        RequestLifeCycle.end();
    }

    public String toString() {
        return "ManagementContextImpl[container=" + this.container + "]";
    }

    @Override
    public Object getResource() {
        return this.resource;
    }

    @Override
    public ManagedTypeMetaData getMetaData() {
        return this.typeMD;
    }

    void install(ManagementProvider provider) {
        Object name;
        if (this.resource != null && this.typeMD != null && (name = provider.manage(this)) != null) {
            this.managedSet.put(provider, name);
        }
        for (ManagementContextImpl registration : this.registrations.values()) {
            registration.install(provider);
        }
    }
}

