/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Disposable;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.Startable;
import org.picocontainer.defaults.AbstractPicoVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleVisitor
extends AbstractPicoVisitor {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.LifecycleVisitor");
    private static final Method START;
    private static final Method STOP;
    private static final Method DISPOSE;
    private final Method method;
    private final Class<?> type;
    private final boolean visitInInstantiationOrder;
    private final List componentInstances;
    private final boolean ignoreError;

    public LifecycleVisitor(Method method, Class<?> ofType, boolean visitInInstantiationOrder, boolean ignoreError) {
        this.method = method;
        this.type = ofType;
        this.visitInInstantiationOrder = visitInInstantiationOrder;
        this.componentInstances = new ArrayList();
        this.ignoreError = ignoreError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object traverse(Object node) {
        this.componentInstances.clear();
        try {
            super.traverse(node);
            if (!this.visitInInstantiationOrder) {
                Collections.reverse(this.componentInstances);
            }
            for (Object o : this.componentInstances) {
                try {
                    this.method.invoke(o, (Object[])null);
                }
                catch (IllegalArgumentException e) {
                    if (!this.ignoreError) throw new PicoIntrospectionException("Can't call " + this.method.getName() + " on " + o, (Throwable)e);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Can't call " + this.method.getName() + " on " + o), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    if (!this.ignoreError) throw new PicoIntrospectionException("Can't call " + this.method.getName() + " on " + o, (Throwable)e);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Can't call " + this.method.getName() + " on " + o), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    if (!this.ignoreError) throw new PicoIntrospectionException("Failed when calling " + this.method.getName() + " on " + o, e.getTargetException());
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Failed when calling " + this.method.getName() + " on " + o), e.getTargetException());
                    continue;
                    return Void.TYPE;
                }
            }
        }
        finally {
            this.componentInstances.clear();
        }
    }

    public void visitContainer(PicoContainer pico) {
        this.checkTraversal();
        this.componentInstances.addAll(pico.getComponentInstancesOfType(this.type));
    }

    public void visitComponentAdapter(ComponentAdapter componentAdapter) {
        this.checkTraversal();
    }

    public void visitParameter(Parameter parameter) {
        this.checkTraversal();
    }

    public static void start(Object node) {
        new LifecycleVisitor(START, Startable.class, true, false).traverse(node);
    }

    public static void stop(Object node) {
        new LifecycleVisitor(STOP, Startable.class, false, true).traverse(node);
    }

    public static void dispose(Object node) {
        new LifecycleVisitor(DISPOSE, Disposable.class, false, true).traverse(node);
    }

    static {
        try {
            START = Startable.class.getMethod("start", null);
            STOP = Startable.class.getMethod("stop", null);
            DISPOSE = Disposable.class.getMethod("dispose", null);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

