/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.lang.reflect.Constructor;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentLifecyclePlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.management.ManageableContainer;
import org.exoplatform.container.security.ContainerPermissions;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoContainer
extends ManageableContainer {
    private static final long serialVersionUID = -8068506531004854036L;
    private static volatile String PROFILES;
    private static Set<String> SET_PROFILES;
    protected final AtomicBoolean stopping = new AtomicBoolean();
    protected static final Log LOG;
    private Map<String, ComponentLifecyclePlugin> componentLifecylePlugin_ = new HashMap<String, ComponentLifecyclePlugin>();
    private List<ContainerLifecyclePlugin> containerLifecyclePlugin_ = new ArrayList<ContainerLifecyclePlugin>();
    protected ExoContainerContext context = new ExoContainerContext(this, this.getClass().getSimpleName());
    protected PicoContainer parent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getProfiles() {
        String profiles = PropertyManager.getProperty((String)"exo.profiles");
        if ((profiles != null || PROFILES == null) && (profiles == null || profiles.equals(PROFILES))) return SET_PROFILES;
        Class<ExoContainer> clazz = ExoContainer.class;
        synchronized (ExoContainer.class) {
            if ((profiles != null || PROFILES == null) && (profiles == null || profiles.equals(PROFILES))) return SET_PROFILES;
            SET_PROFILES = ExoContainer.getProfiles(profiles);
            PROFILES = profiles;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SET_PROFILES;
        }
    }

    public static boolean hasProfile(String profileName) {
        return ExoContainer.getProfiles().contains(profileName);
    }

    private static Set<String> getProfiles(String profileList) {
        HashSet<String> profiles = new HashSet<String>();
        if (profileList != null) {
            for (String profile : profileList.split(",")) {
                profiles.add(profile.trim());
            }
        }
        return Collections.unmodifiableSet(profiles);
    }

    public ExoContainer() {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ExoContainer.this.registerComponentInstance(ExoContainer.this.context);
                return null;
            }
        });
        this.parent = null;
    }

    public ExoContainer(PicoContainer parent) {
        super(parent);
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ExoContainer.this.registerComponentInstance(ExoContainer.this.context);
                return null;
            }
        });
        this.parent = parent;
    }

    public ExoContainer(ComponentAdapterFactory factory, PicoContainer parent) {
        super(factory, parent);
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ExoContainer.this.registerComponentInstance(ExoContainer.this.context);
                return null;
            }
        });
        this.parent = parent;
    }

    public ExoContainerContext getContext() {
        return this.context;
    }

    private static String getPluginName(ContainerLifecyclePlugin plugin) {
        String name = plugin.getName();
        if (name == null || name.length() == 0) {
            name = plugin.getClass().getName();
        }
        return name;
    }

    @Deprecated
    public void initContainer() throws Exception {
    }

    private void initContainerInternal() {
        ConfigurationManager manager = (ConfigurationManager)this.getComponentInstanceOfType(ConfigurationManager.class);
        ContainerUtil.addContainerLifecyclePlugin(this, manager);
        ContainerUtil.addComponentLifecyclePlugin(this, manager);
        ContainerUtil.addComponents(this, manager);
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            try {
                plugin.initContainer(this);
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurs with the ContainerLifecyclePlugin '" + ExoContainer.getPluginName(plugin) + "'"), (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void dispose() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (this.canBeDisposed()) {
            this.destroyContainerInternal();
            super.dispose();
        }
    }

    public synchronized void start(boolean init) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (init) {
            this.initContainerInternal();
        }
        this.start();
    }

    @Override
    public synchronized void start() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (this.canBeStarted()) {
            super.start();
            this.startContainerInternal();
        }
    }

    @Override
    public synchronized void stop() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (this.canBeStopped()) {
            this.stopping.set(true);
            this.stopContainerInternal();
            super.stop();
        }
    }

    @Deprecated
    public void startContainer() throws Exception {
    }

    private void startContainerInternal() {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            try {
                plugin.startContainer(this);
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurs with the ContainerLifecyclePlugin '" + ExoContainer.getPluginName(plugin) + "'"), (Throwable)e);
            }
        }
    }

    @Deprecated
    public void stopContainer() throws Exception {
    }

    private void stopContainerInternal() {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            try {
                plugin.stopContainer(this);
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurs with the ContainerLifecyclePlugin '" + ExoContainer.getPluginName(plugin) + "'"), (Throwable)e);
            }
        }
    }

    @Deprecated
    public void destroyContainer() throws Exception {
    }

    private void destroyContainerInternal() {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            try {
                plugin.destroyContainer(this);
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurs with the ContainerLifecyclePlugin '" + ExoContainer.getPluginName(plugin) + "'"), (Throwable)e);
            }
        }
    }

    public void addComponentLifecylePlugin(ComponentLifecyclePlugin plugin) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        List<String> list = plugin.getManageableComponents();
        for (String component : list) {
            this.componentLifecylePlugin_.put(component, plugin);
        }
    }

    public void addContainerLifecylePlugin(ContainerLifecyclePlugin plugin) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        this.containerLifecyclePlugin_.add(plugin);
    }

    public <T> T createComponent(Class<T> clazz) throws Exception {
        return this.createComponent(clazz, null);
    }

    public <T> T createComponent(Class<T> clazz, InitParams params) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(clazz.getName() + " " + (params != null ? params : "") + " added to " + this.getContext().getName()));
        }
        Constructor[] constructors = new Constructor[]{};
        try {
            constructors = ContainerUtil.getSortedConstructors(clazz);
        }
        catch (NoClassDefFoundError err) {
            throw new Exception("Cannot resolve constructor for class " + clazz.getName(), err);
        }
        Class<?> unknownParameter = null;
        for (int k = 0; k < constructors.length; ++k) {
            Constructor constructor = constructors[k];
            Class<?>[] parameters = constructor.getParameterTypes();
            Object[] args = new Object[parameters.length];
            boolean satisfied = true;
            for (int i = 0; i < args.length; ++i) {
                if (parameters[i].equals(InitParams.class)) {
                    args[i] = params;
                    continue;
                }
                args[i] = this.getComponentInstanceOfType(parameters[i]);
                if (args[i] != null) continue;
                satisfied = false;
                unknownParameter = parameters[i];
                break;
            }
            if (!satisfied) continue;
            return clazz.cast(constructor.newInstance(args));
        }
        throw new Exception("Cannot find a satisfying constructor for " + clazz + " with parameter " + unknownParameter);
    }

    protected Configuration getConfiguration() {
        ConfigurationManager cm = (ConfigurationManager)this.getComponentInstanceOfType(ConfigurationManager.class);
        return cm == null ? null : cm.getConfiguration();
    }

    protected void unregisterAllComponents() {
        Collection adapters = this.getComponentAdapters();
        for (ComponentAdapter adapter : adapters) {
            this.unregisterComponent(adapter.getComponentKey());
        }
    }

    static {
        SET_PROFILES = Collections.unmodifiableSet(new HashSet());
        LOG = ExoLogger.getLogger((String)"exo.kernel.container.ExoContainer");
    }
}

