/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor.jvm;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ar.Archive;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEServerInfo {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.J2EEServerInfo");
    public static final String EXO_CONF_PARAM = "exo.conf.dir";
    public static final String EXO_CONF_DIR_NAME_PARAM = "exo.conf.dir.name";
    public static final String EXO_ARCHIVE_DIRS_PARAM = "exo.archive.dirs";
    private String serverName_;
    private String serverHome_;
    private String exoConfDir_;
    private List<String> appDeployDirectories_;
    private Set<Archive> appDeployArchives_;
    private MBeanServer mbeanServer;

    public J2EEServerInfo() {
        this(false);
    }

    public J2EEServerInfo(final boolean logEnabled) {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String archiveDirs;
                String exoConfHome;
                String confDirName;
                block46: {
                    String jonasHome = System.getProperty("jonas.base");
                    String jbossHome = System.getProperty("jboss.home.dir");
                    String jettyHome = System.getProperty("jetty.home");
                    String websphereHome = System.getProperty("was.install.root");
                    String weblogicHome = System.getProperty("wls.home");
                    String glassfishHome = System.getProperty("com.sun.aas.instanceRoot");
                    String catalinaHome = System.getProperty("catalina.home");
                    String testHome = System.getProperty("maven.exoplatform.dir");
                    confDirName = System.getProperty(J2EEServerInfo.EXO_CONF_DIR_NAME_PARAM, "exo-conf");
                    if (jonasHome != null) {
                        J2EEServerInfo.this.serverName_ = "jonas";
                        J2EEServerInfo.this.serverHome_ = jonasHome;
                    } else {
                        if (jbossHome != null) {
                            block45: {
                                J2EEServerInfo.this.serverName_ = "jboss";
                                J2EEServerInfo.this.serverHome_ = jbossHome;
                                String jbossConfigUrl = System.getProperty("jboss.server.config.url");
                                if (jbossConfigUrl != null) {
                                    try {
                                        J2EEServerInfo.this.exoConfDir_ = new File(new File(new URI(jbossConfigUrl)), confDirName).getAbsolutePath();
                                        J2EEServerInfo.this.appDeployDirectories_ = Collections.singletonList(new File(new File(new URI(jbossConfigUrl)).getParentFile(), "deploy").getAbsolutePath());
                                    }
                                    catch (SecurityException e) {
                                        if (logEnabled && LOG.isTraceEnabled()) {
                                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                        }
                                        break block45;
                                    }
                                    catch (URISyntaxException e) {
                                        if (logEnabled && LOG.isTraceEnabled()) {
                                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                        }
                                        break block45;
                                    }
                                    catch (IllegalArgumentException e) {
                                        if (logEnabled && LOG.isTraceEnabled()) {
                                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                        }
                                        break block45;
                                    }
                                }
                                String jbossConfigDir = System.getProperty("jboss.server.config.dir");
                                if (jbossConfigDir != null) {
                                    try {
                                        J2EEServerInfo.this.exoConfDir_ = new File(jbossConfigDir, confDirName).getAbsolutePath();
                                        J2EEServerInfo.this.appDeployDirectories_ = Collections.singletonList(new File(new File(jbossConfigDir).getParentFile(), "deployments").getAbsolutePath());
                                    }
                                    catch (SecurityException e) {
                                        if (!logEnabled || !LOG.isTraceEnabled()) break block45;
                                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                    }
                                }
                            }
                            try {
                                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.mx.util.MBeanServerLocator");
                                Method m = clazz.getMethod("locateJBoss", new Class[0]);
                                J2EEServerInfo.this.mbeanServer = (MBeanServer)m.invoke(null, new Object[0]);
                            }
                            catch (ClassNotFoundException ignore) {
                                if (logEnabled && LOG.isDebugEnabled()) {
                                    LOG.debug((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
                                }
                                break block46;
                            }
                            catch (Exception ignore) {
                                if (logEnabled && LOG.isErrorEnabled()) {
                                    LOG.error((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
                                }
                                break block46;
                            }
                        }
                        if (jettyHome != null) {
                            J2EEServerInfo.this.serverName_ = "jetty";
                            J2EEServerInfo.this.serverHome_ = jettyHome;
                            J2EEServerInfo.this.appDeployDirectories_ = Collections.singletonList(new File(jettyHome, "webapps").getAbsolutePath());
                            J2EEServerInfo.this.appDeployArchives_ = Collections.singleton(Archive.WAR);
                        } else if (websphereHome != null) {
                            J2EEServerInfo.this.serverName_ = "websphere";
                            J2EEServerInfo.this.serverHome_ = websphereHome;
                        } else if (weblogicHome != null) {
                            J2EEServerInfo.this.serverName_ = "weblogic";
                            J2EEServerInfo.this.serverHome_ = weblogicHome;
                        } else if (glassfishHome != null) {
                            J2EEServerInfo.this.serverName_ = "glassfish";
                            J2EEServerInfo.this.serverHome_ = glassfishHome;
                        } else if (catalinaHome != null) {
                            J2EEServerInfo.this.serverName_ = "tomcat";
                            J2EEServerInfo.this.serverHome_ = catalinaHome;
                            J2EEServerInfo.this.appDeployDirectories_ = Collections.singletonList(new File(catalinaHome, "webapps").getAbsolutePath());
                            J2EEServerInfo.this.appDeployArchives_ = Collections.singleton(new Archive("war", true, false, null));
                        } else if (testHome != null) {
                            J2EEServerInfo.this.serverName_ = "test";
                            J2EEServerInfo.this.serverHome_ = testHome;
                        } else {
                            J2EEServerInfo.this.serverName_ = "standalone";
                            J2EEServerInfo.this.serverHome_ = System.getProperty("user.dir");
                        }
                    }
                }
                if (J2EEServerInfo.this.exoConfDir_ == null) {
                    J2EEServerInfo.this.exoConfDir_ = J2EEServerInfo.this.serverHome_ + "/" + confDirName;
                }
                if (J2EEServerInfo.this.mbeanServer == null) {
                    J2EEServerInfo.this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                if ((exoConfHome = System.getProperty(J2EEServerInfo.EXO_CONF_PARAM)) != null && exoConfHome.length() > 0) {
                    if (logEnabled && LOG.isInfoEnabled()) {
                        LOG.info((Object)("Override exo-conf directory '" + J2EEServerInfo.this.exoConfDir_ + "' with location '" + exoConfHome + "'"));
                    }
                    J2EEServerInfo.this.exoConfDir_ = exoConfHome;
                }
                if ((archiveDirs = System.getProperty(J2EEServerInfo.EXO_ARCHIVE_DIRS_PARAM)) != null) {
                    StringTokenizer st = new StringTokenizer(archiveDirs, ",");
                    if (st.hasMoreTokens()) {
                        if (logEnabled && LOG.isInfoEnabled()) {
                            LOG.info((Object)("The location of the archives has been set to '" + archiveDirs + "'"));
                        }
                        ArrayList<String> dirs = new ArrayList<String>();
                        while (st.hasMoreTokens()) {
                            String dir = st.nextToken().trim().replace('\\', '/');
                            String path = new File(J2EEServerInfo.this.serverHome_, dir).getAbsolutePath();
                            if (logEnabled && LOG.isDebugEnabled()) {
                                LOG.debug("Location of the archives: {}", new Object[]{path});
                            }
                            dirs.add(path);
                        }
                        J2EEServerInfo.this.appDeployDirectories_ = dirs;
                    } else {
                        J2EEServerInfo.this.appDeployDirectories_ = null;
                    }
                }
                if (J2EEServerInfo.this.appDeployDirectories_ == null) {
                    if (logEnabled && LOG.isInfoEnabled()) {
                        LOG.info((Object)"No location of the archives has been set");
                    }
                } else if (J2EEServerInfo.this.appDeployArchives_ == null) {
                    J2EEServerInfo.this.appDeployArchives_ = new HashSet<Archive>(Arrays.asList(Archive.EAR, Archive.WAR));
                }
                J2EEServerInfo.this.serverHome_ = J2EEServerInfo.this.serverHome_.replace('\\', '/');
                J2EEServerInfo.this.exoConfDir_ = J2EEServerInfo.this.exoConfDir_.replace('\\', '/');
                return null;
            }
        });
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public String getServerName() {
        return this.serverName_;
    }

    public String getServerHome() {
        return this.serverHome_;
    }

    public String getExoConfigurationDirectory() {
        return this.exoConfDir_;
    }

    public List<String> getApplicationDeployDirectories() {
        return this.appDeployDirectories_;
    }

    public Set<Archive> getApplicationDeployArchives() {
        return this.appDeployArchives_;
    }

    public boolean isJBoss() {
        return "jboss".equals(this.serverName_);
    }
}

