/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.util.TemplateConfigurationHelper;
import org.exoplatform.container.util.Utils;

public class TestTemplateConfigurationHelper
extends TestCase {
    public void testFilters() {
        TemplateConfigurationHelper helper = new TemplateConfigurationHelper(new String[]{"^foo-.*", "^jgroups-configuration"}, new String[]{"^foo-configuration"}, (ConfigurationManager)new ConfigurationManagerImpl());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("foo-configuration", "");
        parameters.put("foo-cache.loader", "");
        parameters.put("foo-clustername", "");
        parameters.put("max-volatile-size", "");
        Map preparedParameters = helper.prepareParameters(parameters);
        TestTemplateConfigurationHelper.assertEquals((int)2, (int)preparedParameters.size());
        TestTemplateConfigurationHelper.assertFalse((boolean)preparedParameters.containsKey("${foo-configuration}"));
        TestTemplateConfigurationHelper.assertFalse((boolean)preparedParameters.containsKey("${max-volatile-size}"));
        TestTemplateConfigurationHelper.assertTrue((boolean)preparedParameters.containsKey("${foo-cache.loader}"));
        TestTemplateConfigurationHelper.assertTrue((boolean)preparedParameters.containsKey("${foo-clustername}"));
    }

    public void testFilters2() {
        TemplateConfigurationHelper helper = new TemplateConfigurationHelper(new String[]{"^foo-.*", "^jgroups-configuration"}, new String[]{"^foo-configuration"}, (ConfigurationManager)new ConfigurationManagerImpl());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("jgroups-configuration", "");
        parameters.put("foo-cache.loader", "");
        parameters.put("foo-clustername", "");
        parameters.put("max-volatile-size", "");
        Map preparedParameters = helper.prepareParameters(parameters);
        TestTemplateConfigurationHelper.assertEquals((int)3, (int)preparedParameters.size());
        TestTemplateConfigurationHelper.assertFalse((boolean)preparedParameters.containsKey("${max-volatile-size}"));
        TestTemplateConfigurationHelper.assertTrue((boolean)preparedParameters.containsKey("${foo-cache.loader}"));
        TestTemplateConfigurationHelper.assertTrue((boolean)preparedParameters.containsKey("${foo-clustername}"));
    }

    public void testTemplating() throws IOException {
        TemplateConfigurationHelper helper = new TemplateConfigurationHelper(new String[]{"^foo-.*", "^jgroups-configuration"}, new String[]{"^foo-configuration"}, (ConfigurationManager)new ConfigurationManagerImpl());
        String template = "configuration in any format, containing ${foo-template-variable} and many others";
        String expectedConfig = "configuration in any format, containing pretty good parameter and many others";
        ByteArrayInputStream templateStream = new ByteArrayInputStream(template.getBytes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("foo-template-variable", "pretty good parameter");
        InputStream configStream = helper.fillTemplate((InputStream)templateStream, parameters);
        String config = Utils.readStream((InputStream)configStream);
        TestTemplateConfigurationHelper.assertTrue((boolean)expectedConfig.equals(config));
    }
}

