/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.util;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import junit.framework.TestCase;
import org.exoplatform.container.util.ContainerUtil;

public class TestContainerUtil
extends TestCase {
    public void testJBossAS6CL() throws Exception {
        ClassLoader oldCLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new JBossAS6MockClassLoader());
            Collection urls = ContainerUtil.getConfigurationURL((String)"conf/configuration.xml");
            TestContainerUtil.assertNotNull((Object)urls);
            TestContainerUtil.assertEquals((int)3, (int)urls.size());
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCLoader);
        }
    }

    public void testGetServletContextName() {
        final AtomicReference<String> scn = new AtomicReference<String>("myContextName");
        final AtomicReference<String> scp = new AtomicReference<String>("/myContextPath");
        ServletContext context = (ServletContext)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ServletContext.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("getServletContextName".equals(method.getName())) {
                    return scn.get();
                }
                if ("getContextPath".equals(method.getName())) {
                    return scp.get();
                }
                return null;
            }
        });
        TestContainerUtil.assertEquals((String)"myContextName", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scn.set(null);
        TestContainerUtil.assertEquals((String)"myContextPath", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set("");
        TestContainerUtil.assertEquals((String)"", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set("/a/b");
        TestContainerUtil.assertEquals((String)"a", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set("/a2/b/");
        TestContainerUtil.assertEquals((String)"a2", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set("a3/b");
        TestContainerUtil.assertEquals((String)"a3", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set("a4/b/");
        TestContainerUtil.assertEquals((String)"a4", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set(null);
        TestContainerUtil.assertNull((Object)ContainerUtil.getServletContextName((ServletContext)context));
    }

    private static class JBossAS6MockClassLoader
    extends ClassLoader {
        private JBossAS6MockClassLoader() {
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(new URL("file:///GateIn-JBoss6/server/default/deploy/gatein.ear/lib/exo.portal.webui.portal.jar/conf/configuration.xml"));
            urls.add(new URL("file:///GateIn-JBoss6/server/default/deploy/gatein.ear/lib/exo.core.component.xml-processing/conf/configuration.xml"));
            urls.add(new URL("file:///GateIn-JBoss6/server/default/deploy/gatein-sample-extension.ear/sample-ext.war/WEB-INF/conf/configuration.xml"));
            urls.add(new URL("file:///GateIn-JBoss6/server/default/deploy/gatein.ear/lib/exo.kernel.commons.jar/conf/configuration.xml"));
            return Collections.enumeration(urls);
        }
    }
}

