/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.context;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.component.ThreadContext;
import org.exoplatform.container.component.ThreadContextHolder;
import org.exoplatform.container.context.AdvancedContext;
import org.exoplatform.container.context.ContextManager;
import org.exoplatform.container.context.ContextPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ContextManagerImpl
implements ContextManager,
ThreadContextHolder {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ContextManagerImpl");
    private volatile Map<String, AdvancedContext<?>> contexts = Collections.unmodifiableMap(new HashMap());

    @Override
    public <K> AdvancedContext<K> getContext(Class<? extends Annotation> scope) throws IllegalStateException {
        return this.contexts.get(scope.getName());
    }

    @Override
    public boolean hasContext(Class<? extends Annotation> scope) {
        return this.contexts.containsKey(scope.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K> void addContext(AdvancedContext<K> ctx) {
        ContextManagerImpl contextManagerImpl = this;
        synchronized (contextManagerImpl) {
            HashMap contextsTmp = new HashMap(this.contexts);
            contextsTmp.put(ctx.getScope().getName(), ctx);
            this.contexts = Collections.unmodifiableMap(contextsTmp);
            LOG.info("A context of type {} has been defined for the scope {}", new Object[]{ctx.getClass().getName(), ctx.getScope().getName()});
        }
    }

    public void addContexts(ContextPlugin plugin) {
        List<AdvancedContext> contexts = plugin.getContexts();
        if (contexts == null) {
            return;
        }
        for (AdvancedContext ctx : contexts) {
            this.addContext(ctx);
        }
    }

    @Override
    public ThreadContext getThreadContext() {
        Collection<AdvancedContext<?>> allContexts = this.contexts.values();
        ArrayList<ThreadContext> result = new ArrayList<ThreadContext>();
        for (AdvancedContext<?> ctx : allContexts) {
            if (!(ctx instanceof ThreadContextHolder)) continue;
            ThreadContextHolder holder = (ThreadContextHolder)((Object)ctx);
            result.add(holder.getThreadContext());
        }
        return ThreadContext.merge(result);
    }
}

