/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;

public class ContainerBuilder {
    private final ThreadLocal<String> bootedPortalName = new ThreadLocal();
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private List<URL> configURLs = new ArrayList<URL>();
    private LinkedHashMap<String, List<URL>> portalConfigURLs = new LinkedHashMap();
    private Set<String> profiles;

    public ContainerBuilder withRoot(String configPath) {
        this.configURLs.addAll(this.urls(configPath));
        return this;
    }

    public ContainerBuilder withRoot(URL configURL) {
        this.configURLs.add(configURL);
        return this;
    }

    public ContainerBuilder withPortal(String configPath) {
        return this.withPortal("portal", configPath);
    }

    public ContainerBuilder withPortal(String portalName, String configPath) {
        for (URL configURL : this.urls(configPath)) {
            this.withPortal(portalName, configURL);
        }
        return this;
    }

    public ContainerBuilder withPortal(URL configURL) {
        return this.withPortal("portal", configURL);
    }

    public ContainerBuilder withPortal(String portalName, URL configURL) {
        List<URL> urls = this.portalConfigURLs.get(portalName);
        if (urls == null) {
            urls = new ArrayList<URL>();
            this.portalConfigURLs.put(portalName, urls);
        }
        urls.add(configURL);
        return this;
    }

    public ContainerBuilder withLoader(ClassLoader loader) {
        this.loader = loader;
        return this;
    }

    public ContainerBuilder profiledBy(String ... profiles) {
        this.profiles = Tools.set((Object[])profiles);
        return this;
    }

    private List<URL> urls(String path) {
        try {
            return Collections.list(this.loader.getResources(path));
        }
        catch (IOException e) {
            AssertionFailedError err = new AssertionFailedError();
            err.initCause((Throwable)e);
            throw err;
        }
    }

    public RootContainer build() {
        PrivilegedExceptionAction<RootContainer> action = new PrivilegedExceptionAction<RootContainer>(){

            @Override
            public RootContainer run() throws Exception {
                return ContainerBuilder.this._build();
            }
        };
        try {
            return (RootContainer)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            AssertionFailedError err = new AssertionFailedError();
            err.initCause(cause);
            throw err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RootContainer _build() throws Exception {
        RootContainer root;
        if (this.configURLs.size() == 0) {
            throw new IllegalStateException("Must provide at least one URL for building the root container");
        }
        Field topContainerField = ExoContainerContext.class.getDeclaredField("topContainer");
        topContainerField.setAccessible(true);
        topContainerField.set(null, null);
        ExoContainerContext.setCurrentContainer(null);
        Field singletonField = RootContainer.class.getDeclaredField("singleton_");
        singletonField.setAccessible(true);
        singletonField.set(null, null);
        if (this.profiles == null) {
            PropertyManager.setProperty((String)"exo.profiles", (String)"");
        } else {
            StringBuilder builder = new StringBuilder();
            Iterator<String> i = this.profiles.iterator();
            while (i.hasNext()) {
                builder.append(i.next());
                if (!i.hasNext()) continue;
                builder.append(',');
            }
            PropertyManager.setProperty((String)"exo.profiles", (String)builder.toString());
        }
        ClassLoader rootCL = new ClassLoader(this.loader){

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                if ("conf/configuration.xml".equals(name)) {
                    return Collections.enumeration(ContainerBuilder.this.configURLs);
                }
                if ("conf/portal/configuration.xml".equals(name)) {
                    String portalName = (String)ContainerBuilder.this.bootedPortalName.get();
                    return Collections.enumeration((Collection)ContainerBuilder.this.portalConfigURLs.get(portalName));
                }
                if ("conf/portal/test-configuration.xml".equals(name)) {
                    return Collections.enumeration(Collections.emptyList());
                }
                return super.getResources(name);
            }
        };
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(rootCL);
            root = RootContainer.getInstance();
            PortalContainer.reloadConfig();
            for (String portalName : this.portalConfigURLs.keySet()) {
                try {
                    this.bootedPortalName.set(portalName);
                    root.getPortalContainer(portalName);
                }
                finally {
                    this.bootedPortalName.set(null);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        return root;
    }

    public static RootContainer bootstrap(URL configurationURL, String ... profiles) {
        ContainerBuilder builder = new ContainerBuilder();
        builder.withRoot(configurationURL);
        builder.profiledBy(profiles);
        return builder.build();
    }
}

