/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.container.spi.Container;
import org.exoplatform.container.spi.ContainerException;
import org.exoplatform.container.spi.ContainerVisitor;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Disposable;
import org.picocontainer.Startable;

public class LifecycleVisitor
implements ContainerVisitor {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.LifecycleVisitor");
    private static final Method START;
    private static final Method STOP;
    private static final Method DISPOSE;
    private final Method method;
    private final Class<?> type;
    private final boolean visitInInstantiationOrder;
    private final List<Object> componentInstances;
    private final boolean ignoreError;

    public LifecycleVisitor(Method method, Class<?> ofType, boolean visitInInstantiationOrder, boolean ignoreError) {
        this.method = method;
        this.type = ofType;
        this.visitInInstantiationOrder = visitInInstantiationOrder;
        this.componentInstances = new ArrayList<Object>();
        this.ignoreError = ignoreError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object traverse(Container container) {
        this.componentInstances.clear();
        try {
            this.visitContainer(container);
            if (!this.visitInInstantiationOrder) {
                Collections.reverse(this.componentInstances);
            }
            for (Object o : this.componentInstances) {
                try {
                    this.method.invoke(o, (Object[])null);
                }
                catch (IllegalArgumentException e) {
                    if (!this.ignoreError) throw new ContainerException("Can't call " + this.method.getName() + " on " + o, e);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Can't call " + this.method.getName() + " on " + o), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    if (!this.ignoreError) throw new ContainerException("Can't call " + this.method.getName() + " on " + o, e);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Can't call " + this.method.getName() + " on " + o), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    if (!this.ignoreError) throw new ContainerException("Failed when calling " + this.method.getName() + " on " + o, e.getTargetException());
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Failed when calling " + this.method.getName() + " on " + o), e.getTargetException());
                    continue;
                    return Void.TYPE;
                }
            }
        }
        finally {
            this.componentInstances.clear();
        }
    }

    @Override
    public void visitContainer(Container container) {
        this.componentInstances.addAll(container.getComponentInstancesOfType(this.type));
    }

    public static void start(Container container) {
        new LifecycleVisitor(START, Startable.class, true, false).traverse(container);
    }

    public static void stop(Container container) {
        new LifecycleVisitor(STOP, Startable.class, false, true).traverse(container);
    }

    public static void dispose(Container container) {
        new LifecycleVisitor(DISPOSE, Disposable.class, false, true).traverse(container);
    }

    static {
        try {
            START = Startable.class.getMethod("start", null);
            STOP = Startable.class.getMethod("stop", null);
            DISPOSE = Disposable.class.getMethod("dispose", null);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

