/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.Assert;
import org.databene.contiperf.PerfTest;
import org.databene.contiperf.junit.ContiPerfRule;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.TestExoContainer;
import org.exoplatform.container.jmx.AbstractTestContainer;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.spi.ContainerException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestExoContainerThreadSafety {
    protected static final int TOTAL_THREADS = 50;
    @Rule
    public ContiPerfRule rule = new ContiPerfRule();
    private CyclicBarrier startSignal = new CyclicBarrier(50);
    private AtomicReference<TestExoContainer.MyMTClass> currentMyClass = new AtomicReference();
    private AtomicReference<ComponentAdapter<?>> ar = new AtomicReference();
    private RootContainer container;

    @Before
    public void setUp() {
        this.container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml");
    }

    @Test
    @PerfTest(invocations=50, threads=50)
    public void getComponentInstance() throws InterruptedException, BrokenBarrierException {
        this.startSignal.await();
        TestExoContainer.MyMTClass value = (TestExoContainer.MyMTClass)this.container.getComponentInstance(TestExoContainer.MyMTClass.class);
        this.currentMyClass.compareAndSet(null, value);
        Assert.assertEquals((Object)this.currentMyClass.get(), (Object)this.container.getComponentInstance(TestExoContainer.MyMTClass.class));
    }

    @Test
    @PerfTest(invocations=50, threads=50)
    public void getComponentInstanceOfType() throws InterruptedException, BrokenBarrierException {
        this.startSignal.await();
        TestExoContainer.MyMTClass value = (TestExoContainer.MyMTClass)this.container.getComponentInstanceOfType(TestExoContainer.MyMTClass.class);
        this.currentMyClass.compareAndSet(null, value);
        Assert.assertEquals((Object)this.currentMyClass.get(), (Object)this.container.getComponentInstanceOfType(TestExoContainer.MyMTClass.class));
    }

    @Test
    @PerfTest(invocations=50, threads=50)
    public void registerGetNUnregister() throws InterruptedException, BrokenBarrierException {
        this.startSignal.await();
        try {
            this.ar.compareAndSet(null, this.container.registerComponentInstance((Object)"a", (Object)new TestExoContainer.MyClass()));
        }
        catch (ContainerException containerException) {
            // empty catch block
        }
        this.startSignal.await();
        Assert.assertEquals(this.ar.get(), (Object)this.container.getComponentAdapter((Object)"a"));
        this.startSignal.await();
        this.container.unregisterComponent((Object)"a");
    }

    @Test
    @PerfTest(invocations=50, threads=50)
    public void callMainMethods() throws InterruptedException, BrokenBarrierException {
        this.startSignal.await();
        Object key = new Object();
        Assert.assertNotNull((Object)this.container.registerComponentInstance(key, (Object)new TestExoContainer.MyClass()));
        Assert.assertNotNull((Object)this.container.getComponentAdapter(key));
        Assert.assertFalse((boolean)this.container.getComponentAdapters().isEmpty());
        Assert.assertFalse((boolean)this.container.getComponentAdaptersOfType(TestExoContainer.MyClass.class).isEmpty());
        Assert.assertNotNull((Object)this.container.getComponentInstance(key));
        Assert.assertNotNull((Object)this.container.getComponentInstanceOfType(TestExoContainer.MyClass.class));
        Assert.assertFalse((boolean)this.container.getComponentInstancesOfType(TestExoContainer.MyClass.class).isEmpty());
        Assert.assertNotNull((Object)this.container.unregisterComponent(key));
    }
}

