/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.configuration.ConfigurationUnmarshaller;
import org.exoplatform.container.monitor.jvm.JVMRuntimeInfo;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;

public class TestConfigurationService
extends TestCase {
    public TestConfigurationService(String name) {
        super(name);
    }

    public void testXSDBadSchema() throws Exception {
        ConfigurationUnmarshaller unmarshaller = new ConfigurationUnmarshaller();
        URL url = TestConfigurationService.class.getResource("../../../../configuration-bad-schema.xml");
        try {
            unmarshaller.unmarshall(url);
            TestConfigurationService.fail((String)"JIBX should have failed");
        }
        catch (JiBXException jiBXException) {
            // empty catch block
        }
    }

    public void testXSDNoSchema() throws Exception {
        ConfigurationUnmarshaller unmarshaller = new ConfigurationUnmarshaller();
        URL url = TestConfigurationService.class.getResource("../../../../configuration-no-schema.xml");
        Configuration conf = unmarshaller.unmarshall(url);
        TestConfigurationService.assertNotNull((Object)conf);
    }

    public void testMarshallAndUnmarshall() throws Exception {
        String basedir = System.getProperty("basedir");
        ConfigurationUnmarshaller unmarshaller = new ConfigurationUnmarshaller();
        URL url = TestConfigurationService.class.getResource("../../../../configuration.xml");
        Configuration obj = unmarshaller.unmarshall(url);
        IBindingFactory bfact = BindingDirectory.getFactory(Configuration.class);
        IMarshallingContext mctx = bfact.createMarshallingContext();
        mctx.setIndent(2);
        mctx.marshalDocument((Object)obj, "UTF-8", null, (OutputStream)new FileOutputStream(basedir + "/target/configuration.xml"));
    }

    public void testConfigurationService(InitParams params) throws Exception {
        ObjectParameter objParam = params.getObjectParam("new.user.configuration");
        objParam.getObject();
    }

    public void testJVMEnvironment() throws Exception {
        JVMRuntimeInfo jvm = (JVMRuntimeInfo)RootContainer.getInstance().getComponentInstanceOfType(JVMRuntimeInfo.class);
    }

    protected String getDescription() {
        return "Test Configuration Service";
    }
}

