/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.log;

import java.util.Properties;
import junit.framework.TestCase;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.log.LogConfigurationInitializer;

public class TestLoggers
extends TestCase {
    private final String logger = "org.slf4j.Logger";

    public void _testExoLogPerformance() throws Exception {
        Log log = ExoLogger.getLogger(TestLoggers.class);
        String confClass = "org.exoplatform.services.log.impl.Log4JConfigurator";
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO, stdout, file");
        props.put("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.stdout.threshold", "DEBUG");
        props.put("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.stdout.layout.ConversionPattern", "%d{dd.MM.yyyy HH:mm:ss} *%-5p* [%t] %c{1}: %m (%F, line %L) %n");
        props.put("log4j.appender.file", "org.apache.log4j.FileAppender");
        props.put("log4j.appender.file.File", "target/l4j_info.log");
        props.put("log4j.appender.file.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.file.layout.ConversionPattern", "%d{dd.MM.yyyy HH:mm:ss} *%-5p* [%t] %c{1}: %m (%F, line %L) %n");
        new LogConfigurationInitializer("org.slf4j.Logger", confClass, props);
        log.info((Object)"Performance test.");
    }

    public void _testLog4j() throws Exception {
        Log log = ExoLogger.getLogger(TestLoggers.class);
        String confClass = "org.exoplatform.services.log.impl.Log4JConfigurator";
        Properties props = new Properties();
        props.put("log4j.rootLogger", "DEBUG, stdout, file");
        props.put("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.stdout.threshold", "DEBUG");
        props.put("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.stdout.layout.ConversionPattern", "%d{dd.MM.yyyy HH:mm:ss} *%-5p* [%t] %c{1}: %m (%F, line %L) %n");
        props.put("log4j.appender.file", "org.apache.log4j.FileAppender");
        props.put("log4j.appender.file.File", "target/l4j_info.log");
        props.put("log4j.appender.file.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.file.layout.ConversionPattern", "%d{dd.MM.yyyy HH:mm:ss} *%-5p* [%t] %c{1}: %m (%F, line %L) %n");
        LogConfigurationInitializer initializer = new LogConfigurationInitializer("org.slf4j.Logger", confClass, props);
        log.info((Object)"LOG4J Tests");
        this.logOut(log);
        initializer.setProperty("log4j.rootLogger", "INFO, stdout, file");
        initializer.setProperty("log4j.appender.file.File", "target/l4j_debg.log");
        this.logOut(log);
    }

    public void testLog4jContainer() throws Exception {
        PortalContainer.getInstance();
        Log log = ExoLogger.getLogger(TestLoggers.class);
        log.info((Object)"Log4j Container Tests");
        log.info("Log4j Container {}", new Object[]{"Tests"});
        log.info("Log4j Conta{} Te{}", new Object[]{"iner", "sts"});
        log.info("Log4j Container Tests", new Object[]{1, 2, 3});
        this.logOut(log);
    }

    public void _testJCLLog() throws Exception {
        String confClass = "org.exoplatform.services.log.impl.Jdk14Configurator";
        Properties props = new Properties();
        props.put("handlers", "java.util.logging.ConsoleHandler,java.util.logging.FileHandler");
        props.put(".level", "INFO");
        props.put("java.util.logging.ConsoleHandler.level", "ALL");
        props.put("java.util.logging.FileHandler.pattern", "./target/java%u.log");
        props.put("java.util.logging.FileHandler.formatter", "java.util.logging.SimpleFormatter");
        new LogConfigurationInitializer("org.slf4j.Logger", confClass, props);
        Log log = ExoLogger.getLogger(TestLoggers.class);
        log.info((Object)"JCL Tests");
        this.logOut(log);
    }

    public void _testJCLContainer() throws Exception {
        PortalContainer.getInstance();
        Log log = ExoLogger.getLogger(TestLoggers.class);
        log.info((Object)"JCL Container Tests");
        this.logOut(log);
    }

    private void logOut(Log log) {
        log.debug((Object)(log.getClass().getName() + ": \tDEBUG"));
        log.error((Object)(log.getClass().getName() + ": \tERROR"));
        log.info((Object)(log.getClass().getName() + ": \tINFO"));
        log.trace((Object)(log.getClass().getName() + ": \tTRACE"));
        log.warn((Object)(log.getClass().getName() + ": \tWARNING\n"));
    }
}

