/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import junit.framework.TestCase;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.xml.Configuration;

public class TestConfigurationManagerImpl
extends TestCase {
    public void testGetURL() throws Exception {
        ConfigurationManagerImpl cm = new ConfigurationManagerImpl();
        URL url = cm.getURL(null);
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm.getURL("jar:/org/exoplatform/container/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm.getURL("jar:/org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm.getURL("classpath:/org/exoplatform/container/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm.getURL("classpath:/org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm.getURL("classpath:org/exoplatform/container/configuration/empty-config.xml");
        TestConfigurationManagerImpl.assertTrue((boolean)url.getPath().endsWith("org/exoplatform/container/configuration/empty-config.xml"));
        this.checkURL(url);
        url = cm.getURL("jar:org/exoplatform/container/configuration/empty-config.xml");
        TestConfigurationManagerImpl.assertTrue((boolean)url.getPath().endsWith("org/exoplatform/container/configuration/empty-config.xml"));
        this.checkURL(url);
        try {
            url = cm.getURL("war:/org/exoplatform/container/configuration/empty-config.xml");
            TestConfigurationManagerImpl.fail((String)"An error should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            url = cm.getURL("war:/org/exoplatform/container/configuration/empty-config-fake.xml");
            TestConfigurationManagerImpl.fail((String)"An error should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String sURL = ((Object)((Object)this)).getClass().getResource("empty-config.xml").toString();
        sURL = URLDecoder.decode(sURL, "UTF-8");
        TestConfigurationManagerImpl.assertNotNull((Object)sURL);
        TestConfigurationManagerImpl.assertTrue((String)"the expected path should starts with file:", (boolean)sURL.startsWith("file:"));
        sURL = sURL.substring(0, sURL.lastIndexOf(47));
        sURL = sURL.substring(0, sURL.lastIndexOf(47));
        url = cm.getURL(sURL + "/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm.getURL(sURL + "/configuration/empty-config-fake.xml");
        this.checkURL(url, true);
        url = cm.getURL(sURL + "\\configuration\\empty-config.xml");
        this.checkURL(url);
        url = cm.getURL(sURL + "\\configuration\\empty-config-fake.xml");
        this.checkURL(url, true);
        cm.addConfiguration(cm.getURL(sURL + "/configuration/empty-config.xml"));
        url = cm.getURL("import-configuration.xml");
        this.checkURL(url);
        String sArchiveURL = sURL.replace("file:", "ar:");
        url = cm.getURL(sArchiveURL + "/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm.getURL(sArchiveURL + "/configuration/empty-config-fake.xml");
        this.checkURL(url, true);
        url = cm.getURL(sArchiveURL + "\\configuration\\empty-config.xml");
        this.checkURL(url);
        url = cm.getURL(sArchiveURL + "\\configuration\\empty-config-fake.xml");
        this.checkURL(url, true);
        cm.addConfiguration(cm.getURL(sArchiveURL + "/configuration/empty-config.xml"));
        url = cm.getURL("import-configuration.xml");
        this.checkURL(url);
        cm = new ConfigurationManagerImpl();
        Object incompleteURL = "file:/" + ((Object)((Object)this)).getClass().getResource("empty-config.xml").getPath();
        incompleteURL = ((String)incompleteURL).substring(0, ((String)incompleteURL).lastIndexOf(47));
        url = cm.getURL((String)incompleteURL + "/empty-config.xml");
        this.checkURL(url);
        url = cm.getURL((String)incompleteURL + "/empty-config-fake.xml");
        this.checkURL(url, true);
        incompleteURL = "file:" + ((Object)((Object)this)).getClass().getResource("empty-config.xml").getPath();
        incompleteURL = ((String)incompleteURL).substring(0, ((String)incompleteURL).lastIndexOf(47));
        url = cm.getURL((String)incompleteURL + "/empty-config.xml");
        this.checkURL(url);
        url = cm.getURL((String)incompleteURL + "/empty-config-fake.xml");
        this.checkURL(url, true);
        url = cm.getURL("org/exoplatform/container/configuration/empty-config.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm.getURL("org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        ConfigurationManagerImpl cm1 = new ConfigurationManagerImpl(Thread.currentThread().getContextClassLoader(), null);
        url = cm1.getURL(null);
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm1.getURL("jar:/org/exoplatform/container/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm1.getURL("jar:/org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm1.getURL("classpath:/org/exoplatform/container/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm1.getURL("classpath:/org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm1.getURL("war:/org/exoplatform/container/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm1.getURL("war:/org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm1.getURL(sURL + "/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm1.getURL(sURL + "/configuration/empty-config-fake.xml");
        this.checkURL(url, true);
        url = cm1.getURL("org/exoplatform/container/configuration/empty-config.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm1.getURL("org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        ConfigurationManagerImpl cm2 = new ConfigurationManagerImpl((ServletContext)new MockServletContext(), null);
        url = cm2.getURL(null);
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm2.getURL("jar:/org/exoplatform/container/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm2.getURL("jar:/org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm2.getURL("classpath:/org/exoplatform/container/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm2.getURL("classpath:/org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm2.getURL("war:/org/exoplatform/container/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm2.getURL("war:/org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm2.getURL(sURL + "/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm2.getURL(sURL + "/configuration/empty-config-fake.xml");
        this.checkURL(url, true);
        url = cm2.getURL("org/exoplatform/container/configuration/empty-config.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm2.getURL("org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        ConfigurationManagerImpl cm3 = new ConfigurationManagerImpl();
        String path = ((Object)((Object)this)).getClass().getResource("empty-config.xml").getPath();
        path = URLDecoder.decode(path, "UTF-8");
        TestConfigurationManagerImpl.assertNotNull((Object)path);
        path = path.substring(0, path.lastIndexOf(47));
        cm3.addConfiguration(new File(path).toURI().toURL());
        url = cm3.getURL(null);
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm3.getURL("jar:/org/exoplatform/container/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm3.getURL("jar:/org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm3.getURL("classpath:/org/exoplatform/container/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm3.getURL("classpath:/org/exoplatform/container/configuration/empty-config-fake.xml");
        TestConfigurationManagerImpl.assertNull((Object)url);
        try {
            url = cm3.getURL("war:/org/exoplatform/container/configuration/empty-config.xml");
            TestConfigurationManagerImpl.fail((String)"An error should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            url = cm3.getURL("war:/org/exoplatform/container/configuration/empty-config-fake.xml");
            TestConfigurationManagerImpl.fail((String)"An error should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        url = cm3.getURL(sURL + "/configuration/empty-config.xml");
        this.checkURL(url);
        url = cm3.getURL(sURL + "/configuration/empty-config-fake.xml");
        this.checkURL(url, true);
        url = cm3.getURL("configuration/empty-config.xml");
        this.checkURL(url);
        url = cm3.getURL("configuration/empty-config-fake.xml");
        this.checkURL(url, true);
        url = cm3.getURL("configuration\\empty-config.xml");
        this.checkURL(url);
        url = cm3.getURL("configuration\\empty-config-fake.xml");
        this.checkURL(url, true);
    }

    public void testGetFileURL() throws Exception {
        ConfigurationManagerImpl cm = new ConfigurationManagerImpl();
        URL url = cm.getURL(null);
        TestConfigurationManagerImpl.assertNull((Object)url);
        url = cm.getURL("file:F:\\somepath\\path\\configuration.xml");
        TestConfigurationManagerImpl.assertEquals((String)"file:/F:/somepath/path/configuration.xml", (String)url.toString());
        try {
            cm.addConfiguration("file:D:\\somepath\\config.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        url = cm.getURL("configuration.xml");
        TestConfigurationManagerImpl.assertEquals((String)"file:/D:/somepath/configuration.xml", (String)url.toString());
    }

    public void testImport() throws Exception {
        ConfigurationManagerImpl cm = new ConfigurationManagerImpl();
        cm.addConfiguration("classpath:/org/exoplatform/container/configuration/config-manager-configuration-a.xml");
        Configuration conf = cm.getConfiguration();
        TestConfigurationManagerImpl.assertNotNull((Object)conf.getComponent("A"));
        TestConfigurationManagerImpl.assertTrue((boolean)conf.getComponent("A").getDocumentURL().getFile().endsWith("config-manager-configuration-a.xml"));
        TestConfigurationManagerImpl.assertNull((Object)conf.getComponent("B"));
        TestConfigurationManagerImpl.assertNull((Object)conf.getComponent("C"));
        cm = new ConfigurationManagerImpl();
        cm.addConfiguration("classpath:/org/exoplatform/container/configuration/config-manager-configuration-b.xml");
        conf = cm.getConfiguration();
        TestConfigurationManagerImpl.assertNotNull((Object)conf.getComponent("A"));
        TestConfigurationManagerImpl.assertTrue((boolean)conf.getComponent("A").getDocumentURL().getFile().endsWith("config-manager-configuration-a.xml"));
        TestConfigurationManagerImpl.assertNotNull((Object)conf.getComponent("B"));
        TestConfigurationManagerImpl.assertTrue((boolean)conf.getComponent("B").getDocumentURL().getFile().endsWith("config-manager-configuration-b.xml"));
        TestConfigurationManagerImpl.assertNull((Object)conf.getComponent("C"));
        cm = new ConfigurationManagerImpl();
        cm.addConfiguration("classpath:/org/exoplatform/container/configuration/config-manager-configuration-c.xml");
        conf = cm.getConfiguration();
        TestConfigurationManagerImpl.assertNotNull((Object)conf.getComponent("A"));
        TestConfigurationManagerImpl.assertTrue((boolean)conf.getComponent("A").getDocumentURL().getFile().endsWith("config-manager-configuration-a.xml"));
        TestConfigurationManagerImpl.assertNotNull((Object)conf.getComponent("B"));
        TestConfigurationManagerImpl.assertTrue((boolean)conf.getComponent("B").getDocumentURL().getFile().endsWith("config-manager-configuration-b.xml"));
        TestConfigurationManagerImpl.assertNotNull((Object)conf.getComponent("C"));
        TestConfigurationManagerImpl.assertTrue((boolean)conf.getComponent("C").getDocumentURL().getFile().endsWith("config-manager-configuration-c.xml"));
    }

    private void checkURL(URL url) throws Exception {
        this.checkURL(url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkURL(URL url, boolean empty) throws Exception {
        block15: {
            TestConfigurationManagerImpl.assertNotNull((Object)url);
            InputStream is = null;
            try {
                is = url.openStream();
                if (empty) {
                    TestConfigurationManagerImpl.assertNull((Object)is);
                } else {
                    TestConfigurationManagerImpl.assertNotNull((Object)is);
                    TestConfigurationManagerImpl.assertTrue((is.available() > 0 ? 1 : 0) != 0);
                }
            }
            catch (IOException e) {
                if (empty) {
                    break block15;
                }
                throw e;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static class MockServletContext
    implements ServletContext {
        private MockServletContext() {
        }

        public Object getAttribute(String arg0) {
            return null;
        }

        public Enumeration<String> getAttributeNames() {
            return null;
        }

        public ServletContext getContext(String arg0) {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public String getInitParameter(String arg0) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return null;
        }

        public int getMajorVersion() {
            return 0;
        }

        public String getMimeType(String arg0) {
            return null;
        }

        public int getMinorVersion() {
            return 0;
        }

        public RequestDispatcher getNamedDispatcher(String arg0) {
            return null;
        }

        public String getRealPath(String arg0) {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String arg0) {
            return null;
        }

        public URL getResource(String arg0) throws MalformedURLException {
            String path = arg0.substring("/WEB-INF".length() + 1);
            return Thread.currentThread().getContextClassLoader().getResource(path);
        }

        public InputStream getResourceAsStream(String arg0) {
            return null;
        }

        public Set<String> getResourcePaths(String arg0) {
            return null;
        }

        public String getServerInfo() {
            return null;
        }

        public Servlet getServlet(String arg0) throws ServletException {
            return null;
        }

        public String getServletContextName() {
            return null;
        }

        public Enumeration<String> getServletNames() {
            return null;
        }

        public Enumeration<Servlet> getServlets() {
            return null;
        }

        public void log(String arg0) {
        }

        public void log(Exception arg0, String arg1) {
        }

        public void log(String arg0, Throwable arg1) {
        }

        public void removeAttribute(String arg0) {
        }

        public void setAttribute(String arg0, Object arg1) {
        }

        public int getEffectiveMajorVersion() {
            return 0;
        }

        public int getEffectiveMinorVersion() {
            return 0;
        }

        public boolean setInitParameter(String name, String value) {
            return false;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            return null;
        }

        public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
            return null;
        }

        public ServletRegistration getServletRegistration(String servletName) {
            return null;
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            return null;
        }

        public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
            return null;
        }

        public FilterRegistration getFilterRegistration(String filterName) {
            return null;
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            return null;
        }

        public SessionCookieConfig getSessionCookieConfig() {
            return null;
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            return null;
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            return null;
        }

        public void addListener(String className) {
        }

        public <T extends EventListener> void addListener(T t) {
        }

        public void addListener(Class<? extends EventListener> listenerClass) {
        }

        public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
            return null;
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            return null;
        }

        public ClassLoader getClassLoader() {
            return null;
        }

        public void declareRoles(String ... roleNames) {
        }

        public String getVirtualServerName() {
            return null;
        }
    }
}

