/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.bench;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.ks.bench.InjectInfo;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnswerDataInjector
extends DataInjector {
    private static Log log = ExoLogger.getLogger(AnswerDataInjector.class);
    private Map<String, String> fullNameData = new HashMap<String, String>();
    private int[] infoIject = new int[]{0, 0, 0, 0};
    private Category categoryRoot = null;
    private FAQService faqService;
    private FAQSetting faqSetting = new FAQSetting();
    private List<String> categoryIds = new ArrayList<String>();
    public static final String SLASH = "/".intern();
    public static final String ARRAY_SPLIT = ",";

    public AnswerDataInjector(FAQService faqService) {
        this.faqService = faqService;
        this.initDatas();
    }

    private void initDatas() {
        this.faqSetting.setDisplayMode("");
        this.faqSetting.setEmailSettingSubject("eXo Answers Notification");
        this.faqSetting.setEmailSettingContent("<p>We have a new question or answer by injector datas in category <strong>&categoryName_</strong></p><p><em>&questionContent_</em></p>");
        List<String> users = Arrays.asList("root", "demo", "mary", "john");
        List<String> userFullNames = Arrays.asList("Root Root", "Demo", "Mary Kelly", "John Anthony");
        for (int i = 0; i < users.size(); ++i) {
            this.fullNameData.put(users.get(i), userFullNames.get(i));
        }
    }

    public Log getLog() {
        return log;
    }

    private Category getCategoryRoot(boolean isUpdate) {
        try {
            if (isUpdate || this.categoryRoot == null) {
                this.categoryRoot = this.faqService.getCategoryById("categories");
                if (this.categoryRoot.getModerators() == null || this.categoryRoot.getModerators().length == 0) {
                    this.categoryRoot.setModerators(new String[]{"root"});
                    this.faqService.saveCategory(null, this.categoryRoot, false);
                }
            }
            return this.categoryRoot;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String makeName(String prefix, int leve, int order) {
        return prefix + "_" + leve + "_" + order;
    }

    private String makeId(String prefix, String type, int leve, int order) {
        return type + prefix + leve + order;
    }

    private List<Category> findCategories(int leve, InjectInfo info) {
        ArrayList<Category> categories = new ArrayList<Category>();
        if (info.getCategories() > 0) {
            String catName = "";
            String catId = "";
            for (int i = 0; i < info.getCategories(); ++i) {
                catId = this.makeId(info.getPreCategories(), "Category", leve, i + 1);
                catName = this.makeName(info.getPreCategories(), leve, i + 1);
                Category cat = this.newCategory(catId, catName, i + 1, info);
                categories.add(cat);
            }
        }
        return categories;
    }

    private List<Question> findQuestion(String catId, int leve, InjectInfo info) {
        ArrayList<Question> questions = new ArrayList<Question>();
        if (info.getQuestions() > 0) {
            String queName = "";
            String queId = "";
            for (int i = 0; i < info.getQuestions(); ++i) {
                queId = this.makeId(info.getPreQuestions(), "Question", leve, i + 1);
                queName = this.makeName(info.getPreQuestions(), leve, i + 1);
                questions.add(this.newQuestion(catId, queId, queName, info));
            }
        }
        return questions;
    }

    private List<Answer> findAnswers(InjectInfo info) {
        ArrayList<Answer> answers = new ArrayList<Answer>();
        if (info.getAnswers() > 0) {
            String asId = "";
            for (int i = 0; i < info.getAnswers(); ++i) {
                asId = this.makeId(info.getPreAnswers(), "Answer", 1, i);
                answers.add(this.newAnswer(asId, info));
            }
        }
        return answers;
    }

    private List<Comment> findComments(InjectInfo info) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        if (info.getComments() > 0) {
            String cmId = "";
            for (int i = 0; i < info.getComments(); ++i) {
                cmId = this.makeId(info.getPreComments(), "Answer", 1, i);
                comments.add(this.newComment(cmId, info));
            }
        }
        return comments;
    }

    private String getTabs(int currentDepth) {
        String s = "";
        for (int i = 0; i < currentDepth; ++i) {
            s = s + "    ";
        }
        return s;
    }

    private void initDataForOneCategory(String parentId, Category cat, int currentDepth, int index, int size, InjectInfo info) throws Exception {
        String catId = parentId + SLASH + cat.getId();
        boolean isExist = this.faqService.isExisting(catId);
        String stt = "Update";
        String s = this.getTabs(currentDepth);
        List<Question> questions = this.findQuestion(catId, currentDepth, info);
        int index_ = 0;
        int size_ = questions.size();
        int as = 0;
        int cm = 0;
        if (!isExist) {
            stt = "Add new";
            this.faqService.saveCategory(parentId, cat, true);
            this.infoIject[0] = this.infoIject[0] + 1;
        }
        log.info((Object)String.format(" %s %s Category %s/%s with %s questions...", s, stt, index, size, size_));
        for (Question question : questions) {
            long t1 = System.currentTimeMillis();
            String questionId = catId + SLASH + Utils.QUESTION_HOME + SLASH + question.getId();
            isExist = this.faqService.isExisting(questionId);
            stt = "Update";
            if (!isExist) {
                this.faqService.saveQuestion(question, true, this.faqSetting);
                this.infoIject[1] = this.infoIject[1] + 1;
                stt = "Add new";
            } else {
                try {
                    if (info.getMaxAtt() > this.faqService.getQuestionById(questionId).getAttachMent().size()) {
                        question.setPath(questionId);
                        this.faqService.saveQuestion(question, false, this.faqSetting);
                    }
                }
                catch (Exception e) {
                    log.info((Object)"Failed to get attachments.");
                }
            }
            List<Answer> answers = this.findAnswers(info);
            for (Answer answer : answers) {
                isExist = this.faqService.isExisting(questionId + SLASH + Utils.ANSWER_HOME + SLASH + answer.getId());
                if (isExist) continue;
                this.faqService.saveAnswer(questionId, answer, true);
                this.infoIject[2] = this.infoIject[2] + 1;
                ++as;
            }
            List<Comment> comments = this.findComments(info);
            for (Comment comment : comments) {
                isExist = this.faqService.isExisting(questionId + SLASH + Utils.COMMENT_HOME + SLASH + comment.getId());
                if (isExist) continue;
                this.faqService.saveComment(questionId, comment, true);
                this.infoIject[3] = this.infoIject[3] + 1;
                ++cm;
            }
            log.info((Object)String.format(" %s %s Question %s/%s  with %s new answer(s) and %s new comment(s) in %sms", s, stt, ++index_, size_, as, cm, System.currentTimeMillis() - t1));
        }
    }

    private void createCategory(String parentId, Category me, int currentDepth, int index, int size, InjectInfo info) throws Exception {
        this.initDataForOneCategory(parentId, me, currentDepth, index, size, info);
        List<Category> cats = this.findCategories(currentDepth + 1, info);
        int index_ = 1;
        int size_ = cats.size();
        for (Category cat : cats) {
            if (currentDepth + 1 >= info.getDepth()) continue;
            this.createCategory(parentId + SLASH + me.getId(), cat, currentDepth + 1, index_, size_, info);
            ++index_;
        }
    }

    private void injectData(InjectInfo info) throws Exception {
        String parentId = "categories";
        this.infoIject = new int[]{0, 0, 0, 0};
        log.info((Object)"Start inject data for answer ....");
        long time = System.currentTimeMillis();
        List<Category> cats = this.findCategories(0, info);
        int size = cats.size();
        int index = 1;
        for (Category cat : cats) {
            this.categoryIds.add(parentId + SLASH + cat.getId());
            this.createCategory(parentId, cat, 0, index, size, info);
            ++index;
        }
        time = System.currentTimeMillis() - time;
        log.info((Object)String.format("INJECTED : new categories=%s / new questions=%s / new answers=%s / new comments=%s / time=%sms", this.infoIject[0], this.infoIject[1], this.infoIject[2], this.infoIject[3], time));
        this.saveHistoryInject();
    }

    public void inject(HashMap<String, String> queryParams) throws Exception {
        InjectInfo info = new InjectInfo(queryParams, this.getCategoryRoot(true));
        String type = info.getType();
        if (CONSTANTS.DATA.getName().equalsIgnoreCase(type) || CONSTANTS.PERM.toString().equalsIgnoreCase(type)) {
            log.info((Object)String.format("Injecting by type: %s ...", type));
            this.injectData(info);
        } else {
            log.info((Object)String.format("Do not support type %s for injector...", type));
        }
    }

    private void removeData() throws Exception {
        try {
            if (this.categoryIds.isEmpty()) {
                this.categoryIds.addAll(this.getHistoryInject());
            }
            for (String categoryId : this.categoryIds) {
                this.faqService.removeCategory(categoryId);
            }
            log.info((Object)"Completely remove the datas inject !");
            this.categoryIds.clear();
            Category category = this.getCategoryRoot(false);
            category.setDescription("");
            category.setModerators(new String[]{"root"});
            this.faqService.saveCategory(null, category, false);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to remove data injected....");
        }
    }

    public void reject(HashMap<String, String> queryParams) throws Exception {
        log.info((Object)"Start remove data injected....");
        this.removeData();
    }

    private List<String> getHistoryInject() {
        try {
            return AnswerDataInjector.convertStringToList(this.getCategoryRoot(true).getDescription());
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    private void saveHistoryInject() {
        try {
            String s = this.getCategoryRoot(true).getDescription();
            if (s != null && s.trim().length() > 0) {
                this.categoryIds.addAll(AnswerDataInjector.convertStringToList(s));
            }
            Category category = this.getCategoryRoot(false);
            category.setDescription(this.categoryIds.toString());
            this.faqService.saveCategory(null, category, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> convertStringToList(String s) {
        s = s.replace("[", "").replace("]", "");
        s = s.trim().replaceAll("(,\\s*)", ARRAY_SPLIT).replaceAll("(\\s*,)", ARRAY_SPLIT);
        String[] strs = s.split(ARRAY_SPLIT);
        return new ArrayList<String>(Arrays.asList(strs));
    }

    private Category newCategory(String catId, String catName, int order, InjectInfo info) {
        Category category = new Category();
        category.setId(catId);
        category.setName(catName);
        category.setDescription(this.randomWords(20));
        category.setIndex((long)order);
        category.setModerators(info.getPerCanEdit());
        category.setUserPrivate(info.getPerCanView());
        return category;
    }

    private Question newQuestion(String catId, String id, String name, InjectInfo info) {
        Question question = new Question();
        question.setId(id);
        question.setQuestion(name);
        question.setAuthor(this.randomUser());
        question.setCategoryId(catId);
        question.setDetail(this.getStringResource(info));
        question.setEmail("noreply@exoplatform.com");
        question.setLanguage("English");
        question.setLink("");
        question.setTopicIdDiscuss("");
        question.setMarkVote(0.0);
        question.setRelations(new String[]{""});
        question.setUsersWatch(new String[]{""});
        question.setEmailsWatch(new String[]{""});
        question.setCreatedDate(new Date());
        if (info.getMaxAtt() > 0) {
            try {
                question.setAttachMent(this.getFileAttachment(info));
            }
            catch (Exception e) {
                log.warn((Object)"Failed to set attachment in question.");
            }
        }
        return question;
    }

    private Answer newAnswer(String id, InjectInfo info) {
        String other = this.randomUser();
        Answer answer = new Answer(other, true);
        answer.setId(id);
        answer.setFullName(this.getFullName(other));
        answer.setLanguage("English");
        answer.setMarksVoteAnswer(0.0);
        answer.setMarkVotes(0L);
        answer.setResponses(this.getStringResource(info));
        answer.setNew(true);
        return answer;
    }

    private Comment newComment(String id, InjectInfo info) {
        String other = this.randomUser();
        Comment comment = new Comment();
        comment.setId(id);
        comment.setCommentBy(other);
        comment.setComments(this.getStringResource(info));
        comment.setFullName(this.getFullName(other));
        comment.setPostId("");
        comment.setNew(true);
        return comment;
    }

    private String getFullName(String userName) {
        try {
            return this.fullNameData.get(userName);
        }
        catch (Exception e) {
            return "No Name";
        }
    }

    public Object execute(HashMap<String, String> arg0) throws Exception {
        return new Object();
    }

    private String getStringResource(InjectInfo info) {
        if (info.getTxtCp() > 0) {
            return this.createTextResource(info.getTxtCp());
        }
        return this.randomParagraphs(3);
    }

    private List<FileAttachment> getFileAttachment(InjectInfo info) throws Exception {
        ArrayList<FileAttachment> listAttachments = new ArrayList<FileAttachment>();
        String rs = this.createTextResource(info.getAttCp());
        for (int i = 0; i < info.getMaxAtt(); ++i) {
            ByteArrayInputStream stream = new ByteArrayInputStream(rs.getBytes("UTF-8"));
            FileAttachment fileAttachment = new FileAttachment();
            fileAttachment.setInputStream((InputStream)stream);
            fileAttachment.setMimeType("text/plain");
            fileAttachment.setName("Attch_" + (i + 1) + ".txt");
            fileAttachment.setNodeName("Attch" + (i + 1) + ".txt");
            listAttachments.add(fileAttachment);
            ((InputStream)stream).close();
        }
        return listAttachments;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CONSTANTS {
        TYPE("type"),
        DATA("data"),
        PERM("perm"),
        Q("q"),
        PRE("pre"),
        ANY("any"),
        EDIT("edit"),
        VIEW("view"),
        ATT("att"),
        ATTCP("attCp"),
        TXTCP("txtCp");

        private final String name;

        private CONSTANTS(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

