/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.bench;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.chromattic.ext.ntdef.Resource;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.WikiService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiDataInjector
extends DataInjector {
    public static final String ARRAY_SPLIT = ",";
    private static Log log = ExoLogger.getLogger(WikiDataInjector.class);
    private WikiService wikiService;

    public WikiDataInjector(WikiService wikiService, InitParams params) {
        this.wikiService = wikiService;
    }

    private List<Integer> readQuantities(HashMap<String, String> queryParams) {
        String quantitiesString = queryParams.get("q");
        LinkedList<Integer> quantities = new LinkedList<Integer>();
        for (String s : quantitiesString.split(ARRAY_SPLIT)) {
            if (s.length() <= 0) continue;
            int quantity = Integer.parseInt(s.trim());
            quantities.add(quantity);
        }
        return quantities;
    }

    private List<String> readPrefixes(HashMap<String, String> queryParams) {
        String prefixesString = queryParams.get("pre");
        LinkedList<String> prefixes = new LinkedList<String>();
        for (String s : prefixesString.split(ARRAY_SPLIT)) {
            if (s.length() <= 0) continue;
            prefixes.add(s);
        }
        return prefixes;
    }

    private String readWikiOwner(HashMap<String, String> queryParams) {
        return queryParams.get("wo");
    }

    private String readWikiType(HashMap<String, String> queryParams) {
        return queryParams.get("wt");
    }

    private int readMaxAttachmentIfExist(HashMap<String, String> queryParams) {
        String value = queryParams.get("maxAtt");
        if (value != null) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    private int readMaxPagesIfExist(HashMap<String, String> queryParams) {
        String value = queryParams.get("mP");
        if (value != null) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    private boolean readRecursive(HashMap<String, String> queryParams) {
        boolean recursive = false;
        String value = queryParams.get("rcs");
        if (value != null) {
            recursive = Boolean.parseBoolean(value);
        }
        return recursive;
    }

    private List<String> readPermission(HashMap<String, String> queryParams) {
        boolean flag;
        String permString = queryParams.get("perm");
        LinkedList<String> permissions = new LinkedList<String>();
        boolean bl = flag = Integer.parseInt(permString.substring(0, 1)) > 0;
        if (flag) {
            permissions.add("read");
        }
        boolean bl2 = flag = Integer.parseInt(permString.substring(1, 2)) > 0;
        if (flag) {
            permissions.add("add_node");
            permissions.add("set_property");
            permissions.add("remove");
        }
        return permissions;
    }

    private HashMap<String, String[]> readPermissions(HashMap<String, String> queryParams) {
        HashMap<String, String[]> permissions = new HashMap<String, String[]>();
        LinkedList identities = new LinkedList();
        String[] permsArr = this.readPermission(queryParams).toArray(new String[0]);
        identities.addAll(this.readGroupsIfExist(queryParams));
        identities.addAll(this.readUsersIfExist(queryParams));
        identities.addAll(this.readMembershipIfExist(queryParams));
        for (String identity : identities) {
            permissions.put(identity, permsArr);
        }
        return permissions;
    }

    private String makeTitle(String prefix, String fatherTitle, int order) {
        return prefix + " " + fatherTitle + " " + order;
    }

    private PageImpl createPage(PageImpl father, String title, String wikiOwner, String wikiType, int attSize) throws Exception {
        PageImpl page = (PageImpl)this.wikiService.createPage(wikiType, wikiOwner, title, father.getName());
        page.getContent().setText(this.randomParagraphs(10));
        if (attSize > 0) {
            page.createAttachment("att" + IdGenerator.generate() + ".txt", Resource.createPlainText((String)this.createTextResource(attSize)));
        }
        return page;
    }

    private void generatePages(List<Integer> quantities, List<String> prefixes, int depth, int attSize, int totalPages, String wikiOwner, String wikiType, PageImpl father) throws Exception {
        int numOfPages = quantities.get(depth);
        String prefix = prefixes.get(depth);
        for (int i = 0; i < numOfPages; ++i) {
            String title = this.makeTitle(prefix, father.getTitle(), i + 1);
            String pageId = TitleResolver.getId((String)title, (boolean)true);
            PageImpl page = this.wikiService.isExisting(wikiType, wikiOwner, pageId) ? (PageImpl)this.wikiService.getPageById(wikiType, wikiOwner, pageId) : this.createPage(father, title, wikiOwner, wikiType, attSize);
            if (page == null) {
                return;
            }
            log.info((Object)String.format("%1$" + (depth + 1) * 4 + "s Process page: %2$s in depth %3$s .......", " ", page.getTitle(), depth + 1));
            if (depth >= quantities.size() - 1) continue;
            this.generatePages(quantities, prefixes, depth + 1, attSize, totalPages, wikiOwner, wikiType, page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectData(HashMap<String, String> queryParams) throws Exception {
        log.info((Object)"Start to inject data ............... ");
        List<Integer> quantities = this.readQuantities(queryParams);
        List<String> prefixes = this.readPrefixes(queryParams);
        int attSize = this.readMaxAttachmentIfExist(queryParams);
        int totalPages = this.readMaxPagesIfExist(queryParams);
        String wikiOwner = this.readWikiOwner(queryParams);
        String wikiType = this.readWikiType(queryParams);
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            this.generatePages(quantities, prefixes, 0, attSize, totalPages, wikiOwner, wikiType, (PageImpl)this.wikiService.getPageById(wikiType, wikiOwner, null));
        }
        finally {
            RequestLifeCycle.end();
        }
        log.info((Object)"Injecting data has been done successfully!");
    }

    private void grantPermission(List<Integer> quantities, List<String> prefixes, int depth, PageImpl father, String wikiOwner, String wikiType, HashMap<String, String[]> permissions, boolean isRecursive) throws Exception {
        int numOfPages = quantities.get(depth);
        String prefix = prefixes.get(depth);
        for (int i = 0; i < numOfPages; ++i) {
            String title = this.makeTitle(prefix, father.getTitle(), i + 1);
            String pageId = TitleResolver.getId((String)title, (boolean)true);
            PageImpl page = (PageImpl)this.wikiService.getPageById(wikiType, wikiOwner, pageId);
            if (page != null && (isRecursive || depth == quantities.size() - 1)) {
                log.info((Object)String.format("Grant permissions %1$s for page: %2$s .........", this.permissionsToString(permissions), page.getTitle()));
                page.setPagePermission(permissions);
            }
            if (depth >= quantities.size() - 1) continue;
            this.grantPermission(quantities, prefixes, depth + 1, page, wikiOwner, wikiType, permissions, isRecursive);
        }
    }

    private String permissionsToString(HashMap<String, String[]> permission) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> itr = permission.keySet().iterator();
        sb.append("(");
        while (itr.hasNext()) {
            String key = itr.next();
            String[] value = permission.get(key);
            sb.append("[" + key + ":");
            for (String s : value) {
                sb.append(s).append(ARRAY_SPLIT);
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append("],");
        }
        if (sb.length() > 1) {
            sb.delete(sb.length() - 1, sb.length());
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantPermission(HashMap<String, String> queryParams) throws Exception {
        log.info((Object)"Start to grant permissions ............... ");
        List<Integer> quantities = this.readQuantities(queryParams);
        List<String> prefixes = this.readPrefixes(queryParams);
        String wikiOwner = this.readWikiOwner(queryParams);
        String wikiType = this.readWikiType(queryParams);
        HashMap<String, String[]> permissions = this.readPermissions(queryParams);
        boolean isRecursive = this.readRecursive(queryParams);
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            this.grantPermission(quantities, prefixes, 0, (PageImpl)this.wikiService.getPageById(wikiType, wikiOwner, null), wikiOwner, wikiType, permissions, isRecursive);
        }
        finally {
            RequestLifeCycle.end();
        }
        log.info((Object)"Permissions have been granted successfully!");
    }

    public void inject(HashMap<String, String> queryParams) throws Exception {
        String type = queryParams.get(CONSTANTS.TYPE.getName());
        if (CONSTANTS.DATA.getName().equalsIgnoreCase(type)) {
            this.injectData(queryParams);
        } else if (CONSTANTS.PERM.getName().equalsIgnoreCase(type)) {
            this.grantPermission(queryParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reject(HashMap<String, String> params) throws Exception {
        log.info((Object)"Start to reject data ............. ");
        String wikiOwner = this.readWikiOwner(params);
        String wikiType = this.readWikiType(params);
        List<Integer> quantities = this.readQuantities(params);
        List<String> prefixes = this.readPrefixes(params);
        int numOfPages = quantities.get(0);
        String prefix = prefixes.get(0);
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        PageImpl wikiHome = (PageImpl)this.wikiService.getPageById(wikiType, wikiOwner, null);
        try {
            for (int i = 0; i < numOfPages; ++i) {
                String title = this.makeTitle(prefix, wikiHome.getTitle(), i + 1);
                String pageId = TitleResolver.getId((String)title, (boolean)true);
                if (this.wikiService.getPageById(wikiType, wikiOwner, pageId) == null) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("    Delete page: %1$s and its children ...", title));
                }
                this.wikiService.deletePage(wikiType, wikiOwner, pageId);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
        log.info((Object)"Rejecting data has been done successfully!");
    }

    public Log getLog() {
        return log;
    }

    public Object execute(HashMap<String, String> params) throws Exception {
        return new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CONSTANTS {
        TYPE("type"),
        DATA("data"),
        PERM("perm");

        private final String name;

        private CONSTANTS(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

