/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.jira;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.codehaus.swizzle.jira.Issue;
import org.codehaus.swizzle.jira.IssueType;
import org.codehaus.swizzle.jira.JiraRss;
import org.codehaus.swizzle.jira.Priority;
import org.codehaus.swizzle.jira.Resolution;
import org.codehaus.swizzle.jira.Status;
import org.codehaus.swizzle.jira.User;
import org.exoplatform.wiki.rendering.macro.jira.JiraIssueMacroParameters;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.TableBlock;
import org.xwiki.rendering.block.TableCellBlock;
import org.xwiki.rendering.block.TableHeadCellBlock;
import org.xwiki.rendering.block.TableRowBlock;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraIssueService {
    private final JiraRss jira;

    public JiraIssueService(JiraRss jira) {
        this.jira = jira;
    }

    public List<Block> execute(JiraIssueMacroParameters params) {
        List issues = this.jira.getIssues();
        TableBlock tableBlock = new TableBlock(Collections.emptyList(), new LinkedHashMap());
        TableRowBlock headRowBlock = new TableRowBlock(Collections.emptyList(), new LinkedHashMap());
        tableBlock.addChild((Block)headRowBlock);
        for (String name : params.getColumnsInList()) {
            TableHeadCellBlock cellBlock = new TableHeadCellBlock(Collections.emptyList(), new LinkedHashMap());
            RawBlock rawBlock = new RawBlock(name, Syntax.XHTML_1_0);
            cellBlock.addChild((Block)rawBlock);
            headRowBlock.addChild((Block)cellBlock);
        }
        for (Issue issue : issues) {
            TableRowBlock rowBlock = new TableRowBlock(Collections.emptyList(), new LinkedHashMap());
            tableBlock.addChild((Block)rowBlock);
            String link = issue.getLink();
            for (String name : params.getColumnsInList()) {
                TableCellBlock cellBlock = new TableCellBlock(Collections.emptyList(), new LinkedHashMap());
                Column column = Column.valueOf(name.toUpperCase());
                StringBuilder writer = new StringBuilder();
                switch (column) {
                    case TYPE: {
                        this.renderType(writer, issue.getType(), link);
                        break;
                    }
                    case KEY: {
                        this.renderKey(writer, issue.getKey(), link);
                        break;
                    }
                    case SUMMARY: {
                        this.renderSummary(writer, issue.getSummary(), link);
                        break;
                    }
                    case PRIORITY: {
                        this.renderPriority(writer, issue.getPriority(), link);
                        break;
                    }
                    case STATUS: {
                        this.renderStatus(writer, issue.getStatus(), link);
                        break;
                    }
                    case RESOLUTION: {
                        this.renderResolution(writer, issue.getResolution(), link);
                        break;
                    }
                    case ASSIGNEE: {
                        this.renderAssignee(writer, issue.getAssignee(), link);
                        break;
                    }
                    case REPORTER: {
                        this.renderReporter(writer, issue.getReporter(), link);
                    }
                }
                cellBlock.addChild((Block)new RawBlock(writer.toString(), Syntax.XHTML_1_0));
                rowBlock.addChild((Block)cellBlock);
            }
        }
        return Collections.singletonList(tableBlock);
    }

    protected void renderReporter(StringBuilder writer, User reporter, String link) {
        writer.append("<a href=\"").append(link).append("\">");
        writer.append(reporter.getName());
        writer.append("</a>");
    }

    protected void renderAssignee(StringBuilder writer, User assignee, String link) {
        writer.append("<a href=\"").append(link).append("\">");
        writer.append(assignee.getName());
        writer.append("</a>");
    }

    protected void renderResolution(StringBuilder writer, Resolution resolution, String link) {
        writer.append("<a href=\"").append(link).append("\">");
        writer.append(resolution.getName());
        writer.append("</a>");
    }

    protected void renderStatus(StringBuilder writer, Status status, String link) {
        writer.append("<a href=\"").append(link).append("\">");
        String stat = status.getName();
        String icon = status.getIcon();
        this.renderImage(writer, stat, icon);
        writer.append("</a>");
    }

    protected void renderPriority(StringBuilder writer, Priority priority, String link) {
        writer.append("<a href=\"").append(link).append("\">");
        String prio = priority.getName();
        String icon = priority.getIcon();
        this.renderImage(writer, prio, icon);
        writer.append("</a>");
    }

    protected void renderType(StringBuilder writer, IssueType issueType, String link) {
        writer.append("<center>");
        writer.append("<a href=\"").append(link).append("\">");
        String type = issueType.getName();
        String icon = issueType.getIcon();
        this.renderImage(writer, type, icon);
        writer.append("</a>");
        writer.append("</center>");
    }

    protected void renderImage(StringBuilder writer, String altText, String iconUrl) {
        writer.append("<img src=\"").append(iconUrl).append("\" border=\"0\" alt=\"").append(altText).append("\" />");
    }

    protected void renderKey(StringBuilder writer, String key, String link) {
        writer.append("<a href=\"").append(link).append("\">");
        writer.append(key);
        writer.append("</a>");
    }

    protected void renderSummary(StringBuilder writer, String summary, String link) {
        writer.append("<a href=\"").append(link).append("\">");
        writer.append(summary);
        writer.append("</a>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Column {
        TYPE,
        KEY,
        SUMMARY,
        REPORTER,
        ASSIGNEE,
        RESOLUTION,
        STATUS,
        PRIORITY;

    }
}

