/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.jira;

import java.util.List;
import org.codehaus.swizzle.jira.JiraRss;
import org.exoplatform.wiki.rendering.macro.jira.JiraIssueMacroParameters;
import org.exoplatform.wiki.rendering.macro.jira.JiraIssueService;
import org.exoplatform.wiki.rendering.macro.jira.SwizzleJiraPlugin;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="jiraissues")
public class JiraIssueMacro
extends AbstractMacro<JiraIssueMacroParameters> {
    private static final String DESCRIPTION = "Use to display JIRA XML data";
    public static final String MACRO_CATEGORY_OTHER = "Other";

    public JiraIssueMacro() {
        super("Jira issue", DESCRIPTION, JiraIssueMacroParameters.class);
        this.setDefaultCategory(MACRO_CATEGORY_OTHER);
    }

    public List<Block> execute(JiraIssueMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        SwizzleJiraPlugin plugin = new SwizzleJiraPlugin();
        JiraRss jira = null;
        String url = parameters.getUrl();
        try {
            jira = plugin.getJiraRss(url);
        }
        catch (Exception e) {
            throw new MacroExecutionException("URL is not valid!");
        }
        JiraIssueService service = new JiraIssueService(jira);
        return service.execute(parameters);
    }

    public boolean supportsInlineMode() {
        return true;
    }
}

