/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.rendering.spi;

import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ks.common.conf.RequiredParamException;
import org.exoplatform.ks.rendering.api.Renderer;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Managed
public class RendererPlugin
extends BaseComponentPlugin {
    private Class<? extends Renderer> rendererType;
    private static Log log = ExoLogger.getLogger(RendererPlugin.class);
    private Renderer renderer;

    public RendererPlugin(InitParams params) {
        try {
            this.renderer = (Renderer)params.getObjectParam("renderer").getObject();
        }
        catch (Exception e) {
            throw new RequiredParamException(params, RendererPlugin.class, "renderer", Renderer.class);
        }
    }

    @Managed
    @ManagedName(value="Name")
    @ManagedDescription(value="The plugin name")
    public String getName() {
        return super.getName();
    }

    @Managed
    @ManagedName(value="Description")
    @ManagedDescription(value="The plugin description")
    public String getDescription() {
        return super.getDescription();
    }

    @Managed
    @ManagedName(value="ClassName")
    @ManagedDescription(value="The renderer class")
    public String getClassName() {
        return this.rendererType.getName();
    }

    @Managed
    @ManagedName(value="Syntax")
    @ManagedDescription(value="The syntax managed by this renderer")
    public String getSyntax() {
        return this.renderer.getSyntax();
    }

    public Renderer getRenderer() {
        return this.renderer;
    }
}

