/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.rendering.converter.BlockConverter;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.context.Execution;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.SectionBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.converter.ConversionException;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.TransformationManager;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingServiceImpl
implements RenderingService,
Startable {
    private String cssURL;
    private Log LOG = ExoLogger.getExoLogger(RenderingServiceImpl.class);
    private EmbeddableComponentManager componentManager = null;

    @Override
    public Execution getExecution() throws ComponentLookupException, ComponentRepositoryException {
        return (Execution)this.componentManager.lookup(Execution.class);
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public <T> T getComponent(Class<T> clazz) {
        return this.getComponent(clazz, "default");
    }

    @Override
    public String render(String markup, String sourceSyntax, String targetSyntax, boolean supportSectionEdit) throws Exception {
        XDOM xdom = this.parse(markup, sourceSyntax);
        Syntax sSyntax = sourceSyntax == null ? Syntax.XWIKI_2_0 : this.getSyntax(sourceSyntax);
        Syntax tSyntax = targetSyntax == null ? Syntax.XHTML_1_0 : this.getSyntax(targetSyntax);
        try {
            BlockConverter refiner = (BlockConverter)this.componentManager.lookup(BlockConverter.class, sSyntax.toIdString());
            refiner.convert(xdom);
        }
        catch (ComponentLookupException e) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)String.format("Syntax %s doesn't have any refiner", sSyntax));
            }
        }
        catch (ConversionException e) {
            throw new ConversionException("Failed to refine input source", (Throwable)e);
        }
        WikiPrinter printer = this.convert(xdom, sSyntax, tSyntax, supportSectionEdit);
        return printer.toString();
    }

    @Override
    public String getContentOfSection(String markup, String sourceSyntax, String sectionIndex) throws Exception {
        XDOM xdom = this.parse(markup, sourceSyntax);
        Syntax sSyntax = sourceSyntax == null ? Syntax.XWIKI_2_0 : this.getSyntax(sourceSyntax);
        List<HeaderBlock> headers = this.getFilteredHeaders(xdom);
        int index = Integer.parseInt(sectionIndex);
        String content = null;
        if (headers.size() >= index) {
            SectionBlock section = headers.get(index - 1).getSection();
            content = this.renderXDOM((Block)new XDOM(Collections.singletonList(section)), sSyntax);
        }
        return content;
    }

    @Override
    public String updateContentOfSection(String markup, String sourceSyntax, String sectionIndex, String newSectionContent) throws Exception {
        XDOM xdom = this.parse(markup, sourceSyntax);
        Syntax sSyntax = sourceSyntax == null ? Syntax.XWIKI_2_0 : this.getSyntax(sourceSyntax);
        List<HeaderBlock> headers = this.getFilteredHeaders(xdom);
        int index = Integer.parseInt(sectionIndex);
        String content = null;
        if (headers.size() >= index) {
            HeaderBlock header = headers.get(index - 1);
            List blocks = this.parse(newSectionContent, sourceSyntax).getChildren();
            int sectionLevel = header.getLevel().getAsInt();
            for (int level = 1; level < sectionLevel && blocks.size() == 1 && blocks.get(0) instanceof SectionBlock; ++level) {
                blocks = ((Block)blocks.get(0)).getChildren();
            }
            SectionBlock section = header.getSection();
            section.getParent().replaceChild(blocks, (Block)section);
            content = this.renderXDOM((Block)xdom, sSyntax);
        }
        return content;
    }

    private String clean(String dirtyHTML) {
        HTMLCleaner cleaner = this.getComponent(HTMLCleaner.class);
        HTMLCleanerConfiguration config = cleaner.getDefaultConfiguration();
        Document document = cleaner.clean((Reader)new StringReader(dirtyHTML), config);
        return HTMLUtils.toString((Document)document);
    }

    public void start() {
        this.componentManager = new EmbeddableComponentManager();
        this.componentManager.initialize(this.getClass().getClassLoader());
    }

    public void stop() {
    }

    private <T> T getComponent(Class<T> clazz, String hint) {
        Object component = null;
        if (this.componentManager != null) {
            try {
                component = this.componentManager.lookup(clazz, hint);
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException("Failed to load component [" + clazz.getName() + "] for hint [" + hint + "]", e);
            }
        } else {
            throw new RuntimeException("Component manager has not been initialized before lookup for [" + clazz.getName() + "] for hint [" + hint + "]");
        }
        return (T)component;
    }

    private void outputTree(Block parent, int level) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i++ < level) {
            buf.append("  ");
        }
        buf.append(parent.getClass().getSimpleName());
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)buf.toString());
        }
        List children = parent.getChildren();
        for (Block block : children) {
            this.outputTree(block, level + 1);
        }
    }

    private WikiPrinter convert(XDOM xdom, Syntax sourceSyntax, Syntax targetSyntax, boolean supportSectionEdit) throws Exception {
        BlockRenderer renderer;
        try {
            TransformationManager transformationManager = (TransformationManager)this.componentManager.lookup(TransformationManager.class);
            transformationManager.performTransformations(xdom, sourceSyntax);
        }
        catch (TransformationException e) {
            throw new ConversionException("Failed to execute some transformations", (Throwable)e);
        }
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        try {
            renderer = (BlockRenderer)this.componentManager.lookup(BlockRenderer.class, targetSyntax.toIdString());
        }
        catch (ComponentLookupException e) {
            throw new ConversionException("Failed to locate Renderer for syntax [" + targetSyntax + "]", (Throwable)e);
        }
        if (supportSectionEdit) {
            List<HeaderBlock> filteredHeaders = this.getFilteredHeaders(xdom);
            int sectionIndex = 1;
            for (HeaderBlock block : filteredHeaders) {
                SectionBlock section = block.getSection();
                Block parentBlock = section.getParent();
                ResourceReference link = new ResourceReference("section=" + sectionIndex, ResourceType.URL);
                ++sectionIndex;
                List emtyList = Collections.emptyList();
                LinkedHashMap<String, String> linkParameters = new LinkedHashMap<String, String>();
                linkParameters.put("title", "Edit section: " + this.renderXDOM((Block)new XDOM(block.getChildren()), sourceSyntax));
                LinkBlock linkBlock = new LinkBlock(emtyList, link, true, linkParameters);
                LinkedHashMap<String, String> spanParameters = new LinkedHashMap<String, String>();
                spanParameters.put("class", "EditSection");
                FormatBlock spanBlock = new FormatBlock(Collections.singletonList(linkBlock), Format.NONE, spanParameters);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("class", "header-container");
                GroupBlock headerContainer = new GroupBlock(params);
                headerContainer.addChild((Block)block);
                headerContainer.addChild((Block)spanBlock);
                section.replaceChild((Block)headerContainer, (Block)block);
                params.put("class", "section-container");
                GroupBlock sectionContainer = new GroupBlock(params);
                sectionContainer.addChild((Block)section);
                parentBlock.replaceChild((Block)sectionContainer, (Block)section);
            }
        }
        renderer.render((Block)xdom, (WikiPrinter)printer);
        return printer;
    }

    @Override
    public XDOM parse(String markup, String sourceSyntax) throws Exception {
        XDOM xdom;
        Syntax sSyntax;
        Syntax syntax = sSyntax = sourceSyntax == null ? Syntax.XWIKI_2_0 : this.getSyntax(sourceSyntax);
        if (sSyntax == Syntax.XHTML_1_0 || sSyntax == Syntax.ANNOTATED_XHTML_1_0) {
            markup = this.clean(markup);
        }
        try {
            Parser parser = (Parser)this.componentManager.lookup(Parser.class, sSyntax.toIdString());
            xdom = parser.parse((Reader)new StringReader(markup));
        }
        catch (ComponentLookupException e) {
            throw new ConversionException("Failed to locate Parser for syntax [" + sSyntax + "]", (Throwable)e);
        }
        catch (ParseException e) {
            throw new ConversionException("Failed to parse input source", (Throwable)e);
        }
        if (this.LOG.isDebugEnabled()) {
            this.outputTree((Block)xdom, 0);
        }
        return xdom;
    }

    private String renderXDOM(Block content, Syntax targetSyntax) throws Exception {
        try {
            BlockRenderer renderer = (BlockRenderer)this.componentManager.lookup(BlockRenderer.class, targetSyntax.toIdString());
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            renderer.render(content, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (Exception e) {
            throw new ConversionException("Failed to render document to syntax [" + targetSyntax + "]", (Throwable)e);
        }
    }

    private List<HeaderBlock> getFilteredHeaders(XDOM xdom) {
        ArrayList<HeaderBlock> filteredHeaders = new ArrayList<HeaderBlock>();
        List headers = xdom.getChildrenByType(HeaderBlock.class, true);
        int sectionDepth = 3;
        for (HeaderBlock header : headers) {
            if (header.getLevel().getAsInt() > sectionDepth) continue;
            filteredHeaders.add(header);
        }
        return filteredHeaders;
    }

    private Syntax getSyntax(String syntaxId) {
        Syntax syntax = Syntax.XWIKI_2_0;
        if (Syntax.XWIKI_2_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.XWIKI_2_0;
        } else if (Syntax.CREOLE_1_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.CREOLE_1_0;
        } else if (Syntax.CONFLUENCE_1_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.CONFLUENCE_1_0;
        } else if (Syntax.XHTML_1_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.XHTML_1_0;
        } else if (Syntax.ANNOTATED_XHTML_1_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.ANNOTATED_XHTML_1_0;
        } else if (Syntax.MEDIAWIKI_1_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.MEDIAWIKI_1_0;
        } else if (Syntax.XWIKI_1_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.XWIKI_1_0;
        } else if (Syntax.JSPWIKI_1_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.JSPWIKI_1_0;
        } else if (Syntax.TWIKI_1_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.TWIKI_1_0;
        } else if (Syntax.HTML_4_01.toIdString().equals(syntaxId)) {
            syntax = Syntax.HTML_4_01;
        } else if (Syntax.PLAIN_1_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.PLAIN_1_0;
        } else if (Syntax.TEX_1_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.TEX_1_0;
        } else if (Syntax.EVENT_1_0.toIdString().equals(syntaxId)) {
            syntax = Syntax.EVENT_1_0;
        }
        return syntax;
    }

    @Override
    public String getCssURL() {
        return this.cssURL;
    }

    @Override
    public void setCssURL(String cssURL) {
        this.cssURL = cssURL;
    }
}

