/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.internal.parser.confluence;

import org.apache.commons.lang.StringUtils;
import org.xwiki.rendering.listener.reference.AttachmentResourceReference;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

public class ConfluenceLink {
    private String rawReference;
    private String destinationReference;
    private String anchor;
    private String shortcutName;
    private String shortcutValue;
    private String attachmentName;
    private String uriPrefix;

    public String getRawReference() {
        return this.rawReference;
    }

    public void setRawReference(String rawReference) {
        this.rawReference = rawReference;
    }

    public String getDestinationReference() {
        return this.destinationReference;
    }

    public void setDestinationReference(String destinationReference) {
        this.destinationReference = destinationReference;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public String getShortcutName() {
        return this.shortcutName;
    }

    public void setShortcutName(String shortcutName) {
        this.shortcutName = shortcutName;
    }

    public String getShortcutValue() {
        return this.shortcutValue;
    }

    public void setShortcutValue(String shortcutValue) {
        this.shortcutValue = shortcutValue;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public String getUriPrefix() {
        return this.uriPrefix;
    }

    public void setUriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }

    public ResourceReference toResourceReference() {
        if (!StringUtils.isEmpty((String)this.attachmentName)) {
            return new AttachmentResourceReference(this.attachmentName);
        }
        if (!StringUtils.isEmpty((String)this.uriPrefix)) {
            if (this.uriPrefix.equals(ResourceType.MAILTO.toString())) {
                return new ResourceReference(this.rawReference, ResourceType.MAILTO);
            }
            return new ResourceReference(this.rawReference, ResourceType.URL);
        }
        if (!StringUtils.isEmpty((String)this.destinationReference)) {
            DocumentResourceReference documentReference = new DocumentResourceReference(this.destinationReference);
            if (!StringUtils.isEmpty((String)this.anchor)) {
                documentReference.setAnchor(this.anchor);
            }
            return documentReference;
        }
        return new ResourceReference(this.rawReference, ResourceType.UNKNOWN);
    }
}

