/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.floatmacro;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.wiki.rendering.macro.MacroUtils;
import org.exoplatform.wiki.rendering.macro.floatmacro.FloatMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="float")
public class FloatMacro
extends AbstractMacro<FloatMacroParameters> {
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String DESCRIPTION = "Allow content to 'float' to the left or right";
    private static final String CONTENT_DESCRIPTION = "The content to float";
    @Inject
    private ComponentManager componentManager;

    public FloatMacro() {
        super("Float", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), FloatMacroParameters.class);
        this.setDefaultCategory("Formatting");
    }

    public List<Block> execute(FloatMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (content != null) {
            String cssClass = parameters.getCssClass();
            String side = parameters.getSide();
            String width = parameters.getWidth();
            String background = parameters.getBackground();
            String border = parameters.getBorder();
            String margin = parameters.getMargin();
            String padding = parameters.getPadding();
            if (StringUtils.isEmpty((String)side) || !side.equals(LEFT) && !side.equals(RIGHT)) {
                side = RIGHT;
            }
            if (StringUtils.isEmpty((String)margin)) {
                margin = "3px";
            }
            if (StringUtils.isEmpty((String)padding)) {
                padding = "3px";
            }
            String styles = "float: " + side + ";width:" + width + ";background:" + background + ";border:" + border + ";margin:" + margin + ";padding:" + padding + ";";
            HashMap<String, String> params = new HashMap<String, String>();
            if (!StringUtils.isEmpty((String)cssClass)) {
                params.put("class", cssClass);
            }
            params.put("style", styles);
            List<Block> contentBlocks = MacroUtils.parseSourceSyntax(this.getComponentManager(), content, context);
            GroupBlock floatBlock = new GroupBlock(contentBlocks, params);
            return Collections.singletonList(floatBlock);
        }
        return Collections.emptyList();
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }
}

