/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.render.confluence;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.wiki.rendering.render.confluence.ConfluenceSyntaxEscapeHandler;
import org.exoplatform.wiki.rendering.render.confluence.ConfluenceSyntaxListenerChain;
import org.xwiki.rendering.renderer.printer.LookaheadWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

public class ConfluenceSyntaxEscapeWikiPrinter
extends LookaheadWikiPrinter {
    private static final Pattern VERBATIM_PATTERN = Pattern.compile("(\\{\\{\\{)|(\\}\\}\\})");
    private ConfluenceSyntaxListenerChain listenerChain;
    private ConfluenceSyntaxEscapeHandler escapeHandler = new ConfluenceSyntaxEscapeHandler();
    private boolean escapeLastChar;
    private Pattern escapeFirstIfMatching;
    private String lastPrinted;

    public ConfluenceSyntaxEscapeWikiPrinter(WikiPrinter printer, ConfluenceSyntaxListenerChain listenerChain) {
        super(printer);
        this.listenerChain = listenerChain;
    }

    public ConfluenceSyntaxEscapeHandler getEscapeHandler() {
        return this.escapeHandler;
    }

    protected void printInternal(String text) {
        super.printInternal(text);
        int length = text.length();
        if (length > 0) {
            this.escapeHandler.setOnNewLine(text.charAt(length - 1) == '\n');
        }
        this.lastPrinted = text;
    }

    protected void printlnInternal(String text) {
        super.printlnInternal(text);
        this.escapeHandler.setOnNewLine(true);
        this.lastPrinted = "\n";
    }

    public void flush() {
        if (this.getBuffer().length() > 0) {
            this.escapeHandler.escape(this.getBuffer(), this.listenerChain, this.escapeLastChar, this.escapeFirstIfMatching);
            super.flush();
        }
        this.escapeLastChar = false;
        this.escapeFirstIfMatching = null;
    }

    public void printBeginBold() {
        this.flush();
        boolean isOnNewLine = this.escapeHandler.isOnNewLine();
        this.print("*");
        if (isOnNewLine) {
            this.escapeFirstIfMatching = ConfluenceSyntaxEscapeHandler.STARLISTEND_PATTERN;
        }
    }

    public void setEscapeLastChar(boolean escapeLastChar) {
        this.escapeLastChar = escapeLastChar;
    }

    public void setBeforeLink(boolean beforeLink) {
        this.escapeHandler.setBeforeLink(beforeLink);
    }

    public void setOnNewLine(boolean onNewLine) {
        this.escapeHandler.setOnNewLine(onNewLine);
    }

    public boolean isOnNewLine() {
        return this.escapeHandler.isOnNewLine();
    }

    public boolean isAfterWhiteSpace() {
        return this.isOnNewLine() || Character.isWhitespace(this.getLastPrinted().charAt(this.getLastPrinted().length() - 1));
    }

    public String getLastPrinted() {
        return this.lastPrinted;
    }

    public void printBeginItalic() {
        if (this.getBuffer().length() > 0 && this.getBuffer().charAt(this.getBuffer().length() - 1) == ':') {
            this.escapeLastChar = true;
        }
        this.print("_");
    }

    public void printEndItalic() {
        if (this.getBuffer().length() > 0 && this.getBuffer().charAt(this.getBuffer().length() - 1) == ':') {
            this.escapeLastChar = true;
        }
        this.print("_");
    }

    public void printInlineMacro(String confluenceSyntaxText) {
        if (this.getBuffer().length() > 0 && this.getBuffer().charAt(this.getBuffer().length() - 1) == '{') {
            this.escapeLastChar = true;
        }
        this.print(confluenceSyntaxText);
    }

    public void printVerbatimContent(String verbatimContent) {
        StringBuffer subVerbatim;
        StringBuffer result = new StringBuffer();
        Stack<StringBuffer> subVerbatimStack = new Stack<StringBuffer>();
        boolean printEndVerbatim = false;
        Matcher matcher = VERBATIM_PATTERN.matcher(verbatimContent);
        int currentIndex = 0;
        while (matcher.find()) {
            String before = verbatimContent.substring(currentIndex, matcher.start());
            if (printEndVerbatim) {
                if (before.startsWith("}")) {
                    result.append("~}~}~}");
                } else {
                    result.append("~}}}");
                }
            }
            if (subVerbatimStack.size() == 0) {
                result.append(before);
            } else {
                ((StringBuffer)subVerbatimStack.peek()).append(before);
            }
            if (matcher.group(1) != null) {
                subVerbatimStack.push(new StringBuffer());
            } else if (subVerbatimStack.size() == 0) {
                printEndVerbatim = true;
            } else {
                subVerbatim = (StringBuffer)subVerbatimStack.pop();
                if (subVerbatimStack.size() == 0) {
                    result.append("{{{");
                    result.append(subVerbatim);
                    result.append("}}}");
                } else {
                    ((StringBuffer)subVerbatimStack.peek()).append("{{{");
                    ((StringBuffer)subVerbatimStack.peek()).append(subVerbatim);
                    ((StringBuffer)subVerbatimStack.peek()).append("}}}");
                }
            }
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            this.print(verbatimContent);
            return;
        }
        String end = verbatimContent.substring(currentIndex);
        if (printEndVerbatim) {
            if (end.length() == 0 || end.charAt(0) == '}') {
                result.append("~}~}~}");
            } else {
                result.append("~}}}");
            }
        }
        if (subVerbatimStack.size() > 0) {
            ((StringBuffer)subVerbatimStack.peek()).append(end);
            while (subVerbatimStack.size() > 0) {
                subVerbatim = (StringBuffer)subVerbatimStack.pop();
                if (subVerbatimStack.size() == 0) {
                    if (subVerbatim.length() > 0 && subVerbatim.charAt(0) == '{') {
                        result.append("~{~{~{");
                    } else {
                        result.append("~{{{");
                    }
                    result.append(subVerbatim);
                    continue;
                }
                if (subVerbatim.length() > 0 && subVerbatim.charAt(0) == '{') {
                    ((StringBuffer)subVerbatimStack.peek()).append("~{~{~{");
                } else {
                    ((StringBuffer)subVerbatimStack.peek()).append("~{{{");
                }
                ((StringBuffer)subVerbatimStack.peek()).append(subVerbatim);
            }
        } else {
            result.append(end);
        }
        this.print(result.toString());
    }
}

