/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.transformation.icon;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.SpecialSymbolBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.block.ProtectedBlockFilter;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.AbstractTransformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.icon.IconTransformationConfiguration;
import org.xwiki.rendering.util.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="icon")
public class DefaultIconTransformation
extends AbstractTransformation
implements Initializable {
    @Inject
    private IconTransformationConfiguration configuration;
    @Inject
    private ComponentManager componentManager;
    private ParserUtils parserUtils = new ParserUtils();
    @Inject
    private Logger logger;
    private Map<String, XDOM> mappingDOMs = new HashMap<String, XDOM>();
    private ProtectedBlockFilter filter = new ProtectedBlockFilter();

    public void initialize() throws InitializationException {
    }

    public void transform(Block source, TransformationContext context) throws TransformationException {
        try {
            XDOM mappingTree = this.mappingDOMs.get(context.getSyntax().toIdString());
            if (mappingTree == null) {
                Parser syntaxParser = (Parser)this.componentManager.lookup(Parser.class, context.getSyntax().toIdString());
                mappingTree = new XDOM(Collections.emptyList());
                for (Map.Entry<Object, Object> entry : this.configuration.getMappings().entrySet()) {
                    try {
                        XDOM xdom = syntaxParser.parse((Reader)new StringReader((String)entry.getKey()));
                        this.parserUtils.removeTopLevelParagraph(xdom.getChildren());
                        this.mergeTree((Block)mappingTree, this.convertToDeepTree((Block)xdom, (String)entry.getValue()));
                        this.mappingDOMs.put(context.getSyntax().toIdString(), mappingTree);
                    }
                    catch (ParseException e) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Failed to parse icon symbols [" + entry.getKey() + "]. Reason = [" + e.getMessage() + "]");
                    }
                }
            }
            List filteredBlocks = this.filter.filter(source.getChildren());
            if (!mappingTree.getChildren().isEmpty() && !filteredBlocks.isEmpty()) {
                this.parseTree(mappingTree, filteredBlocks);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to transform icon symbols in syntax [" + context.getSyntax().toIdString() + "]. Reason = [" + e.getMessage() + "]");
        }
    }

    private Block convertToDeepTree(Block sourceTree, String iconName) {
        XDOM targetTree;
        XDOM pointer = targetTree = new XDOM(Collections.emptyList());
        for (Block block : sourceTree.getChildren()) {
            pointer.addChild(block);
            pointer = block;
        }
        pointer.addChild((Block)new ImageBlock(new ResourceReference(iconName, ResourceType.ICON), true));
        return targetTree;
    }

    private void mergeTree(Block targetTree, Block sourceTree) {
        for (Block block : sourceTree.getChildren()) {
            int pos = this.indexOf(targetTree.getChildren(), block);
            if (pos > -1) {
                Block foundBlock = (Block)targetTree.getChildren().get(pos);
                this.mergeTree(foundBlock, block);
                continue;
            }
            targetTree.addChild(block);
        }
    }

    private int indexOf(List<Block> targetBlocks, Block block) {
        int pos = 0;
        for (Block targetBlock : targetBlocks) {
            if (this.blockEquals(targetBlock, block)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    private boolean blockEquals(Block target, Block source) {
        boolean found = false;
        if (source instanceof SpecialSymbolBlock && target instanceof SpecialSymbolBlock) {
            if (((SpecialSymbolBlock)target).getSymbol() == ((SpecialSymbolBlock)source).getSymbol()) {
                found = true;
            }
        } else if (source instanceof WordBlock && target instanceof WordBlock) {
            if (((WordBlock)target).getWord().equals(((WordBlock)source).getWord())) {
                found = true;
            }
        } else if (source.equals(target)) {
            found = true;
        }
        return found;
    }

    private void parseTree(XDOM mappingTree, List<Block> sourceBlocks) {
        Block matchStartBlock = null;
        int count = 0;
        Block mappingCursor = (Block)mappingTree.getChildren().get(0);
        Block sourceBlock = sourceBlocks.get(0);
        while (sourceBlock != null) {
            List filteredSourceBlocks;
            while (mappingCursor != null) {
                if (this.blockEquals(sourceBlock, mappingCursor)) {
                    if (matchStartBlock == null) {
                        matchStartBlock = sourceBlock;
                    }
                    ++count;
                    if (!((mappingCursor = (Block)mappingCursor.getChildren().get(0)) instanceof ImageBlock)) break;
                    for (int i = 0; i < count - 1; ++i) {
                        matchStartBlock.getParent().removeBlock(matchStartBlock.getNextSibling());
                    }
                    sourceBlock = mappingCursor.clone();
                    matchStartBlock.getParent().replaceChild(sourceBlock, matchStartBlock);
                    mappingCursor = null;
                    matchStartBlock = null;
                    count = 0;
                    continue;
                }
                mappingCursor = mappingCursor.getNextSibling();
            }
            if ((filteredSourceBlocks = this.filter.filter(sourceBlock.getChildren())).size() > 0) {
                this.parseTree(mappingTree, filteredSourceBlocks);
            } else if (mappingCursor == null) {
                mappingCursor = (Block)mappingTree.getChildren().get(0);
                count = 0;
                matchStartBlock = null;
            }
            sourceBlock = this.filter.getNextSibling(sourceBlock);
        }
    }
}

