/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;

public class WikiGroupPermissionRepairPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(WikiGroupPermissionRepairPlugin.class);

    public WikiGroupPermissionRepairPlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"\n\nStart check and fix group permission of wiki pages...\n");
        try {
            this.fixGroupPermissionOfWikiPages();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception when fix  group permission of wiki pages:", (Throwable)e);
        }
        LOG.info((Object)"\n\nFinish check and fix group permission of wiki pages...\n");
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isBefore((String)previousVersion, (String)newVersion);
    }

    private void fixGroupPermissionOfWikiPages() {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        MOWService mowService = (MOWService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MOWService.class);
        ChromatticSession session = mowService.getSession();
        QueryResult pageIterator = session.createQueryBuilder(PageImpl.class).where("jcr:path LIKE '/%'").get().objects();
        LOG.info("\nTotal pages found: {}\n", new Object[]{pageIterator.size()});
        int checkedPage = 0;
        int fixedPage = 0;
        while (pageIterator.hasNext()) {
            PageImpl page = (PageImpl)pageIterator.next();
            try {
                HashMap permissions = page.getPermission();
                boolean isEditedPermission = false;
                Set permissionsKey = permissions.keySet();
                ArrayList permissionKeyList = new ArrayList(permissionsKey);
                for (String id : permissionKeyList) {
                    if (id.indexOf(47) <= -1 || id.indexOf(58) != -1) continue;
                    String newId = "*:" + id;
                    String[] value = (String[])permissions.get(id);
                    permissions.remove(id);
                    permissions.put(newId, value);
                    LOG.info("\nRepaired: {} to {}\n", new Object[]{id, newId});
                    isEditedPermission = true;
                }
                if (isEditedPermission) {
                    page.setPermission(permissions);
                    LOG.info("\nFixed pages: {}\n", new Object[]{++fixedPage});
                }
                LOG.info("\nChecked pages: {}/{}\n", new Object[]{++checkedPage, pageIterator.size()});
            }
            catch (Exception e) {
                LOG.warn((Object)String.format("Can not repair the permission for page %s", page.getName()), (Throwable)e);
            }
        }
        RequestLifeCycle.end();
    }
}

