/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.bbcode;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.bbcode.BBCode;
import org.exoplatform.ks.common.bbcode.BBCodeData;
import org.exoplatform.ks.common.bbcode.InitBBCodePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBCodeOperator {
    private static Log log = ExoLogger.getLogger(BBCodeOperator.class);
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private RepositoryService rService_;
    private List<InitBBCodePlugin> defaultBBCodePlugins_ = new ArrayList<InitBBCodePlugin>();

    public BBCodeOperator(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService rService) throws Exception {
        this.rService_ = rService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    private Node getForumDataHome(SessionProvider sProvider) throws Exception {
        Node tmpNode = this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider);
        Session session = sProvider.getSession(this.rService_.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.rService_.getCurrentRepository());
        Node appNode = (Node)session.getItem(tmpNode.getPath());
        try {
            return appNode.getNode(CommonUtils.FORUM_SERVICE + "/" + CommonUtils.FORUM_DATA);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get forum data home.", (Throwable)e);
            return null;
        }
    }

    public Node getBBcodeHome(SessionProvider sProvider) throws Exception {
        try {
            return this.getForumDataHome(sProvider).getNode(CommonUtils.BBCODE_HOME);
        }
        catch (PathNotFoundException e) {
            return this.getForumDataHome(sProvider).addNode(CommonUtils.BBCODE_HOME, CommonUtils.BBCODE_HOME_NODE_TYPE);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get BBcode home.", (Throwable)e);
            return null;
        }
    }

    public void addInitBBCodePlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof InitBBCodePlugin) {
            this.defaultBBCodePlugins_.add((InitBBCodePlugin)plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDefaultBBCode() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node bbCodeHome = this.getBBcodeHome(sProvider);
            NodeIterator iter = bbCodeHome.getNodes();
            if (iter.getSize() <= 0L) {
                ArrayList<BBCode> bbCodes = new ArrayList<BBCode>();
                for (InitBBCodePlugin pln : this.defaultBBCodePlugins_) {
                    List<BBCodeData> codeDatas = pln.getBBCodePlugin().getBbcodeDatas();
                    for (BBCodeData codeData : codeDatas) {
                        BBCode bbCode = new BBCode();
                        bbCode.setTagName(codeData.getTagName());
                        bbCode.setReplacement(codeData.getReplacement());
                        bbCode.setDescription(codeData.getDescription());
                        bbCode.setExample(codeData.getExample());
                        bbCode.setOption(Boolean.parseBoolean(codeData.getIsOption()));
                        bbCode.setActive(Boolean.parseBoolean(codeData.getIsActive()));
                        bbCodes.add(bbCode);
                    }
                }
                if (!bbCodes.isEmpty()) {
                    this.saveBBCode(bbCodes);
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to init default BBCode.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBBCode(List<BBCode> bbcodes) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node bbCodeHome = this.getBBcodeHome(sProvider);
            for (BBCode bbcode : bbcodes) {
                Node bbcNode;
                String id = bbcode.getTagName();
                if (bbcode.isOption()) {
                    id = id + "_option";
                }
                try {
                    bbcNode = bbCodeHome.getNode(bbcode.getId());
                    if (!id.equals(bbcode.getId())) {
                        bbcNode.remove();
                        bbcNode = bbCodeHome.addNode(id, CommonUtils.BBCODE_NODE_TYPE);
                    }
                }
                catch (Exception e) {
                    bbcNode = bbCodeHome.addNode(id, CommonUtils.BBCODE_NODE_TYPE);
                }
                bbcNode.setProperty("exo:tagName", bbcode.getTagName());
                bbcNode.setProperty("exo:replacement", bbcode.getReplacement());
                bbcNode.setProperty("exo:example", bbcode.getExample());
                bbcNode.setProperty("exo:description", bbcode.getDescription());
                bbcNode.setProperty("exo:isActive", bbcode.isActive());
                bbcNode.setProperty("exo:isOption", bbcode.isOption());
            }
            if (bbCodeHome.isNew()) {
                bbCodeHome.getSession().save();
            } else {
                bbCodeHome.save();
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to save BBCode ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private BBCode getBBCodeNode(Node bbcNode) throws Exception {
        BBCode bbCode = new BBCode();
        bbCode.setId(bbcNode.getName());
        bbCode.setTagName(bbcNode.getProperty("exo:tagName").getString());
        bbCode.setReplacement(bbcNode.getProperty("exo:replacement").getString());
        bbCode.setExample(bbcNode.getProperty("exo:example").getString());
        if (bbcNode.hasProperty("exo:description")) {
            bbCode.setDescription(bbcNode.getProperty("exo:description").getString());
        }
        bbCode.setActive(bbcNode.getProperty("exo:isActive").getBoolean());
        bbCode.setOption(bbcNode.getProperty("exo:isOption").getBoolean());
        return bbCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BBCode> getAllBBCode() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<BBCode> bbcodes = new ArrayList<BBCode>();
        try {
            Node bbCodeHome = this.getBBcodeHome(sProvider);
            NodeIterator iter = bbCodeHome.getNodes();
            while (iter.hasNext()) {
                try {
                    Node bbcNode = iter.nextNode();
                    bbcodes.add(this.getBBCodeNode(bbcNode));
                }
                catch (Exception e) {}
            }
        }
        finally {
            sProvider.close();
        }
        return bbcodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getActiveBBCode() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> bbcodes = new ArrayList<String>();
        try {
            Node bbCodeHome = this.getBBcodeHome(sProvider);
            if (bbCodeHome == null) {
                ArrayList<String> arrayList = bbcodes;
                return arrayList;
            }
            QueryManager qm = bbCodeHome.getSession().getWorkspace().getQueryManager();
            StringBuilder pathQuery = new StringBuilder();
            pathQuery.append("/jcr:root").append(bbCodeHome.getPath()).append("/element(*,").append(CommonUtils.BBCODE_NODE_TYPE).append(")[@exo:isActive='true']");
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            String tagName = "";
            while (iter.hasNext()) {
                Node bbcNode = iter.nextNode();
                tagName = bbcNode.getProperty("exo:tagName").getString();
                if (bbcNode.getProperty("exo:isOption").getBoolean()) {
                    tagName = tagName + "=";
                }
                bbcodes.add(tagName);
            }
        }
        finally {
            sProvider.close();
        }
        return bbcodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBCode getBBcode(String id) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        BBCode bbCode = new BBCode();
        Node bbCodeHome = this.getBBcodeHome(sProvider);
        try {
            Node bbcNode = bbCodeHome.getNode(id);
            bbCode.setId(bbcNode.getName());
            bbCode.setTagName(bbcNode.getProperty("exo:tagName").getString());
            bbCode.setReplacement(bbcNode.getProperty("exo:replacement").getString());
            bbCode.setOption(bbcNode.getProperty("exo:isOption").getBoolean());
        }
        finally {
            sProvider.close();
        }
        return bbCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBBCode(String bbcodeId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node bbCodeHome = this.getBBcodeHome(sProvider);
        try {
            bbCodeHome.getNode(bbcodeId).remove();
            bbCodeHome.save();
        }
        catch (Exception e) {
            log.debug((Object)("Failed to remove BBCode by id: " + bbcodeId), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }
}

