/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.bbcode;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ks.common.bbcode.BBCodeData;
import org.exoplatform.ks.common.bbcode.BBCodePlugin;
import org.exoplatform.ks.common.conf.ManagedPlugin;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="ks"), @Property(key="view", value="plugins"), @Property(key="name", value="{Name}")})
@ManagedDescription(value="Plugin that defines the initial BBCodes available")
public class InitBBCodePlugin
extends ManagedPlugin {
    private BBCodePlugin initialData = new BBCodePlugin();

    public InitBBCodePlugin(InitParams params) throws Exception {
        this.initialData = (BBCodePlugin)params.getObjectParam("bbcode.default.configuration").getObject();
    }

    public BBCodePlugin getBBCodePlugin() {
        return this.initialData;
    }

    @Managed
    @ManagedDescription(value="Get the list of BBCodes defined in this plugin")
    public List<String> getBBCodes() {
        ArrayList<String> result = new ArrayList<String>();
        List<BBCodeData> data = this.initialData.getBbcodeDatas();
        for (BBCodeData bbCodeData : data) {
            result.add(bbCodeData.getTagName());
        }
        return result;
    }
}

