/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.user;

import org.apache.commons.logging.Log;
import org.exoplatform.ks.common.CommonContact;
import org.exoplatform.ks.common.user.ContactProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;

public class DefaultContactProvider
implements ContactProvider {
    private static Log log = ExoLogger.getLogger(DefaultContactProvider.class);
    private OrganizationService orgService;

    public DefaultContactProvider(OrganizationService orgService) {
        this.orgService = orgService;
    }

    public CommonContact getCommonContact(String userId) {
        CommonContact contact = new CommonContact();
        try {
            User user = this.orgService.getUserHandler().findUserByName(userId);
            UserProfile profile = this.orgService.getUserProfileHandler().findUserProfileByName(userId);
            contact.setEmailAddress(user.getEmail());
            contact.setAvatarUrl(profile.getAttribute("user.other-info.avatar.url"));
            contact.setBirthday(profile.getAttribute("user.bdate"));
            contact.setCity(profile.getAttribute("user.home-info.postal.city"));
            contact.setCountry(profile.getAttribute("user.home-info.postal.country"));
            contact.setGender(profile.getAttribute("user.gender"));
            contact.setJob(profile.getAttribute("user.jobtitle"));
            contact.setMobile(profile.getAttribute("user.home-info.telecom.mobile.number"));
            contact.setPhone(profile.getAttribute("user.business-info.telecom.telephone.number"));
            contact.setWebSite(profile.getAttribute("user.home-info.online.uri"));
        }
        catch (Exception e) {
            log.warn((Object)("Could not retrieve forum user profile for " + userId + ": " + e.getMessage()));
        }
        return contact;
    }
}

