/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.rss;

import java.util.Arrays;
import java.util.List;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.rss.RSSProcess;

public class FAQRSSEventListener
implements EventListener {
    private String path_;
    private String workspace_;
    private String repository_;
    private List<String> listPropertyNotGetEvent = Arrays.asList("exo:rssWatching", "ks.rss", "exo:emailWatching", "exo:userWatching");
    private KSDataLocation locator;

    public FAQRSSEventListener(KSDataLocation dataLocator) throws Exception {
        this.workspace_ = dataLocator.getWorkspace();
        this.repository_ = dataLocator.getRepository();
        this.locator = dataLocator;
    }

    public String getSrcWorkspace() {
        return this.workspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public void onEvent(EventIterator evIter) {
        try {
            RSSProcess process = new RSSProcess(this.locator);
            String path = null;
            while (evIter.hasNext()) {
                int length;
                Event ev = evIter.nextEvent();
                path = ev.getPath();
                if (ev.getType() == 1) {
                    length = ev.getPath().indexOf("/Question") + 41;
                    if (length == ev.getPath().length()) {
                        process.generateRSS(ev.getPath(), 1);
                        continue;
                    }
                    if (ev.getPath().indexOf("/faqCommentHome") <= 0 && ev.getPath().indexOf("/faqAnswerHome") <= 0) continue;
                    process.generateRSS(ev.getPath(), 16);
                    continue;
                }
                if (ev.getType() == 16) {
                    process.generateRSS(path.substring(0, path.lastIndexOf("/")), 16);
                    continue;
                }
                if (ev.getType() != 2) continue;
                length = ev.getPath().indexOf("/Question") + 41;
                if (length == ev.getPath().length()) {
                    process.generateRSS(ev.getPath(), 2);
                    continue;
                }
                if (ev.getPath().indexOf("/faqCommentHome") <= 0 && ev.getPath().indexOf("/faqAnswerHome") <= 0) continue;
                process.generateRSS(ev.getPath().substring(0, ev.getPath().indexOf("/Question") + 41), 16);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

