/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.rss;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.ks.rss.RSSProcess;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class KSRSSServlet
extends AbstractHttpServlet {
    public void afterInit(ServletConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onService(ExoContainer container, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "private max-age=600, s-maxage=120");
        String pathInfo = request.getPathInfo();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            if (pathInfo != null && pathInfo.length() > 0) {
                pathInfo = pathInfo.substring(1);
                String appType = "";
                String objectId = "";
                if (pathInfo.indexOf("/") > 0) {
                    appType = pathInfo.substring(0, pathInfo.indexOf("/"));
                    objectId = pathInfo.substring(pathInfo.indexOf("/") + 1);
                } else {
                    objectId = pathInfo;
                }
                RSSProcess process = new RSSProcess(sessionProvider, appType);
                InputStream is = null;
                if (appType.equals("faq")) {
                    is = process.getRSSNode(sessionProvider, objectId, appType);
                } else if (appType.equals("forum")) {
                    is = process.getRSSNode(sessionProvider, objectId, appType);
                } else {
                    objectId = pathInfo.indexOf("/") > 0 ? pathInfo.substring(pathInfo.lastIndexOf("/") + 1) : pathInfo;
                    is = process.getRSSOfMultiObjects(objectId, sessionProvider);
                }
                if (is != null) {
                    response.setContentType("text/xml");
                    byte[] buf = new byte[is.available()];
                    is.read(buf);
                    ServletOutputStream os = response.getOutputStream();
                    os.write(buf);
                } else {
                    byte[] buf = "<br/><br/>This object is hidden or you haven't got permission to view!".getBytes();
                    ServletOutputStream os = response.getOutputStream();
                    os.write(buf);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sessionProvider.close();
        }
    }
}

