/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.webui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.ks.common.webui.AbstractPopupAction;
import org.exoplatform.ks.common.webui.UIPopupAction;
import org.exoplatform.ks.common.webui.UIPopupContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseUIForm
extends UIForm {
    protected Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public String i18n(String key) {
        ResourceBundle res = null;
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            res = context.getApplicationResourceBundle();
            return res.getString(key);
        }
        catch (MissingResourceException e) {
            this.log.warn((Object)("Could not find key for in " + res + " for locale " + res.getLocale()));
            return key;
        }
    }

    public String getLabel(String labelID) {
        ResourceBundle res = null;
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            res = context.getApplicationResourceBundle();
            return super.getLabel(res, labelID);
        }
        catch (Exception e) {
            this.log.warn((Object)("Could not find label for " + labelID + "in " + res + " for locale " + res.getLocale()));
            return labelID;
        }
    }

    protected void info(String messageKey) {
        this.info(messageKey, null);
    }

    protected void info(String messageKey, String ... args) {
        this.message(messageKey, args, 2);
    }

    protected void warning(String messageKey) {
        this.warning(messageKey, null);
    }

    protected void warning(String messageKey, String ... args) {
        this.message(messageKey, args, 1);
    }

    private void message(String messageKey, String[] args, int messageType) {
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        uiApp.addMessage(new ApplicationMessage(messageKey, (Object[])args, messageType));
        ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
    }

    protected void throwWarning(String message, String ... args) throws MessageException {
        throw new MessageException(new ApplicationMessage(message, (Object[])args, 1));
    }

    protected void throwWarning(String message) throws MessageException {
        throw new MessageException(new ApplicationMessage(message, new Object[0], 1));
    }

    protected <T extends UIComponent> T openPopup(UIContainer parent, Class<T> componentType, String popupId, int width, int height) throws Exception {
        AbstractPopupAction popupAction = (AbstractPopupAction)parent.getChild(AbstractPopupAction.class);
        UIPopupContainer popupContainer = popupAction.prepareForNewForm();
        UIComponent form = popupContainer.addChild(componentType, null, null);
        form.setRendered(true);
        popupAction.activate((UIComponent)popupContainer, width, height);
        if (popupId != null) {
            popupContainer.setId(popupId);
        } else {
            popupContainer.setId(this.generateComponentId(componentType));
        }
        if (parent instanceof UIPopupContainer) {
            ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax((UIComponent)parent);
        } else {
            ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax((UIComponent)popupAction);
        }
        return (T)form;
    }

    <T> String generateComponentId(Class<T> componentType) {
        String simpleName = componentType.getSimpleName();
        if (simpleName.startsWith("UI")) {
            simpleName = simpleName.substring(2);
        }
        return simpleName;
    }

    protected <T extends UIComponent> T openPopup(UIContainer parent, Class<T> componentType, int width, int height) throws Exception {
        return this.openPopup(parent, componentType, null, width, height);
    }

    protected void cancelChildPopupAction() throws Exception {
        UIPopupContainer popupContainer = (UIPopupContainer)this.getAncestorOfType(UIPopupContainer.class);
        UIPopupAction popupAction = popupContainer != null ? (this.getParent().getId().equals(popupContainer.getId()) ? (UIPopupAction)popupContainer.getAncestorOfType(UIPopupAction.class) : (UIPopupAction)popupContainer.getChild(UIPopupAction.class)) : (UIPopupAction)this.getAncestorOfType(UIPopupAction.class);
        popupAction.cancelPopupAction();
    }
}

