/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.CategoryLanguage;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.JcrInputProperty;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.value.DateValue;
import org.exoplatform.services.jcr.impl.core.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLanguages {
    public static final String EXO_LANGUAGE = "exo:language";
    public static final String COMMENTS = "comments".intern();
    public static final String JCRCONTENT = "jcr:content";
    public static final String JCRDATA = "jcr:data";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String NTUNSTRUCTURED = "nt:unstructured";
    static final String VOTER_PROP = "exo:voter".intern();
    static final String VOTING_RATE_PROP = "exo:votingRate".intern();
    static final String VOTE_TOTAL_PROP = "exo:voteTotal".intern();
    static final String VOTE_TOTAL_LANG_PROP = "exo:voteTotalOfLang".intern();
    static final String NODE = "/node/";
    static final String NODE_LANGUAGE = "/node/languages/";
    static final String CONTENT_PATH = "/node/jcr:content/";
    static final String TEMP_NODE = "temp";

    private void setPropertyValue(String propertyName, Node node, int requiredtype, Object value, boolean isMultiple) throws Exception {
        switch (requiredtype) {
            case 1: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (isMultiple) {
                    if (value instanceof String) {
                        node.setProperty(propertyName, new String[]{value.toString()});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                if (value instanceof StringValue) {
                    StringValue strValue = (StringValue)value;
                    node.setProperty(propertyName, strValue.getString());
                    break;
                }
                node.setProperty(propertyName, value.toString());
                break;
            }
            case 2: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (value instanceof byte[]) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream((byte[])value));
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(value.toString().getBytes()));
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(((String[])value).toString().getBytes()));
                break;
            }
            case 6: {
                if (value == null) {
                    node.setProperty(propertyName, false);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Boolean(value.toString()).booleanValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 3: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Long(value.toString()).longValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 4: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Double(value.toString()).doubleValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 5: {
                if (value == null) {
                    node.setProperty(propertyName, (Calendar)new GregorianCalendar());
                    break;
                }
                if (isMultiple) {
                    Session session = node.getSession();
                    if (value instanceof String) {
                        Value value2add = session.getValueFactory().createValue(ISO8601.parse((String)((String)value)));
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    String[] values = (String[])value;
                    Value[] convertedCalendarValues = new Value[values.length];
                    int i = 0;
                    for (String stringValue : values) {
                        Value value2add;
                        convertedCalendarValues[i] = value2add = session.getValueFactory().createValue(ISO8601.parse((String)stringValue));
                        ++i;
                    }
                    node.setProperty(propertyName, convertedCalendarValues);
                    session.logout();
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, ISO8601.parse((String)value.toString()));
                    break;
                }
                if (value instanceof GregorianCalendar) {
                    node.setProperty(propertyName, (Calendar)((GregorianCalendar)value));
                    break;
                }
                if (!(value instanceof DateValue)) break;
                DateValue dateValue = (DateValue)value;
                node.setProperty(propertyName, dateValue.getDate());
                break;
            }
            case 9: {
                if (value == null) {
                    throw new RepositoryException("null value for a reference " + requiredtype);
                }
                if (value instanceof Value[]) {
                    node.setProperty(propertyName, (Value[])value);
                    break;
                }
                if (!(value instanceof String)) break;
                Session session = node.getSession();
                if (session.getRootNode().hasNode((String)value)) {
                    Node catNode = session.getRootNode().getNode((String)value);
                    Value value2add = session.getValueFactory().createValue(catNode);
                    node.setProperty(propertyName, new Value[]{value2add});
                    break;
                }
                node.setProperty(propertyName, (String)value);
            }
        }
    }

    public void addLanguage(Node questionNode, QuestionLanguage language) throws Exception {
        if (!questionNode.isNodeType("mix:faqi18n")) {
            questionNode.addMixin("mix:faqi18n");
        }
        Node languagesNode = null;
        try {
            languagesNode = questionNode.getNode(Utils.LANGUAGE_HOME);
        }
        catch (Exception e) {
            languagesNode = questionNode.addNode(Utils.LANGUAGE_HOME, NTUNSTRUCTURED);
        }
        Node langNode = null;
        try {
            langNode = languagesNode.getNode(language.getId());
        }
        catch (Exception e) {
            langNode = languagesNode.addNode(language.getId(), NTUNSTRUCTURED);
        }
        langNode.setProperty(EXO_LANGUAGE, language.getLanguage());
        langNode.setProperty("exo:name", language.getDetail());
        langNode.setProperty("exo:title", language.getQuestion());
        if (langNode.isNew()) {
            questionNode.getSession().save();
        } else {
            questionNode.save();
        }
    }

    public void deleteAnswerQuestionLang(Node questionNode, String answerId, String language, SessionProvider sProvider) throws Exception {
        Node languageNode = this.getLanguageNodeByLanguage(questionNode, language);
        Node answerNode = languageNode.getNode(Utils.ANSWER_HOME).getNode(answerId);
        answerNode.remove();
        questionNode.save();
    }

    public void deleteCommentQuestionLang(Node questionNode, String commentId, String language, SessionProvider sProvider) throws Exception {
        Node languageNode = this.getLanguageNodeByLanguage(questionNode, language);
        Node commnetNode = languageNode.getNode(Utils.COMMENT_HOME).getNode(commentId);
        commnetNode.remove();
        questionNode.save();
    }

    public QuestionLanguage getQuestionLanguageByLanguage(Node questionNode, String language) throws Exception {
        QuestionLanguage questionLanguage = new QuestionLanguage();
        questionLanguage.setLanguage(language);
        Node languageNode = this.getLanguageNodeByLanguage(questionNode, language);
        questionLanguage.setId(languageNode.getName());
        questionLanguage.setLanguage(languageNode.getProperty(EXO_LANGUAGE).getString());
        questionLanguage.setDetail(languageNode.getProperty("exo:name").getString());
        questionLanguage.setQuestion(languageNode.getProperty("exo:title").getString());
        return questionLanguage;
    }

    public Comment getCommentById(Node questionNode, String commentId, String language) throws Exception {
        Node languageNode = this.getLanguageNodeByLanguage(questionNode, language);
        try {
            Comment comment = new Comment();
            Node commentNode = languageNode.getNode(Utils.COMMENT_HOME).getNode(commentId);
            if (commentNode.hasProperty("exo:id")) {
                comment.setId(commentNode.getProperty("exo:id").getValue().getString());
            }
            if (commentNode.hasProperty("exo:comments")) {
                comment.setComments(commentNode.getProperty("exo:comments").getValue().getString());
            }
            if (commentNode.hasProperty("exo:commentBy")) {
                comment.setCommentBy(commentNode.getProperty("exo:commentBy").getValue().getString());
            }
            if (commentNode.hasProperty("exo:dateComment")) {
                comment.setDateComment(commentNode.getProperty("exo:dateComment").getValue().getDate().getTime());
            }
            return comment;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Answer getAnswerById(Node questionNode, String answerid, String language) throws Exception {
        Node languageNode = this.getLanguageNodeByLanguage(questionNode, language);
        Answer answer = new Answer();
        try {
            Node answerNode = languageNode.getNode(Utils.ANSWER_HOME).getNode(answerid);
            if (answerNode.hasProperty("exo:id")) {
                answer.setId(answerNode.getProperty("exo:id").getValue().getString());
            }
            if (answerNode.hasProperty("exo:responses")) {
                answer.setResponses(answerNode.getProperty("exo:responses").getValue().getString());
            }
            if (answerNode.hasProperty("exo:responseBy")) {
                answer.setResponseBy(answerNode.getProperty("exo:responseBy").getValue().getString());
            }
            if (answerNode.hasProperty("exo:dateResponse")) {
                answer.setDateResponse(answerNode.getProperty("exo:dateResponse").getValue().getDate().getTime());
            }
            if (answerNode.hasProperty("exo:usersVoteAnswer")) {
                answer.setUsersVoteAnswer(this.ValuesToStrings(answerNode.getProperty("exo:usersVoteAnswer").getValues()));
            }
            if (answerNode.hasProperty("exo:MarkVotes")) {
                answer.setMarkVotes(answerNode.getProperty("exo:MarkVotes").getValue().getLong());
            }
            if (answerNode.hasProperty("exo:approveResponses")) {
                answer.setApprovedAnswers(answerNode.getProperty("exo:approveResponses").getValue().getBoolean());
            }
            if (answerNode.hasProperty("exo:activateResponses")) {
                answer.setActivateAnswers(answerNode.getProperty("exo:activateResponses").getValue().getBoolean());
            }
            return answer;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new String[0];
        }
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    private long[] ValuesToLong(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new long[]{0L};
        }
        long[] d = new long[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            d[i] = Val[i].getLong();
        }
        return d;
    }

    private Value[] longToValues(Node answerNode, long[] marks) {
        if (marks == null || marks.length < 1) {
            return null;
        }
        Value[] values = new Value[marks.length];
        try {
            for (int i = 0; i < marks.length; ++i) {
                values[i] = answerNode.getSession().getValueFactory().createValue(marks[i]);
            }
        }
        catch (Exception e) {
            return null;
        }
        return values;
    }

    private Node getLanguageNodeByLanguage(Node questionNode, String languge) throws Exception {
        NodeIterator nodeIterator = questionNode.getNode(Utils.LANGUAGE_HOME).getNodes();
        Node languageNode = null;
        while (nodeIterator.hasNext()) {
            languageNode = nodeIterator.nextNode();
            if (!languageNode.getProperty(EXO_LANGUAGE).getString().equals(languge)) continue;
            return languageNode;
        }
        return null;
    }

    public void saveAnswer(Node questionNode, Answer answer, String languge, SessionProvider sessionProvider) throws Exception {
        Node languageNode = this.getLanguageNodeByLanguage(questionNode, languge);
        if (!languageNode.isNodeType("mix:faqi18n")) {
            languageNode.addMixin("mix:faqi18n");
        }
        Node answerHome = null;
        try {
            answerHome = languageNode.getNode(Utils.ANSWER_HOME);
        }
        catch (Exception e) {
            answerHome = languageNode.addNode(Utils.ANSWER_HOME, NTUNSTRUCTURED);
        }
        Node answerNode = null;
        try {
            answerNode = answerHome.getNode(answer.getId());
        }
        catch (Exception e) {
            answerNode = answerHome.addNode(answer.getId(), "exo:answer");
        }
        answerNode.setProperty("exo:responses", answer.getResponses());
        answerNode.setProperty("exo:responseBy", answer.getResponseBy());
        answerNode.setProperty("exo:usersVoteAnswer", answer.getUsersVoteAnswer());
        answerNode.setProperty("exo:MarkVotes", answer.getMarkVotes());
        if (answer.isNew()) {
            Calendar calendar = null;
            calendar = GregorianCalendar.getInstance();
            calendar.setTime(new Date());
            answerNode.setProperty("exo:dateResponse", answerNode.getSession().getValueFactory().createValue(calendar));
            answerNode.setProperty("exo:id", answer.getId());
        }
        answerNode.setProperty("exo:approveResponses", answer.getApprovedAnswers().booleanValue());
        answerNode.setProperty("exo:activateResponses", answer.getActivateAnswers().booleanValue());
        if (answer.isNew() || answerNode.isNew()) {
            questionNode.getSession().save();
        } else {
            questionNode.save();
        }
    }

    public void saveAnswer(Node quesNode, QuestionLanguage questionLanguage) throws Exception {
        Node answerNode;
        Node quesLangNode;
        try {
            quesLangNode = quesNode.getNode(Utils.LANGUAGE_HOME).getNode(questionLanguage.getId());
        }
        catch (Exception e) {
            quesLangNode = quesNode.getNode(Utils.LANGUAGE_HOME).addNode(questionLanguage.getId());
        }
        if (!quesLangNode.isNodeType("mix:faqi18n")) {
            quesLangNode.addMixin("mix:faqi18n");
        }
        Node answerHome = null;
        Answer[] answers = questionLanguage.getAnswers();
        try {
            answerHome = quesLangNode.getNode(Utils.ANSWER_HOME);
        }
        catch (Exception e) {
            answerHome = quesLangNode.addNode(Utils.ANSWER_HOME, NTUNSTRUCTURED);
        }
        if (!answerHome.isNew()) {
            ArrayList<String> listNewAnswersId = new ArrayList<String>();
            for (int i = 0; i < answers.length; ++i) {
                listNewAnswersId.add(answers[i].getId());
            }
            NodeIterator nodeIterator = answerHome.getNodes();
            while (nodeIterator.hasNext()) {
                answerNode = nodeIterator.nextNode();
                if (listNewAnswersId.contains(answerNode.getName())) continue;
                answerNode.remove();
            }
        }
        for (Answer answer : answers) {
            answerNode = null;
            try {
                answerNode = answerHome.getNode(answer.getId());
            }
            catch (Exception e) {
                answerNode = answerHome.addNode(answer.getId(), "exo:answer");
                answerNode.setProperty("exo:id", answer.getId());
            }
            if (answerNode.isNew()) {
                Calendar calendar = null;
                calendar = null;
                calendar = GregorianCalendar.getInstance();
                calendar.setTime(new Date());
                answerNode.setProperty("exo:dateResponse", quesLangNode.getSession().getValueFactory().createValue(calendar));
            }
            answerNode.setProperty("exo:responses", answer.getResponses());
            answerNode.setProperty("exo:responseBy", answer.getResponseBy());
            answerNode.setProperty("exo:approveResponses", answer.getApprovedAnswers().booleanValue());
            answerNode.setProperty("exo:activateResponses", answer.getActivateAnswers().booleanValue());
            answerNode.setProperty("exo:usersVoteAnswer", answer.getUsersVoteAnswer());
            answerNode.setProperty("exo:MarkVotes", answer.getMarkVotes());
            if (answerNode.isNew()) {
                quesNode.getSession().save();
                continue;
            }
            quesNode.save();
        }
    }

    public void saveComment(Node questionNode, Comment comment, String languge, SessionProvider sessionProvider) throws Exception {
        Node languageNode = this.getLanguageNodeByLanguage(questionNode, languge);
        if (!languageNode.isNodeType("mix:faqi18n")) {
            languageNode.addMixin("mix:faqi18n");
        }
        Node commentHome = null;
        Node commnetNode = null;
        try {
            commentHome = languageNode.getNode(Utils.COMMENT_HOME);
        }
        catch (Exception e) {
            commentHome = languageNode.addNode(Utils.COMMENT_HOME, NTUNSTRUCTURED);
        }
        try {
            commnetNode = commentHome.getNode(comment.getId());
        }
        catch (Exception e) {
            commnetNode = commentHome.addNode(comment.getId(), "exo:comment");
            commnetNode.setProperty("exo:id", comment.getId());
        }
        commnetNode.setProperty("exo:comments", comment.getComments());
        commnetNode.setProperty("exo:commentBy", comment.getCommentBy());
        if (commnetNode.isNew()) {
            Calendar calendar = null;
            calendar = GregorianCalendar.getInstance();
            calendar.setTime(new Date());
            commnetNode.setProperty("exo:dateComment", commnetNode.getSession().getValueFactory().createValue(calendar));
            questionNode.getSession().save();
        } else {
            questionNode.save();
        }
    }

    protected Value[] booleanToValues(Node node, Boolean[] bools) throws Exception {
        if (bools == null) {
            return new Value[]{node.getSession().getValueFactory().createValue(true)};
        }
        Value[] values = new Value[bools.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = node.getSession().getValueFactory().createValue(bools[i].booleanValue());
        }
        return values;
    }

    public void removeLanguage(Node questionNode, List<String> listLanguage) {
        try {
            if (!questionNode.hasNode(Utils.LANGUAGE_HOME)) {
                return;
            }
            Node languageNode = questionNode.getNode(Utils.LANGUAGE_HOME);
            NodeIterator nodeIterator = languageNode.getNodes();
            Node node = null;
            while (nodeIterator.hasNext()) {
                node = nodeIterator.nextNode();
                if (listLanguage.contains(node.getProperty(EXO_LANGUAGE).getString())) continue;
                node.remove();
            }
            questionNode.getSession().save();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void addLanguage(Node categoryNode, CategoryLanguage language) throws Exception {
        if (!categoryNode.isNodeType("mix:faqi18n")) {
            categoryNode.addMixin("mix:faqi18n");
        }
        Node languagesNode = null;
        try {
            languagesNode = categoryNode.getNode(Utils.LANGUAGE_HOME);
        }
        catch (Exception e) {
            languagesNode = categoryNode.addNode(Utils.LANGUAGE_HOME, NTUNSTRUCTURED);
        }
        Node langNode = null;
        try {
            langNode = languagesNode.getNode(language.getLanguage());
        }
        catch (Exception e) {
            langNode = languagesNode.addNode(language.getLanguage(), NTUNSTRUCTURED);
        }
        langNode.setProperty("exo:name", language.getName());
        categoryNode.save();
    }

    private void setMixin(Node node, Node newLang) throws Exception {
        NodeType[] mixins;
        for (NodeType mixin : mixins = node.getMixinNodeTypes()) {
            if (mixin.getName().equals("exo:actionable") || !newLang.canAddMixin(mixin.getName())) continue;
            newLang.addMixin(mixin.getName());
            for (PropertyDefinition def : mixin.getPropertyDefinitions()) {
                if (def.isProtected()) continue;
                String propName = def.getName();
                if (!def.isMandatory() || def.isAutoCreated()) continue;
                if (def.isMultiple()) {
                    newLang.setProperty(propName, node.getProperty(propName).getValues());
                    continue;
                }
                newLang.setProperty(propName, node.getProperty(propName).getValue());
            }
        }
    }

    public void addLanguage(Node node, Map inputs, String language, boolean isDefault) throws Exception {
        PropertyDefinition[] properties;
        Node newLanguageNode = null;
        Node languagesNode = null;
        String defaultLanguage = this.getDefault(node);
        if (!node.isNodeType("mix:faqi18n")) {
            node.addMixin("mix:faqi18n");
        }
        languagesNode = node.hasNode(Utils.LANGUAGE_HOME) ? node.getNode(Utils.LANGUAGE_HOME) : node.addNode(Utils.LANGUAGE_HOME, NTUNSTRUCTURED);
        if (!defaultLanguage.equals(language)) {
            NodeType[] mixins;
            if (isDefault) {
                if (languagesNode.hasNode(defaultLanguage)) {
                    newLanguageNode = languagesNode.getNode(defaultLanguage);
                } else {
                    newLanguageNode = languagesNode.addNode(defaultLanguage);
                    mixins = node.getMixinNodeTypes();
                    for (PropertyDefinition propertyDefinition : mixins) {
                        if (propertyDefinition.getName().equals("exo:actionable") || !newLanguageNode.canAddMixin(propertyDefinition.getName())) continue;
                        newLanguageNode.addMixin(propertyDefinition.getName());
                    }
                }
            } else if (languagesNode.hasNode(language)) {
                newLanguageNode = languagesNode.getNode(language);
            } else {
                newLanguageNode = languagesNode.addNode(language);
                mixins = node.getMixinNodeTypes();
                for (PropertyDefinition propertyDefinition : mixins) {
                    if (propertyDefinition.getName().equals("exo:actionable")) continue;
                    if (newLanguageNode.canAddMixin(propertyDefinition.getName())) {
                        newLanguageNode.addMixin(propertyDefinition.getName());
                    }
                    for (PropertyDefinition def : propertyDefinition.getPropertyDefinitions()) {
                        if (def.isProtected()) continue;
                        String propName = def.getName();
                        if (!def.isMandatory() || def.isAutoCreated()) continue;
                        if (def.isMultiple()) {
                            newLanguageNode.setProperty(propName, node.getProperty(propName).getValues());
                            continue;
                        }
                        newLanguageNode.setProperty(propName, node.getProperty(propName).getValue());
                    }
                }
                newLanguageNode.setProperty(EXO_LANGUAGE, language);
            }
        }
        for (PropertyDefinition propertyDefinition : properties = node.getPrimaryNodeType().getPropertyDefinitions()) {
            if (propertyDefinition.isProtected()) continue;
            String propertyName = propertyDefinition.getName();
            JcrInputProperty property = (JcrInputProperty)inputs.get(NODE + propertyName);
            System.out.println("propertyName ====>" + propertyName + "===>" + property);
            if (defaultLanguage.equals(language) && property != null) {
                this.setPropertyValue(propertyName, node, propertyDefinition.getRequiredType(), property.getValue(), propertyDefinition.isMultiple());
                continue;
            }
            if (isDefault) {
                if (node.hasProperty(propertyName)) {
                    Value value = null;
                    int requiredType = node.getProperty(propertyName).getDefinition().getRequiredType();
                    boolean isMultiple = node.getProperty(propertyName).getDefinition().isMultiple();
                    value = isMultiple ? node.getProperty(propertyName).getValues() : node.getProperty(propertyName).getValue();
                    this.setPropertyValue(propertyName, newLanguageNode, requiredType, value, isMultiple);
                }
                if (property == null) continue;
                this.setPropertyValue(propertyName, node, propertyDefinition.getRequiredType(), property.getValue(), propertyDefinition.isMultiple());
                continue;
            }
            if (property == null) continue;
            this.setPropertyValue(propertyName, newLanguageNode, propertyDefinition.getRequiredType(), property.getValue(), propertyDefinition.isMultiple());
        }
        if (!defaultLanguage.equals(language) && isDefault) {
            Node selectedLangNode = null;
            if (languagesNode.hasNode(language)) {
                selectedLangNode = languagesNode.getNode(language);
            }
            this.setVoteProperty(newLanguageNode, node, selectedLangNode);
            this.setCommentNode(node, newLanguageNode, selectedLangNode);
        }
        if (isDefault) {
            node.setProperty(EXO_LANGUAGE, language);
        }
        if (isDefault && languagesNode.hasNode(language)) {
            languagesNode.getNode(language).remove();
        }
        node.save();
        node.getSession().save();
        System.out.println("\n\n\n\n>>>>addLanguage() --> size of questionNodeChildren: " + node.getNodes().getSize());
    }

    public void addLanguage(Node node, Map inputs, String language, boolean isDefault, String nodeType) throws Exception {
        Node newLanguageNode = null;
        Node languagesNode = null;
        String defaultLanguage = this.getDefault(node);
        Workspace ws = node.getSession().getWorkspace();
        languagesNode = node.hasNode(Utils.LANGUAGE_HOME) ? node.getNode(Utils.LANGUAGE_HOME) : node.addNode(Utils.LANGUAGE_HOME, NTUNSTRUCTURED);
        if (!defaultLanguage.equals(language)) {
            NodeType[] mixins;
            if (isDefault) {
                if (languagesNode.hasNode(defaultLanguage)) {
                    newLanguageNode = languagesNode.getNode(defaultLanguage);
                } else {
                    newLanguageNode = languagesNode.addNode(defaultLanguage);
                    for (NodeType nodeType2 : mixins = node.getMixinNodeTypes()) {
                        if (nodeType2.getName().equals("exo:actionable") || !newLanguageNode.canAddMixin(nodeType2.getName())) continue;
                        newLanguageNode.addMixin(nodeType2.getName());
                    }
                }
            } else if (languagesNode.hasNode(language)) {
                newLanguageNode = languagesNode.getNode(language);
            } else {
                newLanguageNode = languagesNode.addNode(language);
                for (NodeType nodeType3 : mixins = node.getMixinNodeTypes()) {
                    if (nodeType3.getName().equals("exo:actionable")) continue;
                    if (newLanguageNode.canAddMixin(nodeType3.getName())) {
                        newLanguageNode.addMixin(nodeType3.getName());
                    }
                    for (PropertyDefinition def : nodeType3.getPropertyDefinitions()) {
                        if (def.isProtected()) continue;
                        String propName = def.getName();
                        if (!def.isMandatory() || def.isAutoCreated()) continue;
                        if (def.isMultiple()) {
                            newLanguageNode.setProperty(propName, node.getProperty(propName).getValues());
                            continue;
                        }
                        newLanguageNode.setProperty(propName, node.getProperty(propName).getValue());
                    }
                }
                newLanguageNode.setProperty(EXO_LANGUAGE, language);
            }
            Node jcrContent = node.getNode(nodeType);
            node.save();
            if (!newLanguageNode.hasNode(nodeType)) {
                ws.copy(jcrContent.getPath(), newLanguageNode.getPath() + "/" + jcrContent.getName());
            }
            Node newContentNode = newLanguageNode.getNode(nodeType);
            PropertyIterator props = newContentNode.getProperties();
            while (props.hasNext()) {
                Property prop = props.nextProperty();
                if (!inputs.containsKey(NODE + nodeType + "/" + prop.getName())) continue;
                JcrInputProperty jcrInputProperty = (JcrInputProperty)inputs.get(NODE + nodeType + "/" + prop.getName());
                boolean isMultiple = prop.getDefinition().isMultiple();
                this.setPropertyValue(prop.getName(), newContentNode, prop.getType(), jcrInputProperty.getValue(), isMultiple);
            }
            if (isDefault) {
                Node tempNode = node.addNode(TEMP_NODE, NTUNSTRUCTURED);
                node.getSession().move(node.getNode(nodeType).getPath(), tempNode.getPath() + "/" + nodeType);
                node.getSession().move(newLanguageNode.getNode(nodeType).getPath(), node.getPath() + "/" + nodeType);
                node.getSession().move(tempNode.getNode(nodeType).getPath(), languagesNode.getPath() + "/" + defaultLanguage + "/" + nodeType);
                tempNode.remove();
            }
        } else {
            JcrInputProperty inputVariable = (JcrInputProperty)inputs.get(NODE + nodeType + "/" + JCRDATA);
            this.setPropertyValue(JCRDATA, node.getNode(nodeType), inputVariable.getType(), inputVariable.getValue(), false);
        }
        PropertyDefinition[] properties = node.getPrimaryNodeType().getPropertyDefinitions();
        for (NodeType nodeType4 : properties) {
            if (nodeType4.isProtected()) continue;
            String propertyName = nodeType4.getName();
            JcrInputProperty property = (JcrInputProperty)inputs.get(NODE + propertyName);
            if (defaultLanguage.equals(language) && property != null) {
                this.setPropertyValue(propertyName, node, nodeType4.getRequiredType(), property.getValue(), nodeType4.isMultiple());
                continue;
            }
            if (isDefault) {
                if (node.hasProperty(propertyName)) {
                    Value value = null;
                    int requiredType = node.getProperty(propertyName).getDefinition().getRequiredType();
                    boolean isMultiple = node.getProperty(propertyName).getDefinition().isMultiple();
                    value = isMultiple ? node.getProperty(propertyName).getValues() : node.getProperty(propertyName).getValue();
                    this.setPropertyValue(propertyName, newLanguageNode, requiredType, value, isMultiple);
                }
                if (property == null) continue;
                this.setPropertyValue(propertyName, node, nodeType4.getRequiredType(), property.getValue(), nodeType4.isMultiple());
                continue;
            }
            if (property == null) continue;
            this.setPropertyValue(propertyName, newLanguageNode, nodeType4.getRequiredType(), property.getValue(), nodeType4.isMultiple());
        }
        if (!defaultLanguage.equals(language) && isDefault) {
            Node selectedLangNode = null;
            if (languagesNode.hasNode(language)) {
                selectedLangNode = languagesNode.getNode(language);
            }
            this.setVoteProperty(newLanguageNode, node, selectedLangNode);
            this.setCommentNode(node, newLanguageNode, selectedLangNode);
        }
        if (isDefault) {
            node.setProperty(EXO_LANGUAGE, language);
        }
        if (isDefault && languagesNode.hasNode(language)) {
            languagesNode.getNode(language).remove();
        }
        node.save();
        node.getSession().save();
    }

    public void addFileLanguage(Node node, Value value, String mimeType, String language, boolean isDefault) throws Exception {
        Node newLanguageNode = null;
        Node languagesNode = null;
        Workspace ws = node.getSession().getWorkspace();
        String defaultLanguage = this.getDefault(node);
        languagesNode = node.hasNode(Utils.LANGUAGE_HOME) ? node.getNode(Utils.LANGUAGE_HOME) : node.addNode(Utils.LANGUAGE_HOME, NTUNSTRUCTURED);
        if (!defaultLanguage.equals(language)) {
            Node jcrContent;
            if (isDefault) {
                newLanguageNode = languagesNode.hasNode(defaultLanguage) ? languagesNode.getNode(defaultLanguage) : languagesNode.addNode(defaultLanguage);
                jcrContent = node.getNode(JCRCONTENT);
                node.save();
                ws.copy(jcrContent.getPath(), newLanguageNode.getPath() + "/" + jcrContent.getName());
                jcrContent.setProperty(JCR_MIMETYPE, mimeType);
                jcrContent.setProperty(JCRDATA, value);
            } else {
                newLanguageNode = languagesNode.hasNode(language) ? languagesNode.getNode(language) : languagesNode.addNode(language);
                jcrContent = node.getNode(JCRCONTENT);
                node.save();
                ws.copy(jcrContent.getPath(), newLanguageNode.getPath() + "/" + jcrContent.getName());
                newLanguageNode.getNode(JCRCONTENT).setProperty(JCR_MIMETYPE, mimeType);
                newLanguageNode.getNode(JCRCONTENT).setProperty(JCRDATA, value);
            }
            this.setMixin(node, newLanguageNode);
        } else {
            node.getNode(JCRCONTENT).setProperty(JCRDATA, value);
        }
        if (!defaultLanguage.equals(language) && isDefault) {
            Node selectedLangNode = null;
            if (languagesNode.hasNode(language)) {
                selectedLangNode = languagesNode.getNode(language);
            }
            this.setVoteProperty(newLanguageNode, node, selectedLangNode);
            this.setCommentNode(node, newLanguageNode, selectedLangNode);
        }
        if (isDefault) {
            node.setProperty(EXO_LANGUAGE, language);
        }
        node.save();
        node.getSession().save();
    }

    public void addFileLanguage(Node node, String language, Map mappings, boolean isDefault) throws Exception {
        PropertyDefinition[] properties;
        Node newLanguageNode = null;
        Node languagesNode = null;
        Workspace ws = node.getSession().getWorkspace();
        String defaultLanguage = this.getDefault(node);
        languagesNode = node.hasNode(Utils.LANGUAGE_HOME) ? node.getNode(Utils.LANGUAGE_HOME) : node.addNode(Utils.LANGUAGE_HOME, NTUNSTRUCTURED);
        if (!defaultLanguage.equals(language)) {
            newLanguageNode = isDefault ? (languagesNode.hasNode(defaultLanguage) ? languagesNode.getNode(defaultLanguage) : languagesNode.addNode(defaultLanguage)) : (languagesNode.hasNode(language) ? languagesNode.getNode(language) : languagesNode.addNode(language));
            Node jcrContent = node.getNode(JCRCONTENT);
            node.save();
            if (!newLanguageNode.hasNode(JCRCONTENT)) {
                ws.copy(jcrContent.getPath(), newLanguageNode.getPath() + "/" + jcrContent.getName());
            }
            Node newContentNode = newLanguageNode.getNode(JCRCONTENT);
            PropertyIterator props = newContentNode.getProperties();
            while (props.hasNext()) {
                Property prop = props.nextProperty();
                if (!mappings.containsKey(CONTENT_PATH + prop.getName())) continue;
                JcrInputProperty inputVariable = (JcrInputProperty)mappings.get(CONTENT_PATH + prop.getName());
                boolean isMultiple = prop.getDefinition().isMultiple();
                this.setPropertyValue(prop.getName(), newContentNode, prop.getType(), inputVariable.getValue(), isMultiple);
            }
            if (isDefault) {
                Node tempNode = node.addNode(TEMP_NODE, NTUNSTRUCTURED);
                node.getSession().move(node.getNode(JCRCONTENT).getPath(), tempNode.getPath() + "/" + JCRCONTENT);
                node.getSession().move(newLanguageNode.getNode(JCRCONTENT).getPath(), node.getPath() + "/" + JCRCONTENT);
                node.getSession().move(tempNode.getNode(JCRCONTENT).getPath(), languagesNode.getPath() + "/" + defaultLanguage + "/" + JCRCONTENT);
                tempNode.remove();
            }
            this.setMixin(node, newLanguageNode);
        } else {
            JcrInputProperty inputVariable = (JcrInputProperty)mappings.get("/node/jcr:content/jcr:data");
            this.setPropertyValue(JCRDATA, node.getNode(JCRCONTENT), inputVariable.getType(), inputVariable.getValue(), false);
        }
        for (PropertyDefinition pro : properties = node.getPrimaryNodeType().getPropertyDefinitions()) {
            if (pro.isProtected()) continue;
            String propertyName = pro.getName();
            JcrInputProperty property = (JcrInputProperty)mappings.get(NODE + propertyName);
            if (defaultLanguage.equals(language) && property != null) {
                this.setPropertyValue(propertyName, node, pro.getRequiredType(), property.getValue(), pro.isMultiple());
                continue;
            }
            if (isDefault) {
                if (node.hasProperty(propertyName)) {
                    Value value = null;
                    int requiredType = node.getProperty(propertyName).getDefinition().getRequiredType();
                    boolean isMultiple = node.getProperty(propertyName).getDefinition().isMultiple();
                    value = isMultiple ? node.getProperty(propertyName).getValues() : node.getProperty(propertyName).getValue();
                    this.setPropertyValue(propertyName, newLanguageNode, requiredType, value, isMultiple);
                }
                if (property == null) continue;
                this.setPropertyValue(propertyName, node, pro.getRequiredType(), property.getValue(), pro.isMultiple());
                continue;
            }
            if (property == null) continue;
            this.setPropertyValue(propertyName, newLanguageNode, pro.getRequiredType(), property.getValue(), pro.isMultiple());
        }
        if (!defaultLanguage.equals(language) && isDefault) {
            Node selectedLangNode = null;
            if (languagesNode.hasNode(language)) {
                selectedLangNode = languagesNode.getNode(language);
            }
            this.setVoteProperty(newLanguageNode, node, selectedLangNode);
            this.setCommentNode(node, newLanguageNode, selectedLangNode);
        }
        if (isDefault) {
            node.setProperty(EXO_LANGUAGE, language);
        }
        node.save();
        node.getSession().save();
    }

    public String getDefault(Node node) throws Exception {
        if (node.hasProperty(EXO_LANGUAGE)) {
            return node.getProperty(EXO_LANGUAGE).getString();
        }
        return null;
    }

    public List<String> getSupportedLanguages(Node node) throws Exception {
        ArrayList<String> languages = new ArrayList<String>();
        String defaultLang = this.getDefault(node);
        if (defaultLang != null) {
            languages.add(defaultLang);
        }
        if (node.hasNode(Utils.LANGUAGE_HOME)) {
            Node languageNode = node.getNode(Utils.LANGUAGE_HOME);
            NodeIterator iter = languageNode.getNodes();
            while (iter.hasNext()) {
                languages.add(iter.nextNode().getName());
            }
        }
        return languages;
    }

    private void setVoteProperty(Node newLang, Node node, Node selectedLangNode) throws Exception {
        if (this.hasMixin(newLang, "mix:votable")) {
            newLang.setProperty(VOTE_TOTAL_PROP, this.getVoteTotal(node));
            newLang.setProperty(VOTE_TOTAL_LANG_PROP, node.getProperty(VOTE_TOTAL_LANG_PROP).getLong());
            newLang.setProperty(VOTING_RATE_PROP, node.getProperty(VOTING_RATE_PROP).getLong());
            if (node.hasProperty(VOTER_PROP)) {
                newLang.setProperty(VOTER_PROP, node.getProperty(VOTER_PROP).getValues());
            }
            if (selectedLangNode != null) {
                node.setProperty(VOTE_TOTAL_PROP, this.getVoteTotal(node));
                if (selectedLangNode.hasProperty(VOTE_TOTAL_LANG_PROP)) {
                    node.setProperty(VOTE_TOTAL_LANG_PROP, selectedLangNode.getProperty(VOTE_TOTAL_LANG_PROP).getLong());
                } else {
                    node.setProperty(VOTE_TOTAL_LANG_PROP, 0L);
                }
                if (selectedLangNode.hasProperty(VOTING_RATE_PROP)) {
                    node.setProperty(VOTING_RATE_PROP, selectedLangNode.getProperty(VOTING_RATE_PROP).getLong());
                } else {
                    node.setProperty(VOTING_RATE_PROP, 0L);
                }
                if (selectedLangNode.hasProperty(VOTER_PROP)) {
                    node.setProperty(VOTER_PROP, selectedLangNode.getProperty(VOTER_PROP).getValues());
                }
            } else {
                node.setProperty(VOTE_TOTAL_PROP, this.getVoteTotal(node));
                node.setProperty(VOTE_TOTAL_LANG_PROP, 0L);
                node.setProperty(VOTING_RATE_PROP, 0L);
            }
        }
    }

    private void setCommentNode(Node node, Node newLang, Node selectedLangNode) throws Exception {
        if (node.hasNode(COMMENTS)) {
            node.getSession().move(node.getPath() + "/" + COMMENTS, newLang.getPath() + "/" + COMMENTS);
        }
        if (selectedLangNode != null && selectedLangNode.hasNode(COMMENTS)) {
            node.getSession().move(selectedLangNode.getPath() + "/" + COMMENTS, node.getPath() + "/" + COMMENTS);
        }
    }

    public long getVoteTotal(Node node) throws Exception {
        long voteTotal = 0L;
        if (!node.hasNode(Utils.LANGUAGE_HOME) && node.hasProperty(VOTE_TOTAL_PROP)) {
            return node.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        }
        Node multiLanguages = node.getNode(Utils.LANGUAGE_HOME);
        voteTotal = node.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        NodeIterator nodeIter = multiLanguages.getNodes();
        String defaultLang = this.getDefault(node);
        while (nodeIter.hasNext()) {
            Node languageNode = nodeIter.nextNode();
            if (languageNode.getName().equals(defaultLang) || !languageNode.hasProperty(VOTE_TOTAL_LANG_PROP)) continue;
            voteTotal += languageNode.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        }
        return voteTotal;
    }

    private boolean hasMixin(Node node, String nodeTypeName) throws Exception {
        NodeType[] mixinTypes;
        for (NodeType nodeType : mixinTypes = node.getMixinNodeTypes()) {
            if (!nodeType.getName().equals(nodeTypeName)) continue;
            return true;
        }
        return false;
    }

    public void setDefault(Node node, String language) throws Exception {
        String defaultLanguage = this.getDefault(node);
        if (!defaultLanguage.equals(language)) {
            PropertyDefinition[] properties;
            Node languagesNode = null;
            languagesNode = node.hasNode(Utils.LANGUAGE_HOME) ? node.getNode(Utils.LANGUAGE_HOME) : node.addNode(Utils.LANGUAGE_HOME, NTUNSTRUCTURED);
            Node selectedLangNode = languagesNode.getNode(language);
            Node newLang = languagesNode.addNode(defaultLanguage);
            for (PropertyDefinition pro : properties = node.getPrimaryNodeType().getPropertyDefinitions()) {
                Value[] values;
                if (pro.isProtected()) continue;
                String propertyName = pro.getName();
                if (node.hasProperty(propertyName)) {
                    if (node.getProperty(propertyName).getDefinition().isMultiple()) {
                        values = node.getProperty(propertyName).getValues();
                        newLang.setProperty(propertyName, values);
                    } else {
                        newLang.setProperty(propertyName, node.getProperty(propertyName).getValue());
                    }
                }
                if (!selectedLangNode.hasProperty(propertyName)) continue;
                if (selectedLangNode.getProperty(propertyName).getDefinition().isMultiple()) {
                    values = selectedLangNode.getProperty(propertyName).getValues();
                    node.setProperty(propertyName, values);
                    continue;
                }
                node.setProperty(propertyName, selectedLangNode.getProperty(propertyName).getValue());
            }
            if (this.hasNodeTypeNTResource(node)) {
                this.processWithDataChildNode(node, selectedLangNode, languagesNode, defaultLanguage, this.getChildNodeType(node));
            }
            this.setMixin(node, newLang);
            this.setVoteProperty(newLang, node, selectedLangNode);
            node.setProperty(EXO_LANGUAGE, language);
            this.setCommentNode(node, newLang, selectedLangNode);
            selectedLangNode.remove();
            node.save();
            node.getSession().save();
        }
    }

    private void processWithDataChildNode(Node node, Node selectedLangNode, Node languagesNode, String defaultLanguage, String nodeType) throws Exception {
        Node tempNode = node.addNode(TEMP_NODE, NTUNSTRUCTURED);
        node.getSession().move(node.getNode(nodeType).getPath(), tempNode.getPath() + "/" + nodeType);
        node.getSession().move(selectedLangNode.getNode(nodeType).getPath(), node.getPath() + "/" + nodeType);
        node.getSession().move(tempNode.getNode(nodeType).getPath(), languagesNode.getPath() + "/" + defaultLanguage + "/" + nodeType);
        tempNode.remove();
    }

    private boolean hasNodeTypeNTResource(Node node) throws Exception {
        if (node.hasNodes()) {
            NodeIterator nodeIter = node.getNodes();
            while (nodeIter.hasNext()) {
                Node childNode = nodeIter.nextNode();
                if (!childNode.getPrimaryNodeType().getName().equals("nt:resource")) continue;
                return true;
            }
        }
        return false;
    }

    private String getChildNodeType(Node node) throws Exception {
        if (node.hasNodes()) {
            NodeIterator nodeIter = node.getNodes();
            while (nodeIter.hasNext()) {
                Node childNode = nodeIter.nextNode();
                if (!childNode.getPrimaryNodeType().getName().equals("nt:resource")) continue;
                return childNode.getName();
            }
        }
        return null;
    }

    public Node getLanguage(Node node, String language) throws Exception {
        if (node.hasNode(Utils.LANGUAGE_HOME + "/" + language)) {
            return node.getNode(Utils.LANGUAGE_HOME + "/" + language);
        }
        return null;
    }
}

