/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.services.jcr.impl.core.value.DateValue;
import org.exoplatform.services.jcr.impl.core.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLanguages {
    public static final String EXO_LANGUAGE = "exo:language";
    public static final String COMMENTS = "comments".intern();
    public static final String JCRCONTENT = "jcr:content";
    public static final String JCRDATA = "jcr:data";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String NTUNSTRUCTURED = "nt:unstructured";
    static final String VOTER_PROP = "exo:voter".intern();
    static final String VOTING_RATE_PROP = "exo:votingRate".intern();
    static final String VOTE_TOTAL_PROP = "exo:voteTotal".intern();
    static final String VOTE_TOTAL_LANG_PROP = "exo:voteTotalOfLang".intern();
    static final String NODE = "/node/";
    static final String NODE_LANGUAGE = "/node/languages/";
    static final String CONTENT_PATH = "/node/jcr:content/";
    static final String TEMP_NODE = "temp";

    private void setPropertyValue(String propertyName, Node node, int requiredtype, Object value, boolean isMultiple) throws Exception {
        switch (requiredtype) {
            case 1: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (isMultiple) {
                    if (value instanceof String) {
                        node.setProperty(propertyName, new String[]{value.toString()});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                if (value instanceof StringValue) {
                    StringValue strValue = (StringValue)value;
                    node.setProperty(propertyName, strValue.getString());
                    break;
                }
                node.setProperty(propertyName, value.toString());
                break;
            }
            case 2: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (value instanceof byte[]) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream((byte[])value));
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(value.toString().getBytes()));
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(((String[])value).toString().getBytes()));
                break;
            }
            case 6: {
                if (value == null) {
                    node.setProperty(propertyName, false);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Boolean(value.toString()).booleanValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 3: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Long(value.toString()).longValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 4: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Double(value.toString()).doubleValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 5: {
                if (value == null) {
                    node.setProperty(propertyName, (Calendar)new GregorianCalendar());
                    break;
                }
                if (isMultiple) {
                    Session session = node.getSession();
                    if (value instanceof String) {
                        Value value2add = session.getValueFactory().createValue(ISO8601.parse((String)((String)value)));
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    String[] values = (String[])value;
                    Value[] convertedCalendarValues = new Value[values.length];
                    int i = 0;
                    for (String stringValue : values) {
                        Value value2add;
                        convertedCalendarValues[i] = value2add = session.getValueFactory().createValue(ISO8601.parse((String)stringValue));
                        ++i;
                    }
                    node.setProperty(propertyName, convertedCalendarValues);
                    session.logout();
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, ISO8601.parse((String)value.toString()));
                    break;
                }
                if (value instanceof GregorianCalendar) {
                    node.setProperty(propertyName, (Calendar)((GregorianCalendar)value));
                    break;
                }
                if (!(value instanceof DateValue)) break;
                DateValue dateValue = (DateValue)value;
                node.setProperty(propertyName, dateValue.getDate());
                break;
            }
            case 9: {
                if (value == null) {
                    throw new RepositoryException("null value for a reference " + requiredtype);
                }
                if (value instanceof Value[]) {
                    node.setProperty(propertyName, (Value[])value);
                    break;
                }
                if (!(value instanceof String)) break;
                Session session = node.getSession();
                if (session.getRootNode().hasNode((String)value)) {
                    Node catNode = session.getRootNode().getNode((String)value);
                    Value value2add = session.getValueFactory().createValue(catNode);
                    node.setProperty(propertyName, new Value[]{value2add});
                    break;
                }
                node.setProperty(propertyName, (String)value);
            }
        }
    }

    private static String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new String[0];
        }
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    private static List<String> ValuesToList(Value[] Val) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (Val.length < 1) {
            return list;
        }
        for (int i = 0; i < Val.length; ++i) {
            list.add(Val[i].getString());
        }
        return list;
    }

    private static Node getLanguageNodeByLanguage(Node questionNode, String language) throws Exception {
        if (language.equals(questionNode.getProperty(EXO_LANGUAGE).getString())) {
            return questionNode;
        }
        NodeIterator nodeIterator = questionNode.getNode(Utils.LANGUAGE_HOME).getNodes();
        Node languageNode = null;
        while (nodeIterator.hasNext()) {
            languageNode = nodeIterator.nextNode();
            if (!languageNode.getProperty(EXO_LANGUAGE).getString().equals(language)) continue;
            return languageNode;
        }
        return null;
    }

    public static void addLanguage(Node questionNode, QuestionLanguage language) throws Exception {
        if (!questionNode.isNodeType("mix:faqi18n")) {
            questionNode.addMixin("mix:faqi18n");
        }
        Node languageHome = null;
        try {
            languageHome = questionNode.getNode(Utils.LANGUAGE_HOME);
        }
        catch (Exception e) {
            languageHome = questionNode.addNode(Utils.LANGUAGE_HOME, "exo:questionLanguageHome");
        }
        Node langNode = null;
        try {
            langNode = languageHome.getNode(language.getId());
        }
        catch (Exception e) {
            langNode = languageHome.addNode(language.getId(), "exo:faqLanguage");
        }
        langNode.setProperty(EXO_LANGUAGE, language.getLanguage());
        langNode.setProperty("exo:name", language.getDetail());
        langNode.setProperty("exo:title", language.getQuestion());
        langNode.setProperty("exo:questionId", questionNode.getName());
        langNode.setProperty("exo:categoryId", questionNode.getProperty("exo:categoryId").getString());
        if (langNode.isNew()) {
            questionNode.getSession().save();
        } else {
            questionNode.save();
        }
    }

    public static void deleteAnswerQuestionLang(Node questionNode, String answerId, String language) throws Exception {
        Node answerNode;
        if (language != null && language.length() > 0) {
            Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
            answerNode = languageNode.getNode(Utils.ANSWER_HOME).getNode(answerId);
        } else {
            answerNode = questionNode.getNode(Utils.ANSWER_HOME).getNode(answerId);
        }
        answerNode.remove();
        questionNode.save();
    }

    public static void deleteCommentQuestionLang(Node questionNode, String commentId, String language) throws Exception {
        Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
        Node commnetNode = languageNode.getNode(Utils.COMMENT_HOME).getNode(commentId);
        commnetNode.remove();
        questionNode.save();
    }

    public static QuestionLanguage getQuestionLanguageByLanguage(Node questionNode, String language) throws Exception {
        Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
        return MultiLanguages.getQuestionLanguage(languageNode);
    }

    private static QuestionLanguage getQuestionLanguage(Node questionNode) throws Exception {
        QuestionLanguage questionLanguage = new QuestionLanguage();
        questionLanguage.setState(QuestionLanguage.VIEW);
        questionLanguage.setId(questionNode.getName());
        questionLanguage.setLanguage(questionNode.getProperty(EXO_LANGUAGE).getValue().getString());
        questionLanguage.setQuestion(questionNode.getProperty("exo:title").getValue().getString());
        if (questionNode.hasProperty("exo:name")) {
            questionLanguage.setDetail(questionNode.getProperty("exo:name").getValue().getString());
        }
        Comment[] comments = MultiLanguages.getComment(questionNode);
        Answer[] answers = MultiLanguages.getAnswers(questionNode);
        questionLanguage.setComments(comments);
        questionLanguage.setAnswers(answers);
        return questionLanguage;
    }

    private static Comment[] getComment(Node questionNode) throws Exception {
        try {
            if (!questionNode.hasNode(Utils.COMMENT_HOME)) {
                return new Comment[0];
            }
            NodeIterator nodeIterator = questionNode.getNode(Utils.COMMENT_HOME).getNodes();
            Comment[] comments = new Comment[(int)nodeIterator.getSize()];
            Node commentNode = null;
            int i = 0;
            while (nodeIterator.hasNext()) {
                commentNode = nodeIterator.nextNode();
                comments[i] = MultiLanguages.getCommentByNode(commentNode);
                ++i;
            }
            return comments;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Comment[0];
        }
    }

    private static Comment getCommentByNode(Node commentNode) throws Exception {
        Comment comment = new Comment();
        comment.setId(commentNode.getName());
        if (commentNode.hasProperty("exo:comments")) {
            comment.setComments(commentNode.getProperty("exo:comments").getValue().getString());
        }
        if (commentNode.hasProperty("exo:commentBy")) {
            comment.setCommentBy(commentNode.getProperty("exo:commentBy").getValue().getString());
        }
        if (commentNode.hasProperty("exo:dateComment")) {
            comment.setDateComment(commentNode.getProperty("exo:dateComment").getValue().getDate().getTime());
        }
        if (commentNode.hasProperty("exo:fullName")) {
            comment.setFullName(commentNode.getProperty("exo:fullName").getValue().getString());
        }
        if (commentNode.hasProperty("exo:postId")) {
            comment.setPostId(commentNode.getProperty("exo:postId").getString());
        }
        return comment;
    }

    private static Answer[] getAnswers(Node questionNode) throws Exception {
        try {
            if (!questionNode.hasNode(Utils.ANSWER_HOME)) {
                return new Answer[0];
            }
            NodeIterator nodeIterator = questionNode.getNode(Utils.ANSWER_HOME).getNodes();
            ArrayList<Answer> answers = new ArrayList<Answer>();
            String language = questionNode.getProperty(EXO_LANGUAGE).getString();
            while (nodeIterator.hasNext()) {
                try {
                    Answer ans = MultiLanguages.getAnswerByNode(nodeIterator.nextNode());
                    ans.setLanguage(language);
                    answers.add(ans);
                }
                catch (Exception e) {}
            }
            return answers.toArray(new Answer[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Answer[0];
        }
    }

    private static Answer getAnswerByNode(Node answerNode) throws Exception {
        Answer answer = new Answer();
        answer.setId(answerNode.getName());
        if (answerNode.hasProperty("exo:responses")) {
            answer.setResponses(answerNode.getProperty("exo:responses").getValue().getString());
        }
        if (answerNode.hasProperty("exo:responseBy")) {
            answer.setResponseBy(answerNode.getProperty("exo:responseBy").getValue().getString());
        }
        if (answerNode.hasProperty("exo:fullName")) {
            answer.setFullName(answerNode.getProperty("exo:fullName").getValue().getString());
        }
        if (answerNode.hasProperty("exo:dateResponse")) {
            answer.setDateResponse(answerNode.getProperty("exo:dateResponse").getValue().getDate().getTime());
        }
        if (answerNode.hasProperty("exo:usersVoteAnswer")) {
            answer.setUsersVoteAnswer(MultiLanguages.ValuesToStrings(answerNode.getProperty("exo:usersVoteAnswer").getValues()));
        }
        if (answerNode.hasProperty("exo:MarkVotes")) {
            answer.setMarkVotes(answerNode.getProperty("exo:MarkVotes").getValue().getLong());
        }
        if (answerNode.hasProperty("exo:approveResponses")) {
            answer.setApprovedAnswers(answerNode.getProperty("exo:approveResponses").getValue().getBoolean());
        }
        if (answerNode.hasProperty("exo:activateResponses")) {
            answer.setActivateAnswers(answerNode.getProperty("exo:activateResponses").getValue().getBoolean());
        }
        if (answerNode.hasProperty("exo:postId")) {
            answer.setPostId(answerNode.getProperty("exo:postId").getString());
        }
        String path = answerNode.getPath();
        answer.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        return answer;
    }

    public static Comment getCommentById(Node questionNode, String commentId, String language) throws Exception {
        try {
            Node commentNode;
            if (language != null && language.length() > 0) {
                Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
                commentNode = languageNode.getNode(Utils.COMMENT_HOME).getNode(commentId);
            } else {
                commentNode = questionNode.getNode(Utils.COMMENT_HOME).getNode(commentId);
            }
            Comment comment = new Comment();
            if (commentNode.hasProperty("exo:id")) {
                comment.setId(commentNode.getProperty("exo:id").getValue().getString());
            }
            if (commentNode.hasProperty("exo:comments")) {
                comment.setComments(commentNode.getProperty("exo:comments").getValue().getString());
            }
            if (commentNode.hasProperty("exo:commentBy")) {
                comment.setCommentBy(commentNode.getProperty("exo:commentBy").getValue().getString());
            }
            if (commentNode.hasProperty("exo:fullName")) {
                comment.setFullName(commentNode.getProperty("exo:fullName").getValue().getString());
            }
            if (commentNode.hasProperty("exo:dateComment")) {
                comment.setDateComment(commentNode.getProperty("exo:dateComment").getValue().getDate().getTime());
            }
            return comment;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Answer getAnswerById(Node questionNode, String answerid, String language) throws Exception {
        Answer answer = new Answer();
        try {
            Node answerNode;
            if (language != null && language.length() > 0) {
                Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
                answerNode = languageNode.getNode(Utils.ANSWER_HOME).getNode(answerid);
            } else {
                answerNode = questionNode.getNode(Utils.ANSWER_HOME).getNode(answerid);
            }
            answer.setId(answerNode.getProperty("exo:id").getValue().getString());
            String path = answerNode.getPath();
            answer.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
            if (answerNode.hasProperty("exo:responses")) {
                answer.setResponses(answerNode.getProperty("exo:responses").getValue().getString());
            }
            if (answerNode.hasProperty("exo:responseBy")) {
                answer.setResponseBy(answerNode.getProperty("exo:responseBy").getValue().getString());
            }
            if (answerNode.hasProperty("exo:fullName")) {
                answer.setFullName(answerNode.getProperty("exo:fullName").getValue().getString());
            }
            if (answerNode.hasProperty("exo:dateResponse")) {
                answer.setDateResponse(answerNode.getProperty("exo:dateResponse").getValue().getDate().getTime());
            }
            if (answerNode.hasProperty("exo:usersVoteAnswer")) {
                answer.setUsersVoteAnswer(MultiLanguages.ValuesToStrings(answerNode.getProperty("exo:usersVoteAnswer").getValues()));
            }
            if (answerNode.hasProperty("exo:MarkVotes")) {
                answer.setMarkVotes(answerNode.getProperty("exo:MarkVotes").getValue().getLong());
            }
            if (answerNode.hasProperty("exo:approveResponses")) {
                answer.setApprovedAnswers(answerNode.getProperty("exo:approveResponses").getValue().getBoolean());
            }
            if (answerNode.hasProperty("exo:activateResponses")) {
                answer.setActivateAnswers(answerNode.getProperty("exo:activateResponses").getValue().getBoolean());
            }
            answer.setLanguage(answerNode.getProperty("exo:responseLanguage").getValue().getString());
            return answer;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void saveAnswer(Node questionNode, Answer answer, String language) throws Exception {
        Node answerNode;
        Node answerHome;
        String defaultLang = questionNode.getProperty(EXO_LANGUAGE).getString();
        if (language != null && language.length() > 0 && !language.equals(defaultLang)) {
            Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
            if (!languageNode.isNodeType("mix:faqi18n")) {
                languageNode.addMixin("mix:faqi18n");
            }
            try {
                answerHome = languageNode.getNode(Utils.ANSWER_HOME);
            }
            catch (Exception e) {
                answerHome = languageNode.addNode(Utils.ANSWER_HOME, "exo:answerHome");
            }
            answer.setLanguage(language);
        } else {
            try {
                answerHome = questionNode.getNode(Utils.ANSWER_HOME);
            }
            catch (Exception e) {
                answerHome = questionNode.addNode(Utils.ANSWER_HOME, "exo:answerHome");
            }
            answer.setLanguage(questionNode.getProperty(EXO_LANGUAGE).getString());
        }
        try {
            answerNode = answerHome.getNode(answer.getId());
        }
        catch (Exception e) {
            answerNode = answerHome.addNode(answer.getId(), "exo:answer");
        }
        answerNode.setProperty("exo:responses", answer.getResponses());
        answerNode.setProperty("exo:responseBy", answer.getResponseBy());
        answerNode.setProperty("exo:fullName", answer.getFullName());
        answerNode.setProperty("exo:usersVoteAnswer", answer.getUsersVoteAnswer());
        answerNode.setProperty("exo:MarkVotes", answer.getMarkVotes());
        if (answer.isNew()) {
            Calendar calendar = null;
            calendar = GregorianCalendar.getInstance();
            calendar.setTime(new Date());
            answerNode.setProperty("exo:dateResponse", calendar);
            answerNode.setProperty("exo:id", answer.getId());
            answerNode.setProperty("exo:questionId", questionNode.getName());
            answerNode.setProperty("exo:responseLanguage", language);
            answerNode.setProperty("exo:categoryId", questionNode.getProperty("exo:categoryId").getString());
        }
        answerNode.setProperty("exo:approveResponses", answer.getApprovedAnswers().booleanValue());
        answerNode.setProperty("exo:activateResponses", answer.getActivateAnswers().booleanValue());
        if (questionNode.isNew()) {
            questionNode.getSession().save();
        } else {
            questionNode.save();
        }
    }

    public static void saveAnswer(Node quesNode, QuestionLanguage questionLanguage) throws Exception {
        Node answerNode;
        Node quesLangNode;
        try {
            quesLangNode = quesNode.getNode(Utils.LANGUAGE_HOME).getNode(questionLanguage.getId());
        }
        catch (Exception e) {
            quesLangNode = quesNode.getNode(Utils.LANGUAGE_HOME).addNode(questionLanguage.getId(), "exo:faqLanguage");
            quesNode.getSession().save();
        }
        if (!quesLangNode.isNodeType("mix:faqi18n")) {
            quesLangNode.addMixin("mix:faqi18n");
        }
        Node answerHome = null;
        Answer[] answers = questionLanguage.getAnswers();
        try {
            answerHome = quesLangNode.getNode(Utils.ANSWER_HOME);
        }
        catch (Exception e) {
            answerHome = quesLangNode.addNode(Utils.ANSWER_HOME, "exo:answerHome");
        }
        if (!answerHome.isNew()) {
            ArrayList<String> listNewAnswersId = new ArrayList<String>();
            for (int i = 0; i < answers.length; ++i) {
                listNewAnswersId.add(answers[i].getId());
            }
            NodeIterator nodeIterator = answerHome.getNodes();
            while (nodeIterator.hasNext()) {
                answerNode = nodeIterator.nextNode();
                if (listNewAnswersId.contains(answerNode.getName())) continue;
                answerNode.remove();
            }
        }
        for (Answer answer : answers) {
            String language;
            answerNode = null;
            try {
                answerNode = answerHome.getNode(answer.getId());
            }
            catch (Exception e) {
                answerNode = answerHome.addNode(answer.getId(), "exo:answer");
                answerNode.setProperty("exo:id", answer.getId());
            }
            if (answerNode.isNew()) {
                Calendar calendar = null;
                calendar = null;
                calendar = GregorianCalendar.getInstance();
                calendar.setTime(new Date());
                answerNode.setProperty("exo:dateResponse", calendar);
                answerNode.setProperty("exo:questionId", quesNode.getName());
                answerNode.setProperty("exo:categoryId", quesNode.getProperty("exo:categoryId").getString());
            }
            if ((language = answer.getLanguage()) == null || language.length() == 0) {
                language = questionLanguage.getLanguage();
            }
            answerNode.setProperty("exo:responses", answer.getResponses());
            answerNode.setProperty("exo:responseBy", answer.getResponseBy());
            answerNode.setProperty("exo:fullName", answer.getFullName());
            answerNode.setProperty("exo:approveResponses", answer.getApprovedAnswers().booleanValue());
            answerNode.setProperty("exo:activateResponses", answer.getActivateAnswers().booleanValue());
            answerNode.setProperty("exo:usersVoteAnswer", answer.getUsersVoteAnswer());
            answerNode.setProperty("exo:MarkVotes", answer.getMarkVotes());
            answerNode.setProperty("exo:responseLanguage", language);
            if (answerNode.isNew()) {
                quesNode.getSession().save();
                continue;
            }
            quesNode.save();
        }
    }

    public static void saveComment(Node questionNode, Comment comment, String language) throws Exception {
        Node commentNode;
        Node commentHome;
        if (language != null && language.length() > 0) {
            Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
            String lang = language;
            if (!languageNode.isNodeType("mix:faqi18n")) {
                languageNode.addMixin("mix:faqi18n");
            }
            try {
                commentHome = languageNode.getNode(Utils.COMMENT_HOME);
            }
            catch (Exception e) {
                commentHome = languageNode.addNode(Utils.COMMENT_HOME, "exo:commentHome");
            }
        } else {
            try {
                commentHome = questionNode.getNode(Utils.COMMENT_HOME);
            }
            catch (Exception e) {
                commentHome = questionNode.addNode(Utils.COMMENT_HOME, "exo:commentHome");
            }
            String lang = questionNode.getProperty(EXO_LANGUAGE).getString();
        }
        try {
            commentNode = commentHome.getNode(comment.getId());
        }
        catch (Exception e) {
            commentNode = commentHome.addNode(comment.getId(), "exo:comment");
            commentNode.setProperty("exo:id", comment.getId());
        }
        commentNode.setProperty("exo:comments", comment.getComments());
        commentNode.setProperty("exo:commentBy", comment.getCommentBy());
        commentNode.setProperty("exo:fullName", comment.getFullName());
        if (commentNode.isNew()) {
            Calendar calendar = null;
            calendar = GregorianCalendar.getInstance();
            calendar.setTime(new Date());
            commentNode.setProperty("exo:dateComment", calendar);
        }
        questionNode.save();
    }

    protected Value[] booleanToValues(Node node, Boolean[] bools) throws Exception {
        if (bools == null) {
            return new Value[]{node.getSession().getValueFactory().createValue(true)};
        }
        Value[] values = new Value[bools.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = node.getSession().getValueFactory().createValue(bools[i].booleanValue());
        }
        return values;
    }

    public static void removeLanguage(Node questionNode, List<String> listLanguage) {
        try {
            if (!questionNode.hasNode(Utils.LANGUAGE_HOME)) {
                return;
            }
            Node languageNode = questionNode.getNode(Utils.LANGUAGE_HOME);
            NodeIterator nodeIterator = languageNode.getNodes();
            Node node = null;
            while (nodeIterator.hasNext()) {
                node = nodeIterator.nextNode();
                if (listLanguage.contains(node.getProperty(EXO_LANGUAGE).getString())) continue;
                node.remove();
            }
            questionNode.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeLanguage(Node questionNode, QuestionLanguage lang) {
        try {
            if (!questionNode.hasNode(Utils.LANGUAGE_HOME)) {
                return;
            }
            Node languageNode = questionNode.getNode(Utils.LANGUAGE_HOME);
            languageNode.getNode(lang.getId()).remove();
            questionNode.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void voteAnswer(Node answerNode, String userName, boolean isUp) throws Exception {
        boolean isVoted = false;
        long mark = 0L;
        List<Object> users = new ArrayList<String>();
        if (answerNode.hasProperty("exo:usersVoteAnswer") && answerNode.hasProperty("exo:MarkVotes")) {
            users = MultiLanguages.ValuesToList(answerNode.getProperty("exo:usersVoteAnswer").getValues());
            mark = answerNode.getProperty("exo:MarkVotes").getLong();
            int i = 0;
            for (String string : users) {
                if (string.indexOf(userName) > -1) {
                    String[] values = string.split("/");
                    if (values[1].equals("1")) {
                        if (!isUp) {
                            mark -= 2L;
                            users.add(i, userName + "/-1");
                        }
                    } else if (isUp) {
                        mark += 2L;
                        users.add(i, userName + "/1");
                    }
                    isVoted = true;
                    break;
                }
                ++i;
            }
        }
        if (isVoted) {
            answerNode.setProperty("exo:usersVoteAnswer", users.toArray(new String[0]));
            answerNode.setProperty("exo:MarkVotes", mark);
        } else {
            ArrayList<String> newUsers = users;
            if (isUp) {
                ++mark;
                newUsers.add(userName + "/1");
            } else {
                --mark;
                newUsers.add(userName + "/-1");
            }
            answerNode.setProperty("exo:usersVoteAnswer", newUsers.toArray(new String[0]));
            answerNode.setProperty("exo:MarkVotes", mark);
        }
        answerNode.save();
    }

    public static void voteQuestion(Node questionNode, String userName, int number) throws Exception {
        if (questionNode.hasProperty("exo:markVote") && questionNode.hasProperty("exo:usersVote")) {
            double mark = questionNode.getProperty("exo:markVote").getDouble();
            ArrayList<String> currentUsers = new ArrayList<String>();
            currentUsers.addAll(MultiLanguages.ValuesToList(questionNode.getProperty("exo:usersVote").getValues()));
            double currentMark = (mark * (double)currentUsers.size() + (double)number) / (double)(currentUsers.size() + 1);
            currentUsers.add(userName + "/" + number);
            questionNode.setProperty("exo:markVote", currentMark);
            questionNode.setProperty("exo:usersVote", currentUsers.toArray(new String[0]));
        } else {
            double mark = number;
            questionNode.setProperty("exo:markVote", mark);
            questionNode.setProperty("exo:usersVote", new String[]{userName + "/" + number});
        }
        questionNode.save();
    }

    public static void unVoteQuestion(Node questionNode, String userName) throws Exception {
        String[] users = MultiLanguages.ValuesToStrings(questionNode.getProperty("exo:usersVote").getValues());
        List<String> userList = Arrays.asList(users);
        ArrayList<String> newList = new ArrayList<String>();
        double mark = 0.0;
        for (String user : userList) {
            if (user.indexOf(userName + "/") == 0) {
                int number = Integer.parseInt(user.substring(user.indexOf("/") + 1));
                mark = questionNode.getProperty("exo:markVote").getDouble();
                mark = mark * (double)userList.size() - (double)number;
                continue;
            }
            newList.add(user);
        }
        questionNode.setProperty("exo:markVote", mark);
        questionNode.setProperty("exo:usersVote", newList.toArray(new String[0]));
        questionNode.save();
    }
}

