/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Cate;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.CategoryInfo;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQEventQuery;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.InitialDataPlugin;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.ObjectSearchResult;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.QuestionPageList;
import org.exoplatform.faq.service.TemplatePlugin;
import org.exoplatform.faq.service.Watch;
import org.exoplatform.faq.service.impl.JCRDataStorage;
import org.exoplatform.faq.service.impl.MultiLanguages;
import org.exoplatform.ks.common.NotifyInfo;
import org.exoplatform.ks.common.bbcode.BBCode;
import org.exoplatform.ks.common.bbcode.BBCodeOperator;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.mail.Message;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAQServiceImpl
implements FAQService,
Startable {
    public static final int CATEGORY = 1;
    public static final int QUESTION = 2;
    public static final int SEND_EMAIL = 1;
    private JCRDataStorage jcrData_;
    private MultiLanguages multiLanguages_;
    private BBCodeOperator bbcodeObject_;
    private TemplatePlugin template_;
    private ConfigurationManager configManager_;
    private Collection<InitialDataPlugin> initDataPlugins;
    private static Log log = ExoLogger.getLogger(FAQServiceImpl.class);

    public FAQServiceImpl(ConfigurationManager configManager, NodeHierarchyCreator nodeHierarchy, RepositoryService rService, InitParams params) throws Exception {
        this.configManager_ = configManager;
        this.jcrData_ = new JCRDataStorage(nodeHierarchy, rService);
        this.multiLanguages_ = new MultiLanguages();
        this.initDataPlugins = new ArrayList<InitialDataPlugin>();
        this.bbcodeObject_ = new BBCodeOperator(nodeHierarchy, rService);
        this.jcrData_.setEmailDefault("<" + params.getValueParam("emailDefault").getValue() + ">");
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) throws Exception {
        this.jcrData_.addPlugin(plugin);
    }

    @Override
    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        this.jcrData_.addRolePlugin(plugin);
    }

    @Override
    public void addInitialDataPlugin(InitialDataPlugin plugin) throws Exception {
        this.initDataPlugins.add(plugin);
    }

    @Override
    public void addInitRssPlugin(ComponentPlugin plugin) throws Exception {
        this.jcrData_.addInitRssPlugin(plugin);
    }

    public void addTemplatePlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof TemplatePlugin) {
            this.template_ = (TemplatePlugin)plugin;
        }
    }

    public void start() {
        log.info((Object)"initializing FAQ default data...");
        try {
            this.jcrData_.initRootCategory();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while initializing the root category", e);
        }
        for (InitialDataPlugin plugin : this.initDataPlugins) {
            try {
                if (!plugin.importData(this, this.configManager_)) continue;
                log.info((Object)("imported plugin " + (Object)((Object)plugin)));
            }
            catch (Exception e) {
                log.error((Object)("Error while initializing Data plugin " + plugin.getName()), (Throwable)e);
            }
        }
        try {
            log.info((Object)"initializing FAQ RSS listeners...");
            this.jcrData_.reInitRSSEvenListener();
        }
        catch (Exception e) {
            log.error((Object)"Error while initializing FAQ RSS listeners", (Throwable)e);
        }
        try {
            log.info((Object)"initializing FAQ template...");
            this.initViewerTemplate();
        }
        catch (Exception e) {
            log.error((Object)"Error while initializing FAQ template", (Throwable)e);
        }
    }

    public void stop() {
    }

    private void initViewerTemplate() throws Exception {
        if (this.template_ == null) {
            log.warn((Object)"No default template was configured for FAQ.");
            return;
        }
        if (this.getTemplate() == null) {
            InputStream in = this.configManager_.getInputStream(this.template_.getPath());
            byte[] data = new byte[in.available()];
            in.read(data);
            this.saveTemplate(new String(data));
        }
        this.configManager_ = null;
        this.template_ = null;
    }

    @Override
    public List<String> getAllFAQAdmin() throws Exception {
        return this.jcrData_.getAllFAQAdmin();
    }

    @Override
    public List<Category> getAllCategories(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getAllCategories();
    }

    @Override
    public List<Category> getAllCategories() throws Exception {
        return this.jcrData_.getAllCategories();
    }

    @Override
    public QuestionPageList getAllQuestions(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getAllQuestions();
    }

    @Override
    public QuestionPageList getAllQuestions() throws Exception {
        return this.jcrData_.getAllQuestions();
    }

    @Override
    public QuestionPageList getQuestionsNotYetAnswer(SessionProvider sProvider, String categoryId, FAQSetting setting) throws Exception {
        sProvider.close();
        if (setting.getDisplayMode().equals("Approved")) {
            return this.getQuestionsNotYetAnswer(categoryId, true);
        }
        return this.getQuestionsNotYetAnswer(categoryId, false);
    }

    @Override
    public QuestionPageList getQuestionsNotYetAnswer(String categoryId, boolean isApproved) throws Exception {
        return this.jcrData_.getQuestionsNotYetAnswer(categoryId, isApproved);
    }

    @Override
    public long[] getCategoryInfo(String categoryId, SessionProvider sProvider, FAQSetting setting) throws Exception {
        sProvider.close();
        return this.getCategoryInfo(categoryId, setting);
    }

    @Override
    public long[] getCategoryInfo(String categoryId, FAQSetting setting) throws Exception {
        return this.jcrData_.getCategoryInfo(categoryId, setting);
    }

    @Override
    public Category getCategoryById(String categoryId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getCategoryById(categoryId);
    }

    @Override
    public Category getCategoryById(String categoryId) throws Exception {
        return this.jcrData_.getCategoryById(categoryId);
    }

    @Override
    public Question getQuestionById(String questionId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getQuestionById(questionId);
    }

    @Override
    public Question getQuestionById(String questionId) throws Exception {
        return this.jcrData_.getQuestionById(questionId);
    }

    @Override
    public QuestionPageList getQuestionsByCatetory(String categoryId, SessionProvider sProvider, FAQSetting faqSetting) throws Exception {
        sProvider.close();
        return this.getQuestionsByCatetory(categoryId, faqSetting);
    }

    @Override
    public QuestionPageList getQuestionsByCatetory(String categoryId, FAQSetting faqSetting) throws Exception {
        return this.jcrData_.getQuestionsByCatetory(categoryId, faqSetting);
    }

    @Override
    public QuestionPageList getAllQuestionsByCatetory(String categoryId, SessionProvider sProvider, FAQSetting faqSetting) throws Exception {
        sProvider.close();
        return this.getAllQuestionsByCatetory(categoryId, faqSetting);
    }

    @Override
    public QuestionPageList getAllQuestionsByCatetory(String categoryId, FAQSetting faqSetting) throws Exception {
        return this.jcrData_.getAllQuestionsByCatetory(categoryId, faqSetting);
    }

    @Override
    public QuestionPageList getQuestionsByListCatetory(List<String> listCategoryId, boolean isNotYetAnswer, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getQuestionsByListCatetory(listCategoryId, isNotYetAnswer);
    }

    @Override
    public QuestionPageList getQuestionsByListCatetory(List<String> listCategoryId, boolean isNotYetAnswer) throws Exception {
        return this.jcrData_.getQuestionsByListCatetory(listCategoryId, isNotYetAnswer);
    }

    @Override
    public String getCategoryPathOfQuestion(String questionPath, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getCategoryPathOfQuestion(questionPath);
    }

    @Override
    public String getCategoryPathOfQuestion(String questionPath) throws Exception {
        return this.jcrData_.getCategoryPathOfQuestion(questionPath);
    }

    @Override
    public List<QuestionLanguage> getQuestionLanguages(String questionId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getQuestionLanguages(questionId);
    }

    @Override
    public List<QuestionLanguage> getQuestionLanguages(String questionId) throws Exception {
        return this.jcrData_.getQuestionLanguages(questionId);
    }

    @Override
    public List<Category> getSubCategories(String categoryId, SessionProvider sProvider, FAQSetting faqSetting, boolean isGetAll, List<String> userView) throws Exception {
        sProvider.close();
        return this.getSubCategories(categoryId, faqSetting, isGetAll, userView);
    }

    @Override
    public List<Category> getSubCategories(String categoryId, FAQSetting faqSetting, boolean isGetAll, List<String> userView) throws Exception {
        return this.jcrData_.getSubCategories(categoryId, faqSetting, isGetAll, userView);
    }

    @Override
    public void moveQuestions(List<String> questions, String destCategoryId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.moveQuestions(questions, destCategoryId, "", new FAQSetting());
    }

    @Override
    public void moveQuestions(List<String> questions, String destCategoryId, String questionLink, FAQSetting faqSetting) throws Exception {
        this.jcrData_.moveQuestions(questions, destCategoryId, questionLink, faqSetting);
    }

    @Override
    public void removeCategory(String categoryId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.removeCategory(categoryId);
    }

    @Override
    public void removeCategory(String categoryId) throws Exception {
        this.jcrData_.removeCategory(categoryId);
    }

    @Override
    public void removeQuestion(String questionId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.removeQuestion(questionId);
    }

    @Override
    public void removeQuestion(String questionId) throws Exception {
        this.jcrData_.removeQuestion(questionId);
    }

    @Override
    public void saveCategory(String parentId, Category cat, boolean isAddNew, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveCategory(parentId, cat, isAddNew);
    }

    @Override
    public void saveCategory(String parentId, Category cat, boolean isAddNew) throws Exception {
        this.jcrData_.saveCategory(parentId, cat, isAddNew);
    }

    @Override
    public void changeStatusCategoryView(List<String> listCateIds, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.changeStatusCategoryView(listCateIds);
    }

    @Override
    public void changeStatusCategoryView(List<String> listCateIds) throws Exception {
        this.jcrData_.changeStatusCategoryView(listCateIds);
    }

    @Override
    public Node saveQuestion(Question question, boolean isAddNew, SessionProvider sProvider, FAQSetting faqSetting) throws Exception {
        sProvider.close();
        return this.saveQuestion(question, isAddNew, faqSetting);
    }

    @Override
    public Node saveQuestion(Question question, boolean isAddNew, FAQSetting faqSetting) throws Exception {
        Node questionNode = this.jcrData_.saveQuestion(question, isAddNew, faqSetting);
        for (QuestionLanguage lang : question.getMultiLanguages()) {
            if (lang.getState().equals(QuestionLanguage.ADD_NEW) || lang.getState().equals(QuestionLanguage.EDIT)) {
                MultiLanguages.addLanguage(questionNode, lang);
                continue;
            }
            if (!lang.getState().equals(QuestionLanguage.DELETE)) continue;
            MultiLanguages.removeLanguage(questionNode, lang);
        }
        return questionNode;
    }

    @Override
    public void saveFAQSetting(FAQSetting faqSetting, String userName, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveFAQSetting(faqSetting, userName);
    }

    @Override
    public void saveFAQSetting(FAQSetting faqSetting, String userName) throws Exception {
        this.jcrData_.saveFAQSetting(faqSetting, userName);
    }

    @Override
    public void moveCategory(String categoryId, String destCategoryId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.moveCategory(categoryId, destCategoryId);
    }

    @Override
    public void moveCategory(String categoryId, String destCategoryId) throws Exception {
        this.jcrData_.moveCategory(categoryId, destCategoryId);
    }

    @Override
    public void addWatch(String id, Watch watch, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.addWatchCategory(id, watch);
    }

    @Override
    public void addWatchCategory(String id, Watch watch) throws Exception {
        this.jcrData_.addWatchCategory(id, watch);
    }

    @Override
    public void deleteMailInWatch(String categoryId, SessionProvider sProvider, String user) throws Exception {
        sProvider.close();
        this.deleteCategoryWatch(categoryId, user);
    }

    @Override
    public void deleteCategoryWatch(String categoryId, String user) throws Exception {
        this.jcrData_.deleteCategoryWatch(categoryId, user);
    }

    @Override
    public void UnWatch(String categoryId, SessionProvider sProvider, String userCurrent) throws Exception {
        sProvider.close();
        this.unWatchCategory(categoryId, userCurrent);
    }

    @Override
    public void unWatchCategory(String categoryId, String userCurrent) throws Exception {
        this.jcrData_.unWatchCategory(categoryId, userCurrent);
    }

    @Override
    public void UnWatchQuestion(String questionID, SessionProvider sProvider, String userCurrent) throws Exception {
        sProvider.close();
        this.unWatchQuestion(questionID, userCurrent);
    }

    @Override
    public void unWatchQuestion(String questionID, String userCurrent) throws Exception {
        this.jcrData_.unWatchQuestion(questionID, userCurrent);
    }

    @Override
    public List<String> getListCateIdByModerator(String user, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getListCateIdByModerator(user);
    }

    @Override
    public List<String> getListCateIdByModerator(String user) throws Exception {
        return this.jcrData_.getListCateIdByModerator(user);
    }

    @Override
    public List<ObjectSearchResult> getSearchResults(FAQEventQuery eventQuery) throws Exception {
        return this.jcrData_.getSearchResults(eventQuery);
    }

    @Override
    public List<String> getCategoryPath(SessionProvider sProvider, String categoryId) throws Exception {
        sProvider.close();
        return this.getCategoryPath(categoryId);
    }

    @Override
    public List<String> getCategoryPath(String categoryId) throws Exception {
        return this.jcrData_.getCategoryPath(categoryId);
    }

    @Override
    public void sendMessage(Message message) throws Exception {
        this.jcrData_.sendMessage(message);
    }

    @Override
    public void addLanguage(Node questionNode, QuestionLanguage language) throws Exception {
        MultiLanguages.addLanguage(questionNode, language);
    }

    @Override
    public void getUserSetting(SessionProvider sProvider, String userName, FAQSetting faqSetting) throws Exception {
        sProvider.close();
        this.getUserSetting(userName, faqSetting);
    }

    @Override
    public void getUserSetting(String userName, FAQSetting faqSetting) throws Exception {
        this.jcrData_.getUserSetting(userName, faqSetting);
    }

    @Override
    public NotifyInfo getMessageInfo(String name) throws Exception {
        return this.jcrData_.getMessageInfo(name);
    }

    @Override
    public boolean isAdminRole(String userName, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.isAdminRole(userName);
    }

    @Override
    public boolean isAdminRole(String userName) throws Exception {
        return this.jcrData_.isAdminRole(userName);
    }

    @Override
    public Node getCategoryNodeById(String categoryId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getCategoryNodeById(categoryId);
    }

    @Override
    public Node getCategoryNodeById(String categoryId) throws Exception {
        return this.jcrData_.getCategoryNodeById(categoryId);
    }

    @Override
    public void addWatchQuestion(String questionId, Watch watch, boolean isNew, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.addWatchQuestion(questionId, watch, isNew);
    }

    @Override
    public void addWatchQuestion(String questionId, Watch watch, boolean isNew) throws Exception {
        this.jcrData_.addWatchQuestion(questionId, watch, isNew);
    }

    @Override
    public QuestionPageList getListQuestionsWatch(FAQSetting faqSetting, String currentUser, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getListQuestionsWatch(faqSetting, currentUser);
    }

    @Override
    public QuestionPageList getListQuestionsWatch(FAQSetting faqSetting, String currentUser) throws Exception {
        return this.jcrData_.getListQuestionsWatch(faqSetting, currentUser);
    }

    @Override
    public void importData(String categoryId, Session session, InputStream inputStream, boolean isZip, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.importData(categoryId, inputStream, isZip);
    }

    @Override
    public boolean importData(String categoryId, InputStream inputStream, boolean isZip) throws Exception {
        return this.jcrData_.importData(categoryId, inputStream, isZip);
    }

    @Override
    public InputStream exportData(String categoryId, boolean createZipFile) throws Exception {
        return this.jcrData_.exportData(categoryId, createZipFile);
    }

    @Override
    public void swapCategories(String parentCateId, String cateId1, String cateId2, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.swapCategories(cateId1, cateId2);
    }

    @Override
    public void swapCategories(String cateId1, String cateId2) throws Exception {
        this.jcrData_.swapCategories(cateId1, cateId2);
    }

    @Override
    public void saveTopicIdDiscussQuestion(String questionId, String pathDiscuss, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveTopicIdDiscussQuestion(questionId, pathDiscuss);
    }

    @Override
    public void saveTopicIdDiscussQuestion(String questionId, String pathDiscuss) throws Exception {
        this.jcrData_.saveTopicIdDiscussQuestion(questionId, pathDiscuss);
    }

    @Override
    public long getMaxindexCategory(String parentId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getMaxindexCategory(parentId);
    }

    @Override
    public long getMaxindexCategory(String parentId) throws Exception {
        return this.jcrData_.getMaxindexCategory(parentId);
    }

    @Override
    public void deleteAnswer(String questionId, String answerId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.deleteAnswer(questionId, answerId);
    }

    @Override
    public void deleteAnswer(String questionId, String answerId) throws Exception {
        this.jcrData_.deleteAnswer(questionId, answerId);
    }

    @Override
    public void deleteComment(String questionId, String commentId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.deleteComment(questionId, commentId);
    }

    @Override
    public void deleteComment(String questionId, String commentId) throws Exception {
        this.jcrData_.deleteComment(questionId, commentId);
    }

    @Override
    public void saveAnswer(String questionId, Answer answer, boolean isNew, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveAnswer(questionId, answer, isNew);
    }

    @Override
    public void saveAnswer(String questionId, Answer answer, boolean isNew) throws Exception {
        this.jcrData_.saveAnswer(questionId, answer, isNew);
    }

    @Override
    public void saveComment(String questionId, Comment comment, boolean isNew, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveComment(questionId, comment, isNew);
    }

    @Override
    public void saveComment(String questionId, Comment comment, boolean isNew) throws Exception {
        this.jcrData_.saveComment(questionId, comment, isNew);
    }

    @Override
    public Comment getCommentById(SessionProvider sProvider, String questionId, String commentId) throws Exception {
        sProvider.close();
        return this.getCommentById(questionId, commentId);
    }

    @Override
    public Comment getCommentById(String questionId, String commentId) throws Exception {
        return this.jcrData_.getCommentById(questionId, commentId);
    }

    @Override
    public Answer getAnswerById(String questionId, String answerid, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getAnswerById(questionId, answerid);
    }

    @Override
    public Answer getAnswerById(String questionId, String answerid) throws Exception {
        return this.jcrData_.getAnswerById(questionId, answerid);
    }

    @Override
    public void saveAnswer(String questionId, Answer[] answers, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveAnswer(questionId, answers);
    }

    @Override
    public void saveAnswer(String questionId, Answer[] answers) throws Exception {
        this.jcrData_.saveAnswer(questionId, answers);
    }

    @Override
    public JCRPageList getPageListAnswer(SessionProvider sProvider, String questionId, Boolean isSortByVote) throws Exception {
        sProvider.close();
        return this.getPageListAnswer(questionId, isSortByVote);
    }

    @Override
    public JCRPageList getPageListAnswer(String questionId, Boolean isSortByVote) throws Exception {
        return this.jcrData_.getPageListAnswer(questionId, isSortByVote);
    }

    @Override
    public JCRPageList getPageListComment(SessionProvider sProvider, String questionId) throws Exception {
        sProvider.close();
        return this.getPageListComment(questionId);
    }

    @Override
    public JCRPageList getPageListComment(String questionId) throws Exception {
        return this.jcrData_.getPageListComment(questionId);
    }

    @Override
    public QuestionPageList getListCategoriesWatch(String userId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getWatchedCategoryByUser(userId);
    }

    @Override
    public QuestionPageList getWatchedCategoryByUser(String userId) throws Exception {
        return this.jcrData_.getWatchedCategoryByUser(userId);
    }

    @Override
    public FileAttachment getUserAvatar(String userName, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getUserAvatar(userName);
    }

    @Override
    public FileAttachment getUserAvatar(String userName) throws Exception {
        return this.jcrData_.getUserAvatar(userName);
    }

    @Override
    public void saveUserAvatar(String userId, FileAttachment fileAttachment, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveUserAvatar(userId, fileAttachment);
    }

    @Override
    public void saveUserAvatar(String userId, FileAttachment fileAttachment) throws Exception {
        this.jcrData_.saveUserAvatar(userId, fileAttachment);
    }

    @Override
    public void setDefaultAvatar(String userName, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.setDefaultAvatar(userName);
    }

    @Override
    public void setDefaultAvatar(String userName) throws Exception {
        this.jcrData_.setDefaultAvatar(userName);
    }

    @Override
    public boolean getWatchByUser(String userId, String cateId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.isUserWatched(userId, cateId);
    }

    @Override
    public boolean isUserWatched(String userId, String cateId) {
        return this.jcrData_.isUserWatched(userId, cateId);
    }

    @Override
    public QuestionPageList getPendingQuestionsByCategory(String categoryId, SessionProvider sProvider, FAQSetting faqSetting) throws Exception {
        sProvider.close();
        return this.getPendingQuestionsByCategory(categoryId, faqSetting);
    }

    @Override
    public QuestionPageList getPendingQuestionsByCategory(String categoryId, FAQSetting faqSetting) throws Exception {
        return this.jcrData_.getPendingQuestionsByCategory(categoryId, faqSetting);
    }

    @Override
    public NodeIterator getQuestionsIterator(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getQuestionsIterator();
    }

    @Override
    public NodeIterator getQuestionsIterator() throws Exception {
        return this.jcrData_.getQuestionsIterator();
    }

    @Override
    public boolean isExisting(String path) {
        return this.jcrData_.isExisting(path);
    }

    @Override
    public String getCategoryPathOf(String id) throws Exception {
        return this.jcrData_.getCategoryPathOf(id);
    }

    @Override
    public List<String> getQuestionContents(List<String> paths) throws Exception {
        return this.jcrData_.getQuestionContents(paths);
    }

    @Override
    public Node getQuestionNodeById(String path) throws Exception {
        return this.jcrData_.getQuestionNodeById(path);
    }

    @Override
    public boolean isModerateAnswer(String id) throws Exception {
        return this.jcrData_.isModerateAnswer(id);
    }

    @Override
    public boolean isModerateQuestion(String id) throws Exception {
        return this.jcrData_.isModerateQuestion(id);
    }

    @Override
    public String getParentCategoriesName(String path) throws Exception {
        return this.jcrData_.getParentCategoriesName(path);
    }

    @Override
    public QuestionPageList getListMailInWatch(String categoryId) throws Exception {
        return this.jcrData_.getListMailInWatch(categoryId);
    }

    @Override
    public boolean isCategoryModerator(String categoryPath, String user) throws Exception {
        return this.jcrData_.isCategoryModerator(categoryPath, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLanguage(String questionPath, QuestionLanguage language) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.addLanguage(questionNode, language);
        }
        catch (Exception e) {
            log.error((Object)"Failed to add language.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAnswerQuestionLang(String questionPath, String answerId, String language) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.deleteAnswerQuestionLang(questionNode, answerId, language);
        }
        catch (Exception e) {
            log.error((Object)"Failed to delete answer language.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCommentQuestionLang(String questionPath, String commentId, String language) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.deleteCommentQuestionLang(questionNode, commentId, language);
        }
        catch (Exception e) {
            log.error((Object)"Failed to delete comment language.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuestionLanguage getQuestionLanguageByLanguage(String questionPath, String language) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            QuestionLanguage questionLanguage = MultiLanguages.getQuestionLanguageByLanguage(questionNode, language);
            return questionLanguage;
        }
        catch (Exception e) {
            log.error((Object)("Failed to get question by language:" + language), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comment getCommentById(String questionPath, String commentId, String language) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            Comment comment = MultiLanguages.getCommentById(questionNode, commentId, language);
            return comment;
        }
        catch (Exception e) {
            log.error((Object)("Failed to get comment by id:" + commentId), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Answer getAnswerById(String questionPath, String answerid, String language) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            Answer answer = MultiLanguages.getAnswerById(questionNode, answerid, language);
            return answer;
        }
        catch (Exception e) {
            log.error((Object)("Failed to get answer by id:" + answerid), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAnswer(String questionPath, Answer answer, String language) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.saveAnswer(questionNode, answer, language);
        }
        catch (Exception e) {
            log.error((Object)"Failed to save answer.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAnswer(String questionPath, QuestionLanguage questionLanguage) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.saveAnswer(questionNode, questionLanguage);
        }
        catch (Exception e) {
            log.error((Object)"Failed to save answer.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveComment(String questionPath, Comment comment, String languge) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.saveComment(questionNode, comment, languge);
        }
        catch (Exception e) {
            log.error((Object)"Failed to save comment.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLanguage(String questionPath, List<String> listLanguage) {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.removeLanguage(questionNode, listLanguage);
        }
        catch (Exception e) {
            log.error((Object)"Failed to remove language.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void voteAnswer(String answerPath, String userName, boolean isUp) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node answerNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(answerPath);
            MultiLanguages.voteAnswer(answerNode, userName, isUp);
        }
        catch (Exception e) {
            log.error((Object)"Failed to vote answer.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void voteQuestion(String questionPath, String userName, int number) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.voteQuestion(questionNode, userName, number);
        }
        catch (Exception e) {
            log.error((Object)"Failed to vote question.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unVoteQuestion(String questionPath, String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.unVoteQuestion(questionNode, userName);
        }
        catch (Exception e) {
            log.error((Object)"Failed to unvote question", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public String[] getModeratorsOf(String path) throws Exception {
        return this.jcrData_.getModeratorsOf(path);
    }

    @Override
    public boolean isViewAuthorInfo(String id) throws Exception {
        return this.jcrData_.isViewAuthorInfo(id);
    }

    @Override
    public long existingCategories() throws Exception {
        return this.jcrData_.existingCategories();
    }

    @Override
    public String getCategoryNameOf(String categoryPath) throws Exception {
        return this.jcrData_.getCategoryNameOf(categoryPath);
    }

    @Override
    public List<Question> getQuickQuestionsByListCatetory(List<String> listCategoryId, boolean isNotYetAnswer) throws Exception {
        return this.jcrData_.getQuickQuestionsByListCatetory(listCategoryId, isNotYetAnswer);
    }

    @Override
    public List<Cate> listingCategoryTree() throws Exception {
        return this.jcrData_.listingCategoryTree();
    }

    @Override
    public List<Watch> getWatchByCategory(String categoryId) throws Exception {
        return this.jcrData_.getWatchByCategory(categoryId);
    }

    @Override
    public boolean hasWatch(String categoryPath) {
        return this.jcrData_.hasWatch(categoryPath);
    }

    @Override
    public CategoryInfo getCategoryInfo(String categoryPath, List<String> categoryIdScoped) throws Exception {
        return this.jcrData_.getCategoryInfo(categoryPath, categoryIdScoped);
    }

    @Override
    public byte[] getTemplate() throws Exception {
        return this.jcrData_.getTemplate();
    }

    @Override
    public void saveTemplate(String str) throws Exception {
        this.jcrData_.saveTemplate(str);
    }

    @Override
    public void updateQuestionRelatives(String questionPath, String[] relatives) throws Exception {
        this.jcrData_.updateQuestionRelatives(questionPath, relatives);
    }

    @Override
    public boolean isCategoryExist(String name, String path) {
        return this.jcrData_.isCategoryExist(name, path);
    }

    @Override
    public void saveBBCode(List<BBCode> bbcodes) throws Exception {
        this.bbcodeObject_.saveBBCode(bbcodes);
    }

    @Override
    public List<BBCode> getAllBBCode() throws Exception {
        return this.bbcodeObject_.getAllBBCode();
    }

    @Override
    public List<String> getActiveBBCode() throws Exception {
        return this.bbcodeObject_.getActiveBBCode();
    }

    @Override
    public BBCode getBBcode(String id) throws Exception {
        return this.bbcodeObject_.getBBcode(id);
    }

    @Override
    public void removeBBCode(String bbcodeId) throws Exception {
        this.bbcodeObject_.removeBBCode(bbcodeId);
    }
}

